/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.intentions.openInProject;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ProjectRootFinder {
    ProjectRootFinder() {
    }

    @Nullable
    VirtualFile findProjectRoot(@NotNull VirtualFile sourceFile) {
        for (VirtualFile parent = sourceFile.getParent(); parent != null; parent = parent.getParent()) {
            if (this.isProjectDir(parent)) {
                return parent;
            }
            ProgressManager.checkCanceled();
        }
        return null;
    }

    protected abstract boolean isProjectDir(@NotNull VirtualFile var1);

    protected abstract boolean requiresConfirmation();

    protected boolean containsChild(@NotNull VirtualFile file2, @NotNull Predicate<VirtualFile> predicate) {
        if (file2.isDirectory()) {
            for (VirtualFile child2 : file2.getChildren()) {
                if (!predicate.test(child2)) continue;
                return true;
            }
        }
        return false;
    }
}

