/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.instrument;

import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EDT;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.AdviceAdapter;

final class LockWrappingClassVisitor
extends ClassVisitor {
    @NonNls
    private static final Set<String> METHODS_TO_WRAP = ContainerUtil.set((Object[])new String[]{"paint", "paintComponent", "paintChildren", "doLayout", "layout", "getPreferredSize", "paintTrack", "getListCellRendererComponent", "getElementText"});
    @NotNull
    private final String myClassName;
    @NotNull
    private final Set<String> myMethodsToAnnotate;

    LockWrappingClassVisitor(ClassWriter cw, @NotNull String className, @NotNull Set<String> methodsToAnnotate) {
        super(524288, (ClassVisitor)cw);
        this.myClassName = className.replace('/', '.');
        this.myMethodsToAnnotate = methodsToAnnotate;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor2, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, descriptor2, signature, exceptions);
        if (METHODS_TO_WRAP.contains(name) || this.myMethodsToAnnotate.contains(name)) {
            return new MyAdviceAdapter(mv, access, name, descriptor2);
        }
        return mv;
    }

    private static boolean acquireWriteIntentLockIfNeeded(@NotNull String invokedClassFqn) {
        if (!EDT.isCurrentThreadEdt()) {
            return false;
        }
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        if (!application.isWriteThread()) {
            return false;
        }
        application.acquireWriteIntentLock(invokedClassFqn);
        return true;
    }

    private static void releaseWriteIntentLockIfNeeded(boolean needed) {
        if (needed) {
            ApplicationManagerEx.getApplicationEx().releaseWriteIntentLock();
        }
    }

    private class MyAdviceAdapter
    extends AdviceAdapter {
        private static final String applicationUtil = "com/intellij/ide/instrument/LockWrappingClassVisitor";
        private static final String acquireLock = "acquireWriteIntentLockIfNeeded";
        private static final String releaseLock = "releaseWriteIntentLockIfNeeded";
        private static final String acquireLockSignature = "(Ljava/lang/String;)Z";
        private static final String releaseLockSignature = "(Z)V";
        private int newVarIndex;

        protected MyAdviceAdapter(MethodVisitor methodVisitor, int access, String name, String descriptor2) {
            super(LockWrappingClassVisitor.this.api, methodVisitor, access, name, descriptor2);
        }

        protected void onMethodEnter() {
            this.newVarIndex = this.newLocal(Type.BOOLEAN_TYPE);
            this.mv.visitLdcInsn((Object)(LockWrappingClassVisitor.this.myClassName + "#" + this.getName()));
            this.mv.visitMethodInsn(184, applicationUtil, acquireLock, acquireLockSignature, false);
            this.mv.visitVarInsn(54, this.newVarIndex);
        }

        protected void onMethodExit(int opcode) {
            this.mv.visitVarInsn(21, this.newVarIndex);
            this.mv.visitMethodInsn(184, applicationUtil, releaseLock, releaseLockSignature, false);
        }
    }
}

