/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.CompositeSelectInTarget;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectSubViewSelectInTarget;
import com.intellij.ide.impl.SelectInTargetPsiWrapper;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.SelectableTreeStructureProvider;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectViewPane;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectViewSelectInTarget
extends SelectInTargetPsiWrapper
implements CompositeSelectInTarget {
    private String mySubId;

    protected ProjectViewSelectInTarget(Project project) {
        super(project);
    }

    @Override
    protected final void select(Object selector, VirtualFile virtualFile, boolean requestFocus) {
        ProjectViewSelectInTarget.select(this.myProject, selector, this.getMinorViewId(), this.mySubId, virtualFile, requestFocus);
    }

    @NotNull
    public static ActionCallback select(@NotNull Project project, Object toSelect2, @Nullable String viewId, @Nullable String subviewId, VirtualFile virtualFile, boolean requestFocus) {
        ProjectView projectView = ProjectView.getInstance(project);
        if (projectView == null) {
            return ActionCallback.REJECTED;
        }
        String id2 = (String)ObjectUtils.chooseNotNull((Object)viewId, (Object)projectView.getDefaultViewId());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            AbstractProjectViewPane pane2 = projectView.getProjectViewPaneById(id2);
            pane2.select(toSelect2, virtualFile, requestFocus);
            return ActionCallback.DONE;
        }
        Supplier<Object> toSelectSupplier = toSelect2 instanceof PsiElement ? () -> ((SmartPsiElementPointer)SmartPointerManager.createPointer((PsiElement)((PsiElement)toSelect2))).getElement() : () -> toSelect2;
        ToolWindow projectViewToolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Project");
        if (projectViewToolWindow == null) {
            return ActionCallback.REJECTED;
        }
        ActionCallback result2 = new ActionCallback();
        Runnable runnable2 = () -> projectView.changeViewCB(id2, subviewId).doWhenProcessed(() -> ProjectViewSelectInTarget.lambda$null$1((Supplier)toSelectSupplier, requestFocus, projectView, id2, result2, virtualFile));
        if (requestFocus) {
            projectViewToolWindow.activate(runnable2, true);
        } else {
            projectViewToolWindow.show(runnable2);
        }
        return result2;
    }

    @NotNull
    public Collection<SelectInTarget> getSubTargets(@NotNull SelectInContext context) {
        ArrayList<SelectInTarget> result2 = new ArrayList<SelectInTarget>();
        AbstractProjectViewPane pane2 = ProjectView.getInstance(this.myProject).getProjectViewPaneById(this.getMinorViewId());
        int index = 0;
        for (String subId : pane2.getSubIds()) {
            result2.add(new ProjectSubViewSelectInTarget(this, subId, index++));
        }
        return result2;
    }

    public boolean isSubIdSelectable(String subId, SelectInContext context) {
        return false;
    }

    @Override
    protected boolean canSelect(PsiFileSystemItem file2) {
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)file2);
        if ((vFile = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)vFile)) == null || !vFile.isValid()) {
            return false;
        }
        return ProjectViewPane.canBeSelectedInProjectView(this.myProject, vFile);
    }

    public String getSubIdPresentableName(String subId) {
        AbstractProjectViewPane pane2 = ProjectView.getInstance(this.myProject).getProjectViewPaneById(this.getMinorViewId());
        return pane2.getPresentableSubIdName(subId);
    }

    @Override
    public void select(PsiElement element2, boolean requestFocus) {
        PsiUtilCore.ensureValid((PsiElement)element2);
        PsiElement toSelect2 = null;
        for (TreeStructureProvider provider : this.getProvidersDumbAware()) {
            if (provider instanceof SelectableTreeStructureProvider) {
                toSelect2 = ((SelectableTreeStructureProvider)provider).getTopLevelElement(element2);
            }
            if (toSelect2 == null) continue;
            if (toSelect2.isValid()) break;
            throw new PsiInvalidElementAccessException(toSelect2, "Returned by " + provider);
        }
        if ((toSelect2 = ProjectViewSelectInTarget.findElementToSelect(element2, toSelect2)) != null) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)toSelect2);
            virtualFile = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)virtualFile);
            this.select(toSelect2, virtualFile, requestFocus);
        }
    }

    private TreeStructureProvider[] getProvidersDumbAware() {
        List dumbAware = DumbService.getInstance((Project)this.myProject).filterByDumbAwareness((Collection)TreeStructureProvider.EP.getExtensions((AreaInstance)this.myProject));
        return dumbAware.toArray(new TreeStructureProvider[0]);
    }

    public final String getToolWindowId() {
        return "Project";
    }

    public final void setSubId(String subId) {
        this.mySubId = subId;
    }

    public final String getSubId() {
        return this.mySubId;
    }

    private static /* synthetic */ void lambda$null$1(Supplier toSelectSupplier, boolean requestFocus, ProjectView projectView, String id2, ActionCallback result2, VirtualFile virtualFile) {
        AbstractProjectViewPane pane2;
        Object element2 = toSelectSupplier.get();
        AbstractProjectViewPane abstractProjectViewPane = pane2 = requestFocus ? null : projectView.getProjectViewPaneById(id2);
        if (pane2 != null && pane2.isVisibleAndSelected(element2)) {
            result2.setDone();
        } else {
            projectView.selectCB(element2, virtualFile, requestFocus).notify(result2);
        }
    }
}

