/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class HeadlessDataManager
extends DataManagerImpl {
    private volatile DataProvider myTestDataProvider;

    public void setTestDataProvider(@Nullable DataProvider provider) {
        this.myTestDataProvider = provider;
    }

    public void setTestDataProvider(@Nullable DataProvider provider, @NotNull Disposable parentDisposable) {
        DataProvider previous = this.myTestDataProvider;
        this.myTestDataProvider = provider;
        Disposer.register((Disposable)parentDisposable, () -> {
            this.myTestDataProvider = previous;
        });
    }

    @Override
    @NotNull
    public DataContext getDataContext() {
        return new HeadlessContext(this.myTestDataProvider);
    }

    @Override
    @NotNull
    public Promise<DataContext> getDataContextFromFocusAsync() {
        AsyncPromise promise = new AsyncPromise();
        promise.setResult((Object)this.getDataContext());
        return promise;
    }

    @Override
    @NotNull
    public DataContext getDataContext(Component component2) {
        return this.getDataContext();
    }

    @Override
    @NotNull
    public DataContext getDataContext(@NotNull Component component2, int x, int y) {
        return this.getDataContext();
    }

    private static final class HeadlessContext
    extends UserDataHolderBase
    implements DataContext {
        private final DataProvider myProvider;

        HeadlessContext(DataProvider provider) {
            this.myProvider = provider;
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            return this.myProvider != null ? this.myProvider.getData(dataId) : null;
        }
    }
}

