/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.impl;

import com.intellij.codeInsight.editorActions.BraceMatcherBasedSelectioner;
import com.intellij.ide.highlighter.custom.impl.CustomFileTypeQuoteHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CustomFileTypeSelectWordHandler
extends BraceMatcherBasedSelectioner {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        return e.getContainingFile().getFileType() instanceof CustomSyntaxTableFileType;
    }

    @Override
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        List<TextRange> superResult = super.select(e, editorText, cursorOffset, editor);
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(cursorOffset);
        if (CustomFileTypeQuoteHandler.isQuotedToken(iterator2.getTokenType())) {
            ArrayList<TextRange> result2 = new ArrayList<TextRange>();
            int start2 = iterator2.getStart();
            int end = iterator2.getEnd();
            char limitingQuote = CustomFileTypeQuoteHandler.getLimitingQuote(iterator2.getTokenType());
            int startAfterQuote = start2 + (start2 < editorText.length() && editorText.charAt(start2) == limitingQuote ? 1 : 0);
            int endBeforeQuote = end - (end > 0 && editorText.charAt(end - 1) == limitingQuote ? 1 : 0);
            if (start2 < startAfterQuote && end > endBeforeQuote && end - start2 > 1) {
                result2.add(new TextRange(start2, end));
            }
            if (startAfterQuote < endBeforeQuote) {
                result2.add(new TextRange(startAfterQuote, endBeforeQuote));
            }
            if (superResult != null) {
                result2.addAll(superResult);
            }
            return result2;
        }
        return superResult;
    }
}

