/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr.ui;

import com.intellij.ide.gdpr.ui.Styles;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0006J4\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ide/gdpr/ui/HtmlRtfPane;", "", "()V", "linkMap", "", "Lkotlin/ranges/IntRange;", "", "mouseListenersList", "", "Ljava/awt/event/MouseListener;", "mouseMotionListenersList", "Ljava/awt/event/MouseMotionListener;", "resultPane", "Ljavax/swing/JTextPane;", "addHyperlinksListeners", "", "clearMouseListeners", "create", "htmlText", "process", "Ljavax/swing/text/DefaultStyledDocument;", "htmlContent", "replaceText", "newText", "styleNodes", "nodeElement", "Lorg/jsoup/nodes/Element;", "styledDocument", "offsetInDocument", "", "intellij.platform.ide.impl"})
public final class HtmlRtfPane {
    private final Map<IntRange, String> linkMap;
    private final JTextPane resultPane;
    private final List<MouseMotionListener> mouseMotionListenersList;
    private final List<MouseListener> mouseListenersList;

    @NotNull
    public final JTextPane create(@NotNull String htmlText) {
        this.process(htmlText);
        return this.resultPane;
    }

    @NotNull
    public final JTextPane replaceText(@NotNull String newText) {
        this.resultPane.getDocument().remove(0, this.resultPane.getDocument().getLength());
        this.clearMouseListeners();
        this.process(newText);
        return this.resultPane;
    }

    private final void clearMouseListeners() {
        EventListener it;
        Iterable $this$forEach$iv = this.mouseListenersList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MouseListener)element$iv;
            boolean bl = false;
            this.resultPane.removeMouseListener((MouseListener)it);
        }
        this.mouseListenersList.clear();
        $this$forEach$iv = this.mouseMotionListenersList;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MouseMotionListener)element$iv;
            boolean bl = false;
            this.resultPane.removeMouseMotionListener((MouseMotionListener)it);
        }
        this.mouseMotionListenersList.clear();
    }

    private final DefaultStyledDocument process(String htmlContent) {
        Document document = Jsoup.parse((String)htmlContent, (String)"UTF-8");
        Element element2 = (Element)CollectionsKt.firstOrNull((List)((List)document.getElementsByAttributeValue("class", "licenseContent")));
        if (element2 == null) {
            element2 = document.body();
        }
        Element licenseContentNode = element2;
        javax.swing.text.Document document2 = this.resultPane.getDocument();
        if (document2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.swing.text.DefaultStyledDocument");
        }
        DefaultStyledDocument styledDocument = (DefaultStyledDocument)document2;
        Iterable $this$forEach$iv = (Iterable)licenseContentNode.children();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SimpleAttributeSet simpleAttributeSet;
            Element it = (Element)element$iv;
            boolean bl = false;
            String string = it.tagName();
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
            switch (string3) {
                case "H1": {
                    simpleAttributeSet = Styles.INSTANCE.getH1();
                    break;
                }
                case "H2": {
                    simpleAttributeSet = Styles.INSTANCE.getH2();
                    break;
                }
                case "P": {
                    simpleAttributeSet = Styles.INSTANCE.getPARAGRAPH();
                    break;
                }
                default: {
                    simpleAttributeSet = Styles.INSTANCE.getREGULAR();
                }
            }
            SimpleAttributeSet style = simpleAttributeSet;
            int start2 = styledDocument.getLength();
            styledDocument.insertString(styledDocument.getLength(), it.text() + "\n", style);
            styledDocument.setParagraphAttributes(start2, it.text().length() + 1, style, false);
            String string4 = it.tagName();
            boolean bl3 = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toUpperCase()");
            if (!Intrinsics.areEqual((Object)string6, (Object)"P")) continue;
            this.styleNodes(it, styledDocument, start2, this.linkMap);
        }
        this.addHyperlinksListeners();
        return styledDocument;
    }

    private final void addHyperlinksListeners() {
        MouseAdapter cursorListener2 = new MouseAdapter(this){
            final /* synthetic */ HtmlRtfPane this$0;

            public void mouseMoved(@Nullable MouseEvent e) {
                boolean bl;
                block6: {
                    Serializable serializable = e;
                    if (serializable == null || (serializable = ((MouseEvent)serializable).getPoint()) == null || (serializable = ((Point)serializable).getLocation()) == null) {
                        return;
                    }
                    Serializable location = serializable;
                    Iterable $this$any$iv = HtmlRtfPane.access$getLinkMap$p(this.this$0).keySet();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            IntRange it = (IntRange)element$iv;
                            boolean bl2 = false;
                            if (!it.contains(HtmlRtfPane.access$getResultPane$p(this.this$0).viewToModel((Point)location))) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    HtmlRtfPane.access$getResultPane$p(this.this$0).setCursor(new Cursor(12));
                } else {
                    HtmlRtfPane.access$getResultPane$p(this.this$0).setCursor(new Cursor(0));
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        MouseAdapter linkListener2 = new MouseAdapter(this){
            final /* synthetic */ HtmlRtfPane this$0;

            public void mouseClicked(@Nullable MouseEvent e) {
                MouseEvent mouseEvent = e;
                if (mouseEvent != null) {
                    if (mouseEvent.getButton() == 1) {
                        Object v1;
                        block6: {
                            Point location = e.getPoint().getLocation();
                            Iterable $this$firstOrNull$iv = HtmlRtfPane.access$getLinkMap$p(this.this$0).keySet();
                            boolean $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                IntRange it = (IntRange)element$iv;
                                boolean bl = false;
                                if (!it.contains(HtmlRtfPane.access$getResultPane$p(this.this$0).viewToModel(location))) continue;
                                v1 = element$iv;
                                break block6;
                            }
                            v1 = null;
                        }
                        IntRange intRange = v1;
                        if (intRange == null) {
                            return;
                        }
                        IntRange range2 = intRange;
                        String string = (String)HtmlRtfPane.access$getLinkMap$p(this.this$0).get(range2);
                        if (string == null) {
                            return;
                        }
                        String link = string;
                        if (Desktop.isDesktopSupported()) {
                            Desktop.getDesktop().browse(new URI(link));
                        }
                    }
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        this.resultPane.addMouseMotionListener(cursorListener2);
        this.mouseMotionListenersList.add(cursorListener2);
        this.resultPane.addMouseListener(linkListener2);
        this.mouseListenersList.add(linkListener2);
    }

    private final void styleNodes(Element nodeElement, DefaultStyledDocument styledDocument, int offsetInDocument, Map<IntRange, String> linkMap) {
        SimpleAttributeSet style;
        int currentOffset = offsetInDocument;
        String string = nodeElement.tagName();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
        switch (string3) {
            case "STRONG": {
                SimpleAttributeSet simpleAttributeSet = Styles.INSTANCE.getBOLD();
                break;
            }
            case "A": {
                String linkUrl = nodeElement.attr("href");
                linkMap.put(new IntRange(currentOffset, currentOffset + nodeElement.text().length() + 1), linkUrl);
                SimpleAttributeSet simpleAttributeSet = Styles.INSTANCE.getLINK();
                break;
            }
            case "HINT": {
                SimpleAttributeSet simpleAttributeSet = Styles.INSTANCE.getHINT();
                break;
            }
            case "SUP": {
                SimpleAttributeSet simpleAttributeSet = null;
                break;
            }
            default: {
                SimpleAttributeSet simpleAttributeSet = style = Styles.INSTANCE.getREGULAR();
            }
        }
        if (style != null) {
            styledDocument.setCharacterAttributes(offsetInDocument, nodeElement.text().length(), style, false);
        }
        if (nodeElement.childNodes().isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = nodeElement.childNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl2 = false;
            if (it instanceof TextNode) {
                int n;
                if (it.siblingIndex() == 0) {
                    Object e = nodeElement.textNodes().get(0);
                    if (e == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jsoup.nodes.TextNode");
                    }
                    n = StringsKt.trimIndent((String)((TextNode)e).text()).length();
                } else {
                    n = ((TextNode)it).text().length();
                }
                int length = n;
                currentOffset += length;
            }
            if (!(it instanceof Element)) continue;
            this.styleNodes((Element)it, styledDocument, currentOffset, linkMap);
        }
    }

    public HtmlRtfPane() {
        boolean bl = false;
        this.linkMap = new LinkedHashMap();
        this.resultPane = new JTextPane();
        bl = false;
        this.mouseMotionListenersList = new ArrayList();
        bl = false;
        this.mouseListenersList = new ArrayList();
    }

    public static final /* synthetic */ Map access$getLinkMap$p(HtmlRtfPane $this) {
        return $this.linkMap;
    }

    public static final /* synthetic */ JTextPane access$getResultPane$p(HtmlRtfPane $this) {
        return $this.resultPane;
    }
}

