/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import org.jetbrains.annotations.NotNull;

public final class VelocityTemplateContext {
    private static final ThreadLocal<FileTemplateManager> ourTemplateManager = new ThreadLocal();

    public static <T, E extends Throwable> T withContext(Project project, @NotNull ThrowableComputable<T, E> computable) throws E {
        try {
            ourTemplateManager.set(project == null ? FileTemplateManager.getDefaultInstance() : FileTemplateManager.getInstance(project));
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            ourTemplateManager.set(null);
        }
    }

    @NotNull
    public static FileTemplateManager getFromContext() {
        FileTemplateManager manager = ourTemplateManager.get();
        return manager == null ? FileTemplateManager.getDefaultInstance() : manager;
    }
}

