/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.AbstractModuleNode;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddToFavoritesAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(AddToFavoritesAction.class);
    private final String myFavoritesListName;

    public AddToFavoritesAction(String choosenList) {
        this.getTemplatePresentation().setText(choosenList, false);
        this.myFavoritesListName = choosenList;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Collection<AbstractTreeNode<?>> nodesToAdd = AddToFavoritesAction.getNodesToAdd(dataContext, true);
        if (!nodesToAdd.isEmpty()) {
            Project project = e.getProject();
            FavoritesManager.getInstance(project).addRoots(this.myFavoritesListName, nodesToAdd);
        }
    }

    @NotNull
    public static Collection<AbstractTreeNode<?>> getNodesToAdd(DataContext dataContext, boolean inProjectView) {
        Object elements2;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return Collections.emptyList();
        }
        Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        Collection nodesToAdd = null;
        for (FavoriteNodeProvider provider : (FavoriteNodeProvider[])FavoriteNodeProvider.EP_NAME.getExtensions((AreaInstance)project)) {
            Collection nodes = provider.getFavoriteNodes(dataContext, (ViewSettings)ProjectViewSettings.Immutable.DEFAULT);
            if (nodes == null || nodes.isEmpty()) continue;
            nodesToAdd = nodes;
            break;
        }
        if (nodesToAdd == null && (elements2 = AddToFavoritesAction.collectSelectedElements(dataContext)) != null) {
            nodesToAdd = AddToFavoritesAction.createNodes(project, moduleContext, elements2, inProjectView, ProjectViewSettings.Immutable.DEFAULT);
        }
        return nodesToAdd == null ? Collections.emptyList() : nodesToAdd;
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(AddToFavoritesAction.canCreateNodes(e, this.myFavoritesListName));
    }

    public static boolean canCreateNodes(@NotNull AnActionEvent e) {
        return AddToFavoritesAction.canCreateNodes(e, null);
    }

    public static boolean canCreateNodes(@NotNull AnActionEvent e, @Nullable String listName) {
        DataContext dataContext = e.getDataContext();
        if (e.getProject() == null) {
            return false;
        }
        if (e.getPlace().equals("FavoritesPopup") && FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(dataContext) == null) {
            return false;
        }
        boolean inProjectView = e.getPlace().equals("J2EEViewPopup") || e.getPlace().equals("StructureViewPopup") || e.getPlace().equals("ProjectViewPopup");
        Collection<AbstractTreeNode<?>> nodes = AddToFavoritesAction.getNodesToAdd(dataContext, inProjectView);
        if (listName != null && !nodes.isEmpty()) {
            return FavoritesManager.getInstance(e.getProject()).canAddRoots(listName, nodes);
        }
        return !nodes.isEmpty();
    }

    static Object retrieveData(Object object, Object data2) {
        return object == null ? data2 : object;
    }

    private static Object collectSelectedElements(DataContext dataContext) {
        Object elements2 = AddToFavoritesAction.retrieveData(null, CommonDataKeys.PSI_ELEMENT.getData(dataContext));
        elements2 = AddToFavoritesAction.retrieveData(elements2, LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext));
        elements2 = AddToFavoritesAction.retrieveData(elements2, CommonDataKeys.PSI_FILE.getData(dataContext));
        elements2 = AddToFavoritesAction.retrieveData(elements2, ModuleGroup.ARRAY_DATA_KEY.getData(dataContext));
        elements2 = AddToFavoritesAction.retrieveData(elements2, LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext));
        elements2 = AddToFavoritesAction.retrieveData(elements2, LibraryGroupElement.ARRAY_DATA_KEY.getData(dataContext));
        elements2 = AddToFavoritesAction.retrieveData(elements2, NamedLibraryElement.ARRAY_DATA_KEY.getData(dataContext));
        elements2 = AddToFavoritesAction.retrieveData(elements2, CommonDataKeys.VIRTUAL_FILE.getData(dataContext));
        elements2 = AddToFavoritesAction.retrieveData(elements2, CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext));
        return elements2;
    }

    @NotNull
    public static Collection<AbstractTreeNode<?>> createNodes(Project project, Module moduleContext, Object object, boolean inProjectView, @NotNull ViewSettings favoritesConfig) {
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList result2 = new ArrayList();
        for (FavoriteNodeProvider favoriteNodeProvider : (FavoriteNodeProvider[])FavoriteNodeProvider.EP_NAME.getExtensions((AreaInstance)project)) {
            AbstractTreeNode treeNode = favoriteNodeProvider.createNode(project, (Object)object, favoritesConfig);
            if (treeNode == null) continue;
            result2.add(treeNode);
            return result2;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        String currentViewId = ProjectView.getInstance(project).getCurrentViewId();
        AbstractProjectViewPane pane2 = ProjectView.getInstance(project).getProjectViewPaneById(currentViewId);
        if (object instanceof PsiElement[]) {
            for (PsiElement psiElement : (PsiElement[])object) {
                AddToFavoritesAction.addPsiElementNode(psiElement, project, result2, favoritesConfig);
            }
            return result2;
        }
        if (object instanceof PsiElement) {
            Object var9_13 = null;
            if (inProjectView && ProjectView.getInstance(project).isShowModules(currentViewId) && pane2 != null && pane2.getSelectedDescriptor() != null && pane2.getSelectedDescriptor().getElement() instanceof AbstractTreeNode) {
                AbstractTreeNode abstractTreeNode;
                for (abstractTreeNode = (AbstractTreeNode)pane2.getSelectedDescriptor().getElement(); abstractTreeNode != null && !(abstractTreeNode.getParent() instanceof AbstractModuleNode); abstractTreeNode = abstractTreeNode.getParent()) {
                }
                if (abstractTreeNode != null) {
                    Module module = (Module)((AbstractModuleNode)abstractTreeNode.getParent()).getValue();
                }
            }
            AddToFavoritesAction.addPsiElementNode((PsiElement)object, project, result2, favoritesConfig);
            return result2;
        }
        if (object instanceof VirtualFile[]) {
            for (VirtualFile vFile : (VirtualFile[])object) {
                PsiFile element2 = psiManager.findFile(vFile);
                if (element2 == null) {
                    element2 = psiManager.findDirectory(vFile);
                }
                AddToFavoritesAction.addPsiElementNode((PsiElement)element2, project, result2, favoritesConfig);
            }
            return result2;
        }
        if (object instanceof VirtualFile) {
            VirtualFile virtualFile = (VirtualFile)object;
            PsiFile psiFile = psiManager.findFile(virtualFile);
            AddToFavoritesAction.addPsiElementNode((PsiElement)psiFile, project, result2, favoritesConfig);
            return result2;
        }
        if (object instanceof ModuleGroup[]) {
            for (ModuleGroup moduleGroup : (ModuleGroup[])object) {
                result2.add((AbstractTreeNode<?>)new ProjectViewModuleGroupNode(project, moduleGroup, favoritesConfig));
            }
            return result2;
        }
        if (object instanceof Module) {
            object = new Module[]{(Module)object};
        }
        if (object instanceof Module[]) {
            for (Module module1 : object) {
                result2.add((AbstractTreeNode<?>)new ProjectViewModuleNode(project, module1, favoritesConfig));
            }
            return result2;
        }
        if (object instanceof LibraryGroupElement[]) {
            for (LibraryGroupElement libraryGroup : (LibraryGroupElement[])object) {
                result2.add((AbstractTreeNode<?>)new LibraryGroupNode(project, libraryGroup, favoritesConfig));
            }
            return result2;
        }
        if (object instanceof NamedLibraryElement[]) {
            for (NamedLibraryElement namedLibrary : (NamedLibraryElement[])object) {
                result2.add((AbstractTreeNode<?>)new NamedLibraryElementNode(project, namedLibrary, favoritesConfig));
            }
            return result2;
        }
        return result2;
    }

    private static void addPsiElementNode(PsiElement psiElement, Project project, ArrayList<? super AbstractTreeNode<?>> result2, @NotNull ViewSettings favoritesConfig) {
        Class<Object> klass = AddToFavoritesAction.getPsiElementNodeClass(psiElement);
        if (klass == null && (psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiFile.class)) != null) {
            klass = PsiFileNode.class;
        }
        PsiElement value2 = psiElement;
        try {
            if (klass != null && value2 != null) {
                result2.add(ProjectViewNode.createTreeNode(klass, (Project)project, (Object)value2, (ViewSettings)favoritesConfig));
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static Class<? extends AbstractTreeNode<?>> getPsiElementNodeClass(PsiElement psiElement) {
        Class klass = null;
        if (psiElement instanceof PsiFile) {
            klass = PsiFileNode.class;
        } else if (psiElement instanceof PsiDirectory) {
            klass = PsiDirectoryNode.class;
        }
        return klass;
    }
}

