/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.ProjectViewNodeWithChildrenList;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsagePresentation;
import org.jetbrains.annotations.NotNull;

public class UsageProjectTreeNode
extends ProjectViewNodeWithChildrenList<UsageInfo> {
    private final UsagePresentation myUsagePresentation;

    public UsageProjectTreeNode(Project project, @NotNull UsageInfo usage, ViewSettings viewSettings) {
        super(project, usage, viewSettings);
        UsageInfo2UsageAdapter adapter2 = new UsageInfo2UsageAdapter(usage);
        this.myUsagePresentation = adapter2.getPresentation();
    }

    public boolean contains(@NotNull VirtualFile file2) {
        UsageInfo info = (UsageInfo)this.getValue();
        if (info == null) {
            return false;
        }
        PsiElement element2 = info.getElement();
        return element2 != null && file2.equals(element2.getContainingFile().getVirtualFile());
    }

    public String toString() {
        return this.myUsagePresentation.getPlainText();
    }

    protected void update(@NotNull PresentationData presentation2) {
        presentation2.setIcon(this.myUsagePresentation.getIcon());
        presentation2.setTooltip(this.myUsagePresentation.getTooltipText());
        Object[] text = this.myUsagePresentation.getText();
        UsageProjectTreeNode.updatePresentationWithTextChunks(presentation2, (TextChunk[])text);
        presentation2.setPresentableText(StringUtil.join((Object[])text, chunk -> chunk.getText(), (String)""));
    }

    public static void updatePresentationWithTextChunks(PresentationData presentation2, TextChunk[] text) {
        for (TextChunk chunk : text) {
            presentation2.addText(chunk.getText(), chunk.getSimpleAttributesIgnoreBackground());
        }
    }

    public void navigate(boolean requestFocus) {
        UsageViewUtil.navigateTo((UsageInfo)this.getValue(), requestFocus);
    }

    public boolean canNavigate() {
        return this.canNavigateToSource();
    }

    public boolean canNavigateToSource() {
        return ((UsageInfo)this.getValue()).getElement().isValid();
    }
}

