/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FileGroupingProjectNode;
import com.intellij.ide.favoritesTreeView.FileSerializable;
import com.intellij.ide.favoritesTreeView.InvalidUsageNoteNode;
import com.intellij.ide.favoritesTreeView.InvalidUsageNoteProjectNode;
import com.intellij.ide.favoritesTreeView.NoteNode;
import com.intellij.ide.favoritesTreeView.NoteProjectNode;
import com.intellij.ide.favoritesTreeView.NoteSerializable;
import com.intellij.ide.favoritesTreeView.UsageProjectTreeNode;
import com.intellij.ide.favoritesTreeView.UsageSerializable;
import com.intellij.ide.favoritesTreeView.WorkingSetSerializable;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.usages.rules.UsageInFiles;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class UsageFavoriteNodeProvider
extends FavoriteNodeProvider {
    private static final Map<String, TreeSet<WorkingSetSerializable>> ourSerializables = new HashMap<String, TreeSet<WorkingSetSerializable>>();
    private static final Comparator<VirtualFile> VIRTUAL_FILE_COMPARATOR = Comparator.comparing(VirtualFile::getPath);
    private static final Logger LOG = Logger.getInstance(UsageFavoriteNodeProvider.class);

    private static TreeSet<WorkingSetSerializable> createSet() {
        return new TreeSet<WorkingSetSerializable>((o1, o2) -> {
            assert (o1.getId().equals(o2.getId()));
            return Comparing.compare((int)o1.getVersion(), (int)o2.getVersion());
        });
    }

    public Collection<AbstractTreeNode<?>> getFavoriteNodes(DataContext context, @NotNull ViewSettings viewSettings) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            return null;
        }
        Usage[] usages = (Usage[])UsageView.USAGES_KEY.getData(context);
        if (usages != null) {
            MultiMap map2 = new MultiMap();
            ArrayList<Usage> nonMapped = new ArrayList<Usage>();
            for (Usage usage : usages) {
                if (usage instanceof UsageInFile) {
                    map2.putValue((Object)((UsageInFile)usage).getFile(), (Object)usage);
                    continue;
                }
                if (usage instanceof UsageInFiles) {
                    VirtualFile[] files2;
                    for (VirtualFile file2 : files2 = ((UsageInFiles)usage).getFiles()) {
                        map2.putValue((Object)file2, (Object)usage);
                    }
                    continue;
                }
                nonMapped.add(usage);
            }
            TreeSet<VirtualFile> keys2 = new TreeSet<VirtualFile>(VIRTUAL_FILE_COMPARATOR);
            keys2.addAll(map2.keySet());
            SmartList result2 = new SmartList();
            for (VirtualFile key : keys2) {
                FileGroupingProjectNode grouping = new FileGroupingProjectNode(project, new File(key.getPath()), viewSettings);
                result2.add(grouping);
                Collection subUsages = map2.get((Object)key);
                for (Usage usage : subUsages) {
                    if (usage instanceof UsageInfo2UsageAdapter) {
                        UsageProjectTreeNode node = new UsageProjectTreeNode(project, ((UsageInfo2UsageAdapter)usage).getUsageInfo(), viewSettings);
                        grouping.addChild((AbstractTreeNode<?>)node);
                        continue;
                    }
                    if (NullUsage.INSTANCE.equals(usage)) continue;
                    grouping.addChild((AbstractTreeNode<?>)new NoteProjectNode(project, new NoteNode(usage.getPresentation().getPlainText(), true), viewSettings));
                }
            }
            for (Usage usage : nonMapped) {
                if (usage instanceof UsageInfo2UsageAdapter) {
                    UsageProjectTreeNode node = new UsageProjectTreeNode(project, ((UsageInfo2UsageAdapter)usage).getUsageInfo(), viewSettings);
                    result2.add(node);
                    continue;
                }
                if (NullUsage.INSTANCE.equals(usage)) continue;
                result2.add(new NoteProjectNode(project, new NoteNode(usage.getPresentation().getPlainText(), true), viewSettings));
            }
            return result2;
        }
        return null;
    }

    public AbstractTreeNode createNode(Project project, Object element2, @NotNull ViewSettings viewSettings) {
        if (element2 instanceof UsageInfo) {
            return new UsageProjectTreeNode(project, (UsageInfo)element2, viewSettings);
        }
        if (element2 instanceof InvalidUsageNoteNode) {
            return new InvalidUsageNoteProjectNode(project, (InvalidUsageNoteNode)element2, viewSettings);
        }
        if (element2 instanceof NoteNode) {
            return new NoteProjectNode(project, (NoteNode)element2, viewSettings);
        }
        if (element2 instanceof File) {
            return new FileGroupingProjectNode(project, (File)element2, viewSettings);
        }
        return super.createNode(project, element2, viewSettings);
    }

    public PsiElement getPsiElement(Object element2) {
        if (element2 instanceof UsageInfo) {
            return ((UsageInfo)element2).getElement();
        }
        return super.getPsiElement(element2);
    }

    public boolean elementContainsFile(Object element2, VirtualFile vFile) {
        return false;
    }

    public int getElementWeight(Object element2, boolean isSortByType) {
        return 0;
    }

    public String getElementLocation(Object element2) {
        if (element2 instanceof UsageInfo) {
            PsiElement psiElement = ((UsageInfo)element2).getElement();
            PsiFile file2 = psiElement == null ? null : psiElement.getContainingFile();
            return file2 == null ? null : file2.getPresentation().getPresentableText();
        }
        if (element2 instanceof File) {
            return ((File)element2).getParent();
        }
        return null;
    }

    public boolean isInvalidElement(Object element2) {
        return false;
    }

    @NotNull
    public String getFavoriteTypeId() {
        return "usage";
    }

    public String getElementUrl(Object element2) {
        TreeSet<WorkingSetSerializable> serializables = ourSerializables.get(element2.getClass().getName());
        if (serializables != null && !serializables.isEmpty()) {
            WorkingSetSerializable last = serializables.last();
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(last.getId());
                sb.append(' ');
                sb.append(last.getVersion());
                sb.append(' ');
                last.serializeMe(element2, sb);
                return sb.toString();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                return null;
            }
        }
        return null;
    }

    public String getElementModuleName(Object element2) {
        if (element2 instanceof UsageInfo) {
            PsiElement psiElement = ((UsageInfo)element2).getElement();
            Module module = psiElement == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            return module == null ? null : module.getName();
        }
        return null;
    }

    public Object[] createPathFromUrl(Project project, String url, String moduleName) {
        try {
            List parts = StringUtil.split((String)url, (String)" ", (boolean)true);
            if (parts.size() < 3) {
                return null;
            }
            String id2 = (String)parts.get(0);
            TreeSet<WorkingSetSerializable> set = ourSerializables.get(id2);
            if (set != null && !set.isEmpty()) {
                int version2 = Integer.parseInt((String)parts.get(1));
                String cut = StringUtil.join(parts.subList(2, parts.size()), (String)" ");
                Iterator<WorkingSetSerializable> iterator2 = set.descendingIterator();
                while (iterator2.hasNext()) {
                    WorkingSetSerializable serializable = iterator2.next();
                    if (serializable.getVersion() != version2) continue;
                    return UsageFavoriteNodeProvider.readWithSerializable(project, cut, serializable);
                }
                UsageFavoriteNodeProvider.readWithSerializable(project, cut, set.last());
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return null;
    }

    private static Object[] readWithSerializable(Project project, String is, WorkingSetSerializable serializable) throws IOException {
        Object[] objectArray;
        Object obj = serializable.deserializeMe(project, is);
        if (obj == null) {
            obj = serializable.deserializeMeInvalid(project, is);
        }
        if (obj == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = obj;
        }
        return objectArray;
    }

    static {
        TreeSet<WorkingSetSerializable> usageSet = UsageFavoriteNodeProvider.createSet();
        UsageSerializable serializable = new UsageSerializable();
        ourSerializables.put(serializable.getId(), usageSet);
        usageSet.add(serializable);
        TreeSet<WorkingSetSerializable> fileSet = UsageFavoriteNodeProvider.createSet();
        FileSerializable fileSerializable = new FileSerializable();
        ourSerializables.put(fileSerializable.getId(), fileSet);
        fileSet.add(fileSerializable);
        TreeSet<WorkingSetSerializable> noteSet = UsageFavoriteNodeProvider.createSet();
        NoteSerializable noteSerializable = new NoteSerializable();
        ourSerializables.put(noteSerializable.getId(), noteSet);
        noteSet.add(noteSerializable);
    }
}

