/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.favoritesTreeView.ProjectViewNodeWithChildrenList;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class FileGroupingProjectNode
extends ProjectViewNodeWithChildrenList<File> {
    private VirtualFile myVirtualFile;

    public FileGroupingProjectNode(Project project, @NotNull File file2, ViewSettings viewSettings) {
        super(project, file2, viewSettings);
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        this.myVirtualFile = lfs.findFileByIoFile(file2);
        if (this.myVirtualFile == null) {
            this.myVirtualFile = lfs.refreshAndFindFileByIoFile(file2);
        }
    }

    public boolean contains(@NotNull VirtualFile file2) {
        return file2.equals(this.myVirtualFile);
    }

    protected void update(@NotNull PresentationData presentation2) {
        if (this.myVirtualFile != null && this.myVirtualFile.isDirectory()) {
            presentation2.setIcon(AllIcons.Nodes.Folder);
        } else if (this.myVirtualFile != null) {
            presentation2.setIcon(this.myVirtualFile.getFileType().getIcon());
        } else {
            presentation2.setIcon(AllIcons.FileTypes.Unknown);
        }
        presentation2.setPresentableText(((File)this.getValue()).getName());
    }

    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    public void navigate(boolean requestFocus) {
        if (this.myVirtualFile != null) {
            PsiNavigationSupport.getInstance().createNavigatable(this.myProject, this.myVirtualFile, -1).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return this.myVirtualFile != null && this.myVirtualFile.isValid();
    }

    public boolean canNavigateToSource() {
        return this.myVirtualFile != null && this.myVirtualFile.isValid();
    }
}

