/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.IdeView;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.favoritesTreeView.FavoriteComparator;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoriteTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesAutoscrollFromSourceHandler;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListener;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesRootNode;
import com.intellij.ide.favoritesTreeView.FavoritesTreeStructure;
import com.intellij.ide.favoritesTreeView.FavoritesTreeUtil;
import com.intellij.ide.favoritesTreeView.FavoritesViewTreeBuilder;
import com.intellij.ide.favoritesTreeView.actions.AddToFavoritesAction;
import com.intellij.ide.favoritesTreeView.actions.DeleteFromFavoritesAction;
import com.intellij.ide.favoritesTreeView.actions.FavoritesAbbreviatePackageNamesAction;
import com.intellij.ide.favoritesTreeView.actions.FavoritesAutoScrollToSourceAction;
import com.intellij.ide.favoritesTreeView.actions.FavoritesCompactEmptyMiddlePackagesAction;
import com.intellij.ide.favoritesTreeView.actions.FavoritesFlattenPackagesAction;
import com.intellij.ide.favoritesTreeView.actions.FavoritesShowMembersAction;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FavoritesTreeViewPanel
extends JPanel
implements DataProvider,
DockContainer {
    private final FavoritesTreeStructure myFavoritesTreeStructure;
    private final FavoritesViewTreeBuilder myBuilder;
    private final CopyPasteDelegator myCopyPasteDelegator;
    public static final DataKey<FavoriteTreeNodeDescriptor[]> CONTEXT_FAVORITES_ROOTS_DATA_KEY = DataKey.create((String)"FavoritesRoot");
    public static final DataKey<DnDAwareTree> FAVORITES_TREE_KEY = DataKey.create((String)"Favorites.Tree");
    public static final DataKey<FavoritesViewTreeBuilder> FAVORITES_TREE_BUILDER_KEY = DataKey.create((String)"Favorites.Tree.Builder");
    public static final DataKey<String> FAVORITES_LIST_NAME_DATA_KEY = DataKey.create((String)"FavoritesListName");
    private final Project myProject;
    final DnDAwareTree myTree;
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final IdeView myIdeView = new MyIdeView();

    public FavoritesTreeViewPanel(@NotNull Project project) {
        super(new BorderLayout());
        this.myProject = project;
        this.myFavoritesTreeStructure = new FavoritesTreeStructure(project);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        root.setUserObject(this.myFavoritesTreeStructure.getRootElement());
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.myTree = new DnDAwareTree(treeModel){

            public boolean isFileColorsEnabled() {
                return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
            }

            public Color getFileColorFor(Object object) {
                return ProjectViewTree.getColorForElement(FavoritesTreeViewPanel.this.getPsiElement(object));
            }
        };
        this.myBuilder = new FavoritesViewTreeBuilder(this.myProject, (JTree)((Object)this.myTree), treeModel, this.myFavoritesTreeStructure);
        DockManager.getInstance((Project)project).register((DockContainer)this, (Disposable)project);
        TreeUtil.installActions((JTree)((Object)this.myTree));
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setLargeModel(true);
        new TreeSpeedSearch((JTree)((Object)this.myTree));
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.myTree));
        FavoriteComparator favoritesComparator = new FavoriteComparator();
        final FavoritesManager favoriteManager = FavoritesManager.getInstance(this.myProject);
        this.myBuilder.setNodeDescriptorComparator((o1, o2) -> {
            FavoritesListNode listNode2;
            FavoritesListNode listNode1;
            if (o1 instanceof FavoriteTreeNodeDescriptor && o2 instanceof FavoriteTreeNodeDescriptor && (listNode1 = FavoritesTreeUtil.extractParentList((FavoriteTreeNodeDescriptor)((Object)o1))).equals((Object)(listNode2 = FavoritesTreeUtil.extractParentList((FavoriteTreeNodeDescriptor)((Object)o2))))) {
                Comparator<FavoriteTreeNodeDescriptor> comparator2 = favoriteManager.getCustomComparator(listNode1.getName());
                if (comparator2 != null) {
                    return comparator2.compare((FavoriteTreeNodeDescriptor)((Object)o1), (FavoriteTreeNodeDescriptor)((Object)o2));
                }
                return favoritesComparator.compare((NodeDescriptor)o1, (NodeDescriptor)o2);
            }
            return o1.getIndex() - o2.getIndex();
        });
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.customizeCellRenderer(tree, value2, selected2, expanded, leaf, row, hasFocus);
                if (!(value2 instanceof DefaultMutableTreeNode)) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value2;
                Object userObject = node.getUserObject();
                if (userObject instanceof FavoriteTreeNodeDescriptor) {
                    String location;
                    FavoriteTreeNodeDescriptor favoritesTreeNodeDescriptor = (FavoriteTreeNodeDescriptor)((Object)userObject);
                    AbstractTreeNode treeNode = favoritesTreeNodeDescriptor.getElement();
                    FavoritesListProvider provider = FavoritesTreeUtil.getProvider(favoriteManager, favoritesTreeNodeDescriptor);
                    if (provider != null) {
                        Object o = FavoritesTreeViewPanel.this.myBuilder.getUi().getElementFor(value2);
                        if (o instanceof AbstractTreeNode) {
                            o = ((AbstractTreeNode)o).getValue();
                        }
                        provider.customizeRenderer((ColoredTreeCellRenderer)this, tree, o, selected2, expanded, leaf, row, hasFocus);
                        return;
                    }
                    PresentationData presentation2 = treeNode.getPresentation();
                    String locationString = presentation2.getLocationString();
                    if (locationString == null && node.getParent() != null && node.getParent().getParent() != null && node.getParent().getParent().getParent() == null && (location = favoritesTreeNodeDescriptor.getLocation()) != null && location.length() > 0) {
                        this.append(" (" + location + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                }
            }
        });
        CustomizationUtil.installPopupHandler((JComponent)((Object)this.myTree), "FavoritesViewPopupMenu", "FavoritesPopup");
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this.myTree));
        EditSourceOnEnterKeyHandler.install((JTree)((Object)this.myTree));
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, this);
        AnActionButton addActionButton = AnActionButton.fromAction((AnAction)ActionManager.getInstance().getAction("AddNewFavoritesList"));
        addActionButton.getTemplatePresentation().setIcon(CommonActionsPanel.Buttons.ADD.getIcon());
        addActionButton.setShortcut(CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD));
        AnActionButton editActionButton = AnActionButton.fromAction((AnAction)ActionManager.getInstance().getAction("EditFavorites"));
        editActionButton.setShortcut(CommonShortcuts.CTRL_ENTER);
        DeleteFromFavoritesAction deleteActionButton = new DeleteFromFavoritesAction();
        deleteActionButton.setShortcut((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DELETE", "BACK_SPACE"}));
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)((Object)this.myTree)).initPosition().disableAddAction().disableRemoveAction().disableDownAction().disableUpAction().addExtraAction(addActionButton).addExtraAction(editActionButton).addExtraAction((AnActionButton)deleteActionButton);
        AnAction action2 = ActionManager.getInstance().getAction("NewElement");
        action2.registerCustomShortcutSet(action2.getShortcutSet(), (JComponent)((Object)this.myTree));
        JPanel panel2 = decorator.createPanel();
        panel2.setBorder((Border)JBUI.Borders.empty());
        this.add((Component)panel2, "Center");
        this.setBorder((Border)JBUI.Borders.empty());
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return favoriteManager.getViewSettings().isAutoScrollToSource();
            }

            protected void setAutoScrollMode(boolean state) {
                favoriteManager.getViewSettings().setAutoScrollToSource(state);
            }
        };
        this.myAutoScrollToSourceHandler.install((JTree)((Object)this.myTree));
        favoriteManager.addFavoritesListener(new FavoritesListener(){

            @Override
            public void rootsChanged() {
                FavoritesTreeViewPanel.this.doUpdate();
            }

            @Override
            public void listAdded(@NotNull String listName) {
                FavoritesTreeViewPanel.this.doUpdate();
            }

            @Override
            public void listRemoved(@NotNull String listName) {
                FavoritesTreeViewPanel.this.doUpdate();
            }
        }, (Disposable)project);
        FavoriteNodeProvider.EP_NAME.getPoint((AreaInstance)this.myProject).addChangeListener(this::doUpdate, (Disposable)this.myProject);
    }

    private void doUpdate() {
        this.myBuilder.updateFromRoot();
        this.myTree.repaint();
    }

    public void selectElement(Object selector, VirtualFile file2, boolean requestFocus) {
        this.myBuilder.selectAsync(selector, file2, requestFocus);
    }

    public DnDAwareTree getTree() {
        return this.myTree;
    }

    private PsiElement @NotNull [] getSelectedPsiElements() {
        List elements2 = JBIterable.of((Object[])this.getSelectedNodeElements()).filterMap(this::getPsiElement).toList();
        return PsiUtilCore.toPsiElementArray((Collection)elements2);
    }

    @Nullable
    private PsiElement getPsiElement(@Nullable Object element2) {
        if (element2 instanceof FavoriteTreeNodeDescriptor) {
            element2 = ((FavoriteTreeNodeDescriptor)((Object)element2)).getElement().getValue();
        }
        if (element2 instanceof Bookmark) {
            element2 = ((Bookmark)element2).getFile();
        }
        if (element2 instanceof PsiElement) {
            return (PsiElement)element2;
        }
        if (element2 instanceof SmartPsiElementPointer) {
            return ((SmartPsiElementPointer)element2).getElement();
        }
        if (element2 != null) {
            for (FavoriteNodeProvider provider : (FavoriteNodeProvider[])FavoriteNodeProvider.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
                PsiElement psiElement = provider.getPsiElement(element2);
                if (psiElement == null) continue;
                return psiElement;
            }
        }
        return null;
    }

    public Object getData(@NotNull String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            FavoriteTreeNodeDescriptor[] selectedNodeDescriptors = FavoritesTreeUtil.getSelectedNodeDescriptors(this.myTree);
            return selectedNodeDescriptors.length == 1 ? selectedNodeDescriptors[0].getElement() : null;
        }
        FavoritesManager favoriteManager = FavoritesManager.getInstance(this.myProject);
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            List<String> listNames = this.getSelectedElements(String.class);
            SmartList selectedElements = new SmartList();
            for (String listname : listNames) {
                selectedElements.addAll(ContainerUtil.map(favoriteManager.getVirtualFiles(listname, false), file2 -> new OpenFileDescriptor(this.myProject, file2)));
            }
            selectedElements.addAll(this.getSelectedElements(Navigatable.class));
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new Navigatable[0]);
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getPasteProvider();
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.toolWindows.favorites";
        }
        if (LangDataKeys.NO_NEW_ACTION.is(dataId)) {
            return Boolean.TRUE;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiElement[] elements2 = this.getSelectedPsiElements();
            if (elements2.length != 1) {
                return null;
            }
            return elements2[0] != null && elements2[0].isValid() ? elements2[0] : null;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            PsiElement[] elements3 = this.getSelectedPsiElements();
            ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
            for (PsiElement element2 : elements3) {
                if (!element2.isValid()) continue;
                result2.add(element2);
            }
            return result2.isEmpty() ? null : PsiUtilCore.toPsiElementArray(result2);
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            return this.myIdeView;
        }
        if (LangDataKeys.TARGET_PSI_ELEMENT.is(dataId)) {
            return null;
        }
        if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
            Module[] selected2 = this.getSelectedModules();
            return selected2 != null && selected2.length == 1 ? selected2[0] : null;
        }
        if (LangDataKeys.MODULE_CONTEXT_ARRAY.is(dataId)) {
            return this.getSelectedModules();
        }
        if (ModuleGroup.ARRAY_DATA_KEY.is(dataId)) {
            List<ModuleGroup> selectedElements = this.getSelectedElements(ModuleGroup.class);
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new ModuleGroup[0]);
        }
        if (LibraryGroupElement.ARRAY_DATA_KEY.is(dataId)) {
            List<LibraryGroupElement> selectedElements = this.getSelectedElements(LibraryGroupElement.class);
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new LibraryGroupElement[0]);
        }
        if (NamedLibraryElement.ARRAY_DATA_KEY.is(dataId)) {
            List<NamedLibraryElement> selectedElements = this.getSelectedElements(NamedLibraryElement.class);
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new NamedLibraryElement[0]);
        }
        if (CONTEXT_FAVORITES_ROOTS_DATA_KEY.is(dataId)) {
            FavoriteTreeNodeDescriptor[] selectedNodeDescriptors;
            ArrayList<FavoriteTreeNodeDescriptor> result3 = new ArrayList<FavoriteTreeNodeDescriptor>();
            for (FavoriteTreeNodeDescriptor selectedNodeDescriptor : selectedNodeDescriptors = FavoritesTreeUtil.getSelectedNodeDescriptors(this.myTree)) {
                FavoriteTreeNodeDescriptor root;
                if (FavoritesTreeUtil.getProvider(favoriteManager, selectedNodeDescriptor) != null || (root = selectedNodeDescriptor.getFavoritesRoot()) == null || !(root.getElement() instanceof FavoritesListNode)) continue;
                result3.add(selectedNodeDescriptor);
            }
            return result3.toArray(FavoriteTreeNodeDescriptor.EMPTY_ARRAY);
        }
        if (FAVORITES_TREE_KEY.is(dataId)) {
            return this.myTree;
        }
        if (FAVORITES_TREE_BUILDER_KEY.is(dataId)) {
            return this.myBuilder;
        }
        if (FAVORITES_LIST_NAME_DATA_KEY.is(dataId)) {
            FavoriteTreeNodeDescriptor[] descriptors = FavoritesTreeUtil.getSelectedNodeDescriptors(this.myTree);
            HashSet<Object> selectedNames = new HashSet<Object>();
            for (FavoriteTreeNodeDescriptor descriptor2 : descriptors) {
                FavoritesListNode node = FavoritesTreeUtil.extractParentList(descriptor2);
                if (node == null) continue;
                selectedNames.add(node.getValue());
            }
            if (selectedNames.size() == 1) {
                return selectedNames.iterator().next();
            }
            return null;
        }
        FavoriteTreeNodeDescriptor[] descriptors = FavoritesTreeUtil.getSelectedNodeDescriptors(this.myTree);
        if (descriptors.length > 0) {
            ArrayList nodes = new ArrayList();
            for (FavoriteTreeNodeDescriptor descriptor3 : descriptors) {
                nodes.add(descriptor3.getElement());
            }
            return this.myFavoritesTreeStructure.getDataFromProviders(nodes, dataId);
        }
        return null;
    }

    private <T> List<T> getSelectedElements(Class<T> klass) {
        Object[] elements2 = this.getSelectedNodeElements();
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (Object element2 : elements2) {
            if (element2 == null || !klass.isAssignableFrom(element2.getClass())) continue;
            result2.add(element2);
        }
        return result2;
    }

    private Module[] getSelectedModules() {
        Object[] elements2 = this.getSelectedNodeElements();
        ArrayList<Module> result2 = new ArrayList<Module>();
        for (Object element2 : elements2) {
            if (element2 instanceof Module) {
                result2.add((Module)element2);
                continue;
            }
            if (!(element2 instanceof ModuleGroup)) continue;
            result2.addAll(((ModuleGroup)element2).modulesInGroup(this.myProject, true));
        }
        return result2.isEmpty() ? null : result2.toArray(Module.EMPTY_ARRAY);
    }

    private Object @NotNull [] getSelectedNodeElements() {
        FavoriteTreeNodeDescriptor[] selectedNodeDescriptors = FavoritesTreeUtil.getSelectedNodeDescriptors(this.myTree);
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (FavoriteTreeNodeDescriptor selectedNodeDescriptor : selectedNodeDescriptors) {
            if (selectedNodeDescriptor == null) continue;
            Object value2 = selectedNodeDescriptor.getElement().getValue();
            if (value2 instanceof SmartPsiElementPointer) {
                value2 = ((SmartPsiElementPointer)value2).getElement();
            }
            result2.add(value2);
        }
        return ArrayUtil.toObjectArray(result2);
    }

    public void setupToolWindow(@NotNull ToolWindowEx window) {
        CollapseAllAction collapseAction = new CollapseAllAction((JTree)((Object)this.myTree));
        collapseAction.getTemplatePresentation().setIcon(AllIcons.Actions.Collapseall);
        window.setTitleActions(new AnAction[]{collapseAction});
        DefaultActionGroup group = new DefaultActionGroup();
        ProjectViewDirectoryHelper helper = ProjectViewDirectoryHelper.getInstance(this.myProject);
        if (helper.supportsFlattenPackages()) {
            group.add((AnAction)new FavoritesFlattenPackagesAction(this.myProject, this.myBuilder));
        }
        if (helper.supportsHideEmptyMiddlePackages()) {
            group.add((AnAction)new FavoritesCompactEmptyMiddlePackagesAction(this.myProject, this.myBuilder));
        }
        if (helper.supportsFlattenPackages()) {
            group.addAction((AnAction)new FavoritesAbbreviatePackageNamesAction(this.myProject, this.myBuilder));
        }
        if (!PlatformUtils.isCidr() && !PlatformUtils.isRider()) {
            group.add((AnAction)new FavoritesShowMembersAction(this.myProject, this.myBuilder));
        }
        FavoritesAutoscrollFromSourceHandler handler2 = new FavoritesAutoscrollFromSourceHandler(this.myProject, this.myBuilder);
        handler2.install();
        group.add((AnAction)handler2.createToggleAction());
        group.add((AnAction)new FavoritesAutoScrollToSourceAction(this.myProject, this.myAutoScrollToSourceHandler, this.myBuilder));
        window.setAdditionalGearActions((ActionGroup)group);
    }

    public static String getQualifiedName(VirtualFile file2) {
        return file2.getPresentableUrl();
    }

    public FavoritesViewTreeBuilder getBuilder() {
        return this.myBuilder;
    }

    @Nullable
    FavoritesListNode findFavoritesListNode(Point point) {
        TreePath path = this.myTree.getClosestPathForLocation(point.x, point.y);
        FavoritesListNode node = FavoritesTreeViewPanel.getListNodeFromPath(path);
        return node == null ? (FavoritesListNode)((FavoritesRootNode)((Object)this.myFavoritesTreeStructure.getRootElement())).getChildren().iterator().next() : node;
    }

    static FavoritesListNode getListNodeFromPath(TreePath path) {
        AbstractTreeNode node;
        Object obj;
        Object o;
        if (path != null && path.getPathCount() > 1 && (o = path.getPath()[1]) instanceof DefaultMutableTreeNode && (obj = ((DefaultMutableTreeNode)o).getUserObject()) instanceof FavoriteTreeNodeDescriptor && (node = ((FavoriteTreeNodeDescriptor)((Object)obj)).getElement()) instanceof FavoritesListNode) {
            return (FavoritesListNode)node;
        }
        return null;
    }

    void dropPsiElements(FavoritesManager mgr, FavoritesListNode node, PsiElement[] elements2) {
        if (elements2 != null && elements2.length > 0) {
            ArrayList nodes = new ArrayList();
            for (PsiElement element2 : elements2) {
                if (element2 instanceof SmartPsiElementPointer) {
                    element2 = ((SmartPsiElementPointer)element2).getElement();
                }
                Collection<AbstractTreeNode<?>> tmp = AddToFavoritesAction.createNodes(this.myProject, null, element2, true, FavoritesManager.getInstance(this.myProject).getViewSettings());
                nodes.addAll(tmp);
                mgr.addRoots((String)node.getValue(), nodes);
            }
            this.myBuilder.select(nodes.toArray(), null);
        }
    }

    @NotNull
    public RelativeRectangle getAcceptArea() {
        return new RelativeRectangle((JComponent)((Object)this.myTree));
    }

    @NotNull
    public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent content2, RelativePoint point) {
        if (content2.getKey() instanceof VirtualFile) {
            return DockContainer.ContentResponse.ACCEPT_COPY;
        }
        return DockContainer.ContentResponse.DENY;
    }

    public JComponent getContainerComponent() {
        return this;
    }

    public void add(@NotNull DockableContent content2, RelativePoint dropTarget) {
        if (!(content2.getKey() instanceof VirtualFile)) {
            return;
        }
        VirtualFile vFile = (VirtualFile)content2.getKey();
        PsiFileSystemItem psiFile = PsiUtilCore.findFileSystemItem((Project)this.myProject, (VirtualFile)vFile);
        Point p = dropTarget.getScreenPoint();
        SwingUtilities.convertPointFromScreen(p, (Component)((Object)this.myTree));
        FavoritesListNode node = this.findFavoritesListNode(p);
        if (node != null && psiFile != null) {
            this.dropPsiElements(FavoritesManager.getInstance(this.myProject), node, new PsiElement[]{psiFile});
        }
    }

    public boolean isEmpty() {
        return this.myTree.isEmpty();
    }

    @Nullable
    public Image processDropOver(@NotNull DockableContent content2, RelativePoint point) {
        Point p = point.getScreenPoint();
        SwingUtilities.convertPointFromScreen(p, (Component)((Object)this.myTree));
        TreePath treePath = this.myTree.getClosestPathForLocation(p.x, p.y);
        FavoritesListNode node = FavoritesTreeViewPanel.getListNodeFromPath(treePath);
        TreePath treePath2 = treePath = node != null ? this.myTree.getPath((PresentableNodeDescriptor)node) : null;
        if (treePath != null) {
            this.myTree.setSelectionPath(treePath);
        }
        return null;
    }

    public boolean isDisposeWhenEmpty() {
        return false;
    }

    private final class MyIdeView
    implements IdeView {
        private MyIdeView() {
        }

        public void selectElement(PsiElement element2) {
            if (element2 != null) {
                Editor editor;
                this.selectPsiElement(element2, false);
                boolean requestFocus = true;
                boolean isDirectory = element2 instanceof PsiDirectory;
                if (!isDirectory && (editor = EditorHelper.openInEditor(element2)) != null) {
                    ToolWindowManager.getInstance((Project)FavoritesTreeViewPanel.this.myProject).activateEditorComponent();
                    requestFocus = false;
                }
                if (requestFocus) {
                    this.selectPsiElement(element2, true);
                }
            }
        }

        private void selectPsiElement(PsiElement element2, boolean requestFocus) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element2);
            FavoritesTreeViewPanel.this.selectElement(element2, virtualFile, requestFocus);
        }

        private PsiDirectory @Nullable [] getSelectedDirectories() {
            PsiDirectory[] psiDirectoryArray;
            if (FavoritesTreeViewPanel.this.myBuilder == null) {
                return null;
            }
            Object[] selectedNodeElements = FavoritesTreeViewPanel.this.getSelectedNodeElements();
            if (selectedNodeElements.length != 1) {
                return null;
            }
            for (FavoriteNodeProvider nodeProvider : (FavoriteNodeProvider[])FavoriteNodeProvider.EP_NAME.getExtensions((AreaInstance)FavoritesTreeViewPanel.this.myProject)) {
                PsiDirectory parent;
                PsiFile file2;
                PsiElement psiElement = nodeProvider.getPsiElement(selectedNodeElements[0]);
                if (psiElement instanceof PsiDirectory) {
                    return new PsiDirectory[]{(PsiDirectory)psiElement};
                }
                if (psiElement instanceof PsiDirectoryContainer) {
                    Module module;
                    String moduleName = nodeProvider.getElementModuleName(selectedNodeElements[0]);
                    GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)FavoritesTreeViewPanel.this.myProject);
                    if (moduleName != null && (module = ModuleManager.getInstance((Project)FavoritesTreeViewPanel.this.myProject).findModuleByName(moduleName)) != null) {
                        searchScope = GlobalSearchScope.moduleScope((Module)module);
                    }
                    return ((PsiDirectoryContainer)psiElement).getDirectories(searchScope);
                }
                if (psiElement == null || (file2 = psiElement.getContainingFile()) == null || (parent = file2.getParent()) == null) continue;
                return new PsiDirectory[]{parent};
            }
            if (selectedNodeElements[0] instanceof PsiDirectory) {
                PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                psiDirectoryArray = psiDirectoryArray2;
                psiDirectoryArray2[0] = (PsiDirectory)selectedNodeElements[0];
            } else {
                psiDirectoryArray = null;
            }
            return psiDirectoryArray;
        }

        public PsiDirectory @NotNull [] getDirectories() {
            PsiDirectory[] directories = this.getSelectedDirectories();
            return directories == null ? PsiDirectory.EMPTY_ARRAY : directories;
        }

        public PsiDirectory getOrChooseDirectory() {
            return DirectoryChooserUtil.getOrChooseDirectory(this);
        }
    }
}

