/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.actions.ExportToTextFileToolbarAction;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.ide.errorTreeView.NavigatableErrorTreeElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeRenderer;
import com.intellij.ide.errorTreeView.SimpleErrorData;
import com.intellij.ide.errorTreeView.impl.ErrorTreeViewConfiguration;
import com.intellij.ide.errorTreeView.impl.ErrorViewTextExporter;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.MessageView;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MutableErrorTreeView;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promises;

public class NewErrorTreeViewPanel
extends JPanel
implements DataProvider,
OccurenceNavigator,
MutableErrorTreeView,
CopyProvider,
Disposable {
    protected static final Logger LOG = Logger.getInstance(NewErrorTreeViewPanel.class);
    private volatile String myProgressText = "";
    private volatile float myFraction;
    private final ErrorViewStructure myErrorViewStructure;
    private final StructureTreeModel<ErrorViewStructure> myStructureModel;
    private final Alarm myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private volatile boolean myIsDisposed;
    private final ErrorTreeViewConfiguration myConfiguration;
    private ActionToolbar myLeftToolbar;
    private final TreeExpander myTreeExpander = new MyTreeExpander();
    private final ExporterToTextFile myExporterToTextFile;
    protected Project myProject;
    private final String myHelpId;
    protected Tree myTree;
    private final JPanel myMessagePanel;
    private ProcessController myProcessController;
    private JLabel myProgressLabel;
    private JPanel myProgressPanel;
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final MyOccurrenceNavigatorSupport myOccurrenceNavigatorSupport;

    public NewErrorTreeViewPanel(Project project, String helpId) {
        this(project, helpId, true);
    }

    public NewErrorTreeViewPanel(Project project, String helpId, boolean createExitAction) {
        this(project, helpId, createExitAction, true);
    }

    public NewErrorTreeViewPanel(Project project, String helpId, boolean createExitAction, boolean createToolbar) {
        this(project, helpId, createExitAction, createToolbar, null);
    }

    public NewErrorTreeViewPanel(Project project, String helpId, boolean createExitAction, boolean createToolbar, @Nullable Runnable rerunAction) {
        this.myProject = project;
        this.myHelpId = helpId;
        this.myConfiguration = ErrorTreeViewConfiguration.getInstance(project);
        this.setLayout(new BorderLayout());
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return NewErrorTreeViewPanel.this.myConfiguration.isAutoscrollToSource();
            }

            protected void setAutoScrollMode(boolean state) {
                NewErrorTreeViewPanel.this.myConfiguration.setAutoscrollToSource(state);
            }
        };
        this.myMessagePanel = new JPanel(new BorderLayout());
        this.myErrorViewStructure = this.createErrorViewStructure(project, this.canHideWarnings());
        this.myStructureModel = new StructureTreeModel<ErrorViewStructure>(this.myErrorViewStructure, this);
        this.myTree = new Tree((TreeModel)((Object)new AsyncTreeModel((TreeModel)((Object)this.myStructureModel), this)));
        this.myTree.setRowHeight(0);
        this.myTree.getEmptyText().setText(IdeBundle.message((String)"errortree.noMessages", (Object[])new Object[0]));
        this.myExporterToTextFile = new ErrorViewTextExporter(this.myErrorViewStructure);
        this.myOccurrenceNavigatorSupport = new MyOccurrenceNavigatorSupport(this.myTree);
        this.myAutoScrollToSourceHandler.install((JTree)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setLargeModel(true);
        JScrollPane scrollPane = NewErrorTreeRenderer.install((JTree)this.myTree);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)1));
        this.myMessagePanel.add((Component)scrollPane, "Center");
        if (createToolbar) {
            this.add((Component)this.createToolbarPanel(rerunAction), "West");
        }
        this.add((Component)this.myMessagePanel, "Center");
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                NewErrorTreeViewPanel.this.popupInvoked(comp, x, y);
            }
        });
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
        EditSourceOnEnterKeyHandler.install((JTree)this.myTree);
    }

    protected ErrorViewStructure createErrorViewStructure(Project project, boolean canHideWarnings) {
        return new ErrorViewStructure(project, canHideWarnings);
    }

    public void dispose() {
        this.myIsDisposed = true;
        this.myErrorViewStructure.clear();
        this.myUpdateAlarm.cancelAllRequests();
        Disposer.dispose((Disposable)this.myUpdateAlarm);
    }

    public void performCopy(@NotNull DataContext dataContext) {
        List<ErrorTreeNodeDescriptor> descriptors = this.getSelectedNodeDescriptors();
        if (!descriptors.isEmpty()) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(StringUtil.join(descriptors, descriptor2 -> {
                ErrorTreeElement element2 = descriptor2.getElement();
                return NewErrorTreeRenderer.calcPrefix(element2) + StringUtil.join((String[])element2.getText(), (String)"\n");
            }, (String)"\n")));
        }
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        return !this.getSelectedNodeDescriptors().isEmpty();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        return true;
    }

    @NotNull
    public StatusText getEmptyText() {
        return this.myTree.getEmptyText();
    }

    public Object getData(@NotNull String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            NavigatableErrorTreeElement selectedMessageElement = this.getSelectedNavigatableElement();
            return selectedMessageElement != null ? selectedMessageElement.getNavigatable() : null;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myHelpId;
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
            return this.myTreeExpander;
        }
        if (PlatformDataKeys.EXPORTER_TO_TEXT_FILE.is(dataId)) {
            return this.myExporterToTextFile;
        }
        if (CURRENT_EXCEPTION_DATA_KEY.is(dataId)) {
            ErrorTreeElement selectedMessageElement = this.getSelectedErrorTreeElement();
            return selectedMessageElement != null ? selectedMessageElement.getData() : null;
        }
        return null;
    }

    public void selectFirstMessage() {
        ErrorTreeElement firstError = this.myErrorViewStructure.getFirstMessage(ErrorTreeElementKind.ERROR);
        if (firstError != null) {
            this.selectElement(firstError, () -> {
                if (this.shouldShowFirstErrorInEditor()) {
                    TransactionGuard.submitTransaction((Disposable)this, () -> this.navigateToSource(false));
                }
            });
        } else {
            ErrorTreeElement firstWarning = this.myErrorViewStructure.getFirstMessage(ErrorTreeElementKind.WARNING);
            if (firstWarning == null) {
                firstWarning = this.myErrorViewStructure.getFirstMessage(ErrorTreeElementKind.NOTE);
            }
            if (firstWarning != null) {
                this.selectElement(firstWarning, null);
            } else {
                TreeUtil.promiseSelectFirst((JTree)this.myTree);
            }
        }
    }

    private void selectElement(ErrorTreeElement element2, @Nullable Runnable onDone) {
        this.myStructureModel.select(element2, (JTree)this.myTree, onDone == null ? path -> {} : path -> onDone.run());
    }

    protected boolean shouldShowFirstErrorInEditor() {
        return false;
    }

    public void updateTree() {
        if (!this.myIsDisposed) {
            this.myStructureModel.invalidate();
        }
    }

    public void addMessage(int type, String @NotNull [] text, @Nullable VirtualFile file2, int line, int column, @Nullable Object data2) {
        this.addMessage(type, text, null, file2, line, column, data2);
    }

    public void addMessage(int type, String @NotNull [] text, @Nullable VirtualFile underFileGroup, @Nullable VirtualFile file2, int line, int column, @Nullable Object data2) {
        if (this.myIsDisposed) {
            return;
        }
        this.updateAddedElement(this.myErrorViewStructure.addMessage(ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)type), text, underFileGroup, file2, line, column, data2));
    }

    protected void updateAddedElement(@NotNull ErrorTreeElement element2) {
        Object promise;
        Object parent = this.myErrorViewStructure.getParentElement(element2);
        if (parent == null) {
            promise = this.myStructureModel.invalidate();
        } else {
            Object parent2;
            promise = parent instanceof GroupingElement ? ((parent2 = this.myErrorViewStructure.getParentElement(parent)) != null ? this.myStructureModel.invalidate(parent2, true) : Promises.resolvedPromise()) : Promises.resolvedPromise();
            promise = promise.onProcessed(p -> this.myStructureModel.invalidate(parent, true));
        }
        if (element2.getKind() == ErrorTreeElementKind.ERROR) {
            promise.onSuccess(p -> this.makeVisible(element2));
        }
    }

    protected void makeVisible(@NotNull ErrorTreeElement element2) {
        this.myStructureModel.makeVisible(element2, (JTree)this.myTree, pp -> {});
    }

    public void addMessage(int type, String @NotNull [] text, @Nullable String groupName, @NotNull Navigatable navigatable, @Nullable String exportTextPrefix, @Nullable String rendererTextPrefix, @Nullable Object data2) {
        VirtualFile file2;
        if (this.myIsDisposed) {
            return;
        }
        VirtualFile virtualFile = file2 = data2 instanceof VirtualFile ? (VirtualFile)data2 : null;
        if (file2 == null && navigatable instanceof OpenFileDescriptor) {
            file2 = ((OpenFileDescriptor)navigatable).getFile();
        }
        String exportPrefix = exportTextPrefix == null ? "" : exportTextPrefix;
        String renderPrefix = rendererTextPrefix == null ? "" : rendererTextPrefix;
        ErrorTreeElementKind kind = ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)type);
        this.updateAddedElement(this.myErrorViewStructure.addNavigatableMessage(groupName, navigatable, kind, text, data2, exportPrefix, renderPrefix, file2));
    }

    public boolean removeMessage(int type, @NotNull String groupName, @NotNull Navigatable navigatable) {
        ErrorTreeElementKind kind = ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)type);
        List<NavigatableMessageElement> removed = this.myErrorViewStructure.removeNavigatableMessage(groupName, kind, navigatable);
        if (removed.isEmpty()) {
            return false;
        }
        removed.forEach(this::updateAddedElement);
        return true;
    }

    public void removeAllInGroup(@NotNull String name) {
        List<NavigatableMessageElement> removed = this.myErrorViewStructure.removeAllNavigatableMessagesInGroup(name);
        removed.forEach(this::updateAddedElement);
    }

    public NavigatableMessageElement @Nullable [] getNavigatableMessages(@NotNull String groupName) {
        ErrorTreeElement[] childElements = this.myErrorViewStructure.getChildElements(new GroupingElement(groupName, null, null));
        return (NavigatableMessageElement[])ObjectUtils.tryCast((Object)childElements, NavigatableMessageElement[].class);
    }

    public ErrorViewStructure getErrorViewStructure() {
        return this.myErrorViewStructure;
    }

    public static String createExportPrefix(int line) {
        return line < 0 ? "" : IdeBundle.message((String)"errortree.prefix.line", (Object[])new Object[]{line});
    }

    public static String createRendererPrefix(int line, int column) {
        if (line < 0) {
            return "";
        }
        if (column < 0) {
            return "(" + line + ")";
        }
        return "(" + line + ", " + column + ")";
    }

    @NotNull
    public JComponent getComponent() {
        return this;
    }

    @Nullable
    private NavigatableErrorTreeElement getSelectedNavigatableElement() {
        ErrorTreeElement selectedElement = this.getSelectedErrorTreeElement();
        return selectedElement instanceof NavigatableErrorTreeElement ? (NavigatableErrorTreeElement)((Object)selectedElement) : null;
    }

    @Nullable
    public ErrorTreeElement getSelectedErrorTreeElement() {
        ErrorTreeNodeDescriptor treeNodeDescriptor = this.getSelectedNodeDescriptor();
        return treeNodeDescriptor == null ? null : treeNodeDescriptor.getElement();
    }

    @Nullable
    public ErrorTreeNodeDescriptor getSelectedNodeDescriptor() {
        List<ErrorTreeNodeDescriptor> descriptors = this.getSelectedNodeDescriptors();
        return descriptors.size() == 1 ? descriptors.get(0) : null;
    }

    @Nullable
    public VirtualFile getSelectedFile() {
        NodeDescriptor parent;
        ErrorTreeElement element2;
        ErrorTreeNodeDescriptor descriptor2 = this.getSelectedNodeDescriptor();
        ErrorTreeElement errorTreeElement = element2 = descriptor2 != null ? descriptor2.getElement() : null;
        if (element2 != null && !(element2 instanceof GroupingElement) && (parent = descriptor2.getParentDescriptor()) instanceof ErrorTreeNodeDescriptor) {
            element2 = ((ErrorTreeNodeDescriptor)parent).getElement();
        }
        return element2 instanceof GroupingElement ? ((GroupingElement)element2).getFile() : null;
    }

    private List<ErrorTreeNodeDescriptor> getSelectedNodeDescriptors() {
        TreePath[] paths;
        TreePath[] treePathArray = paths = this.myIsDisposed ? null : this.myTree.getSelectionPaths();
        if (paths == null) {
            return Collections.emptyList();
        }
        ArrayList<ErrorTreeNodeDescriptor> result2 = new ArrayList<ErrorTreeNodeDescriptor>();
        for (TreePath path : paths) {
            DefaultMutableTreeNode lastPathNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = lastPathNode.getUserObject();
            if (!(userObject instanceof ErrorTreeNodeDescriptor)) continue;
            result2.add((ErrorTreeNodeDescriptor)((Object)userObject));
        }
        return result2;
    }

    private void navigateToSource(boolean focusEditor) {
        NavigatableErrorTreeElement element2 = this.getSelectedNavigatableElement();
        if (element2 == null) {
            return;
        }
        Navigatable navigatable = element2.getNavigatable();
        if (navigatable.canNavigate()) {
            navigatable.navigate(focusEditor);
        }
    }

    public static String getQualifiedName(VirtualFile file2) {
        return file2.getPresentableUrl();
    }

    private void popupInvoked(Component component2, int x, int y) {
        TreePath path = this.myTree.getLeadSelectionPath();
        if (path == null) {
            return;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        if (this.getData(CommonDataKeys.NAVIGATABLE.getName()) != null) {
            group.add(ActionManager.getInstance().getAction("EditSource"));
        }
        group.add(ActionManager.getInstance().getAction("$Copy"));
        group.add((AnAction)this.myAutoScrollToSourceHandler.createToggleAction());
        this.addExtraPopupMenuActions(group);
        group.addSeparator();
        group.add(CommonActionsManager.getInstance().createExpandAllAction(this.myTreeExpander, (JComponent)this));
        group.add(CommonActionsManager.getInstance().createCollapseAllAction(this.myTreeExpander, (JComponent)this));
        group.addSeparator();
        group.add((AnAction)new ExportToTextFileToolbarAction(this.myExporterToTextFile));
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("CompilerMessagesPopup", (ActionGroup)group);
        menu.getComponent().show(component2, x, y);
    }

    protected void addExtraPopupMenuActions(DefaultActionGroup group) {
    }

    public void setProcessController(ProcessController controller) {
        this.myProcessController = controller;
    }

    public void stopProcess() {
        this.myProcessController.stopProcess();
    }

    public boolean canControlProcess() {
        return this.myProcessController != null;
    }

    public boolean isProcessStopped() {
        return this.myProcessController.isProcessStopped();
    }

    public void close() {
        MessageView messageView = MessageView.SERVICE.getInstance(this.myProject);
        Content content2 = messageView.getContentManager().getContent((JComponent)this);
        if (content2 != null) {
            messageView.getContentManager().removeContent(content2, true);
            Disposer.dispose((Disposable)this);
        }
    }

    public void setProgress(String s, float fraction) {
        this.myProgressText = s;
        this.myFraction = fraction;
        this.updateProgress();
    }

    public void setProgressText(String s) {
        this.myProgressText = s;
        this.updateProgress();
    }

    public void setFraction(float fraction) {
        this.myFraction = fraction;
        this.updateProgress();
    }

    public void clearProgressData() {
        if (this.myProgressPanel != null) {
            this.myProgressText = " ";
            this.myFraction = 0.0f;
            this.updateProgress();
        }
    }

    private void updateProgress() {
        if (this.myIsDisposed) {
            return;
        }
        this.myUpdateAlarm.cancelAllRequests();
        this.myUpdateAlarm.addRequest(() -> {
            this.initProgressPanel();
            float fraction = this.myFraction;
            String text = this.myProgressText;
            if (fraction > 0.0f) {
                this.myProgressLabel.setText((int)((double)(fraction * 100.0f) + 0.5) + "%  " + text);
            } else {
                this.myProgressLabel.setText(text);
            }
        }, 50, ModalityState.NON_MODAL);
    }

    private void initProgressPanel() {
        if (this.myProgressPanel == null) {
            this.myProgressPanel = new JPanel(new GridLayout(1, 2));
            this.myProgressLabel = new JLabel();
            this.myProgressPanel.add(this.myProgressLabel);
            this.myMessagePanel.add((Component)this.myProgressPanel, "South");
            this.myMessagePanel.validate();
        }
    }

    public void collapseAll() {
        TreeUtil.collapseAll((JTree)this.myTree, (int)2);
    }

    public void expandAll() {
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        TreePath leadSelectionPath = this.myTree.getLeadSelectionPath();
        for (int row = 0; row < this.myTree.getRowCount(); ++row) {
            this.myTree.expandRow(row);
        }
        if (selectionPaths != null) {
            this.myTree.setSelectionPaths(selectionPaths);
        }
        if (leadSelectionPath != null) {
            this.myTree.scrollPathToVisible(leadSelectionPath);
        }
    }

    private JPanel createToolbarPanel(@Nullable Runnable rerunAction) {
        DefaultActionGroup group = new DefaultActionGroup();
        CloseTabToolbarAction closeMessageViewAction = new CloseTabToolbarAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                NewErrorTreeViewPanel.this.close();
            }
        };
        if (rerunAction != null) {
            group.add((AnAction)new RerunAction(rerunAction, (AnAction)closeMessageViewAction));
        }
        group.add((AnAction)new StopAction());
        if (this.canHideWarnings()) {
            group.addSeparator();
            group.add((AnAction)new ShowInfosAction());
            group.add((AnAction)new ShowWarningsAction());
        }
        this.fillRightToolbarGroup(group);
        ActionManager actionManager = ActionManager.getInstance();
        this.myLeftToolbar = actionManager.createActionToolbar("CompilerMessagesToolbar", (ActionGroup)group, false);
        return JBUI.Panels.simplePanel((Component)this.myLeftToolbar.getComponent());
    }

    protected void fillRightToolbarGroup(DefaultActionGroup group) {
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurrenceNavigatorSupport.goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurrenceNavigatorSupport.goPreviousOccurence();
    }

    public boolean hasNextOccurence() {
        return this.myOccurrenceNavigatorSupport.hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myOccurrenceNavigatorSupport.hasPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        return this.myOccurrenceNavigatorSupport.getNextOccurenceActionName();
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        return this.myOccurrenceNavigatorSupport.getPreviousOccurenceActionName();
    }

    protected boolean canHideWarnings() {
        return true;
    }

    public boolean isHideWarnings() {
        return this.myConfiguration.isHideWarnings();
    }

    public boolean isHideInfos() {
        return this.myConfiguration.isHideInfoMessages();
    }

    public List<Object> getGroupChildrenData(String groupName) {
        return this.myErrorViewStructure.getGroupChildrenData(groupName);
    }

    public void removeGroup(String name) {
        this.myErrorViewStructure.removeGroup(name);
    }

    public void addFixedHotfixGroup(String text, List<? extends SimpleErrorData> children2) {
        this.myErrorViewStructure.addFixedHotfixGroup(text, children2);
    }

    public void addHotfixGroup(HotfixData hotfixData, List<? extends SimpleErrorData> children2) {
        this.myErrorViewStructure.addHotfixGroup(hotfixData, children2, this);
    }

    public void reload() {
        this.myStructureModel.invalidate();
    }

    private static class MyOccurrenceNavigatorSupport
    extends OccurenceNavigatorSupport {
        MyOccurrenceNavigatorSupport(Tree tree) {
            super((JTree)tree);
        }

        protected Navigatable createDescriptorForNode(@NotNull DefaultMutableTreeNode node) {
            Object userObject = node.getUserObject();
            if (!(userObject instanceof ErrorTreeNodeDescriptor)) {
                return null;
            }
            ErrorTreeNodeDescriptor descriptor2 = (ErrorTreeNodeDescriptor)((Object)userObject);
            ErrorTreeElement element2 = descriptor2.getElement();
            if (element2 instanceof NavigatableErrorTreeElement) {
                return ((NavigatableErrorTreeElement)((Object)element2)).getNavigatable();
            }
            return null;
        }

        @NotNull
        public String getNextOccurenceActionName() {
            return IdeBundle.message((String)"action.next.message", (Object[])new Object[0]);
        }

        @NotNull
        public String getPreviousOccurenceActionName() {
            return IdeBundle.message((String)"action.previous.message", (Object[])new Object[0]);
        }
    }

    private class MyTreeExpander
    implements TreeExpander {
        private MyTreeExpander() {
        }

        public void expandAll() {
            NewErrorTreeViewPanel.this.expandAll();
        }

        public boolean canExpand() {
            return true;
        }

        public void collapseAll() {
            NewErrorTreeViewPanel.this.collapseAll();
        }

        public boolean canCollapse() {
            return true;
        }
    }

    private class ShowInfosAction
    extends ToggleAction
    implements DumbAware {
        ShowInfosAction() {
            super(IdeBundle.messagePointer((String)"action.show.infos", (Object[])new Object[0]), AllIcons.General.ShowInfos);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            return !NewErrorTreeViewPanel.this.isHideInfos();
        }

        public void setSelected(@NotNull AnActionEvent event, boolean showInfos) {
            boolean hideInfos;
            boolean bl = hideInfos = !showInfos;
            if (NewErrorTreeViewPanel.this.myConfiguration.isHideInfoMessages() != hideInfos) {
                NewErrorTreeViewPanel.this.myConfiguration.setHideInfoMessages(hideInfos);
                NewErrorTreeViewPanel.this.myStructureModel.invalidate();
            }
        }
    }

    private class ShowWarningsAction
    extends ToggleAction
    implements DumbAware {
        ShowWarningsAction() {
            super(IdeBundle.messagePointer((String)"action.show.warnings", (Object[])new Object[0]), AllIcons.General.ShowWarning);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            return !NewErrorTreeViewPanel.this.isHideWarnings();
        }

        public void setSelected(@NotNull AnActionEvent event, boolean showWarnings) {
            boolean hideWarnings;
            boolean bl = hideWarnings = !showWarnings;
            if (NewErrorTreeViewPanel.this.myConfiguration.isHideWarnings() != hideWarnings) {
                NewErrorTreeViewPanel.this.myConfiguration.setHideWarnings(hideWarnings);
                NewErrorTreeViewPanel.this.myStructureModel.invalidate();
            }
        }
    }

    private class StopAction
    extends DumbAwareAction {
        StopAction() {
            super(IdeBundle.messagePointer((String)"action.stop", (Object[])new Object[0]), AllIcons.Actions.Suspend);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (NewErrorTreeViewPanel.this.canControlProcess()) {
                NewErrorTreeViewPanel.this.stopProcess();
            }
            NewErrorTreeViewPanel.this.myLeftToolbar.updateActionsImmediately();
        }

        public void update(@NotNull AnActionEvent event) {
            Presentation presentation2 = event.getPresentation();
            presentation2.setEnabled(NewErrorTreeViewPanel.this.canControlProcess() && !NewErrorTreeViewPanel.this.isProcessStopped());
            presentation2.setVisible(NewErrorTreeViewPanel.this.canControlProcess());
        }
    }

    private class RerunAction
    extends DumbAwareAction {
        private final Runnable myRerunAction;
        private final AnAction myCloseAction;

        RerunAction(@NotNull Runnable rerunAction, AnAction closeAction2) {
            super(IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), null, AllIcons.Actions.Rerun);
            this.myRerunAction = rerunAction;
            this.myCloseAction = closeAction2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myCloseAction.actionPerformed(e);
            this.myRerunAction.run();
        }

        public void update(@NotNull AnActionEvent event) {
            Presentation presentation2 = event.getPresentation();
            presentation2.setEnabled(NewErrorTreeViewPanel.this.canControlProcess() && NewErrorTreeViewPanel.this.isProcessStopped());
        }
    }

    public static interface ProcessController {
        public void stopProcess();

        public boolean isProcessStopped();
    }
}

