/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.cds;

import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.cds.CDSFUSCollector;
import com.intellij.ide.cds.CDSManager;
import com.intellij.ide.cds.CDSPaths;
import com.intellij.ide.cds.CDSStartupActivity;
import com.intellij.ide.cds.CDSStartupActivity$BuildCDSWhenPossibleAction$WhenMappings;
import com.intellij.ide.cds.CDSStartupActivityKt;
import com.intellij.ide.cds.CDSTaskResult;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.io.PowerStatus;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003\u000e\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/cds/CDSStartupActivity;", "Lcom/intellij/openapi/startup/StartupActivity$DumbAware;", "()V", "isExecuted", "Ljava/util/concurrent/atomic/AtomicBoolean;", "setupResult", "Ljava/util/concurrent/atomic/AtomicReference;", "", "getSetupResult", "()Ljava/util/concurrent/atomic/AtomicReference;", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "AverageCPULoad", "BuildCDSWhenPossibleAction", "WaitOutcome", "intellij.platform.ide.impl"})
public final class CDSStartupActivity
implements StartupActivity.DumbAware {
    private final AtomicBoolean isExecuted = new AtomicBoolean(false);
    @NotNull
    private final AtomicReference<String> setupResult = new AtomicReference<Object>(null);

    @NotNull
    public final AtomicReference<String> getSetupResult() {
        return this.setupResult;
    }

    public void runActivity(@NotNull Project project) {
        if (!this.isExecuted.compareAndSet(false, true) || !Registry.is((String)"appcds.useStartupActivity")) {
            return;
        }
        NonUrgentExecutor.getInstance().execute(new Runnable(this){
            final /* synthetic */ CDSStartupActivity this$0;

            public final void run() {
                if (!CDSManager.INSTANCE.isValidEnv() && !Registry.is((String)"appcds.assumeValidEnv")) {
                    return;
                }
                boolean cdsEnabled = Registry.is((String)"appcds.enabled");
                File cdsArchive = CDSManager.INSTANCE.getCurrentCDSArchive();
                if (cdsArchive != null && cdsArchive.isFile()) {
                    Logger.getInstance(CDSManager.class).warn("Running with enabled CDS " + cdsArchive + ", " + StringUtil.formatFileSize((long)cdsArchive.length()));
                    CDSFUSCollector.INSTANCE.logCDSStatus(cdsEnabled, true);
                } else {
                    CDSFUSCollector.INSTANCE.logCDSStatus(cdsEnabled, false);
                }
                String cdsOnSecondStartKey = "appcds.runOnSecondStart";
                if (Registry.is((String)cdsOnSecondStartKey)) {
                    PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
                    String hash = CDSPaths.Companion.getCurrent().getCdsClassesHash();
                    if (Intrinsics.areEqual((Object)propertiesComponent.getValue(cdsOnSecondStartKey), (Object)hash) ^ true) {
                        propertiesComponent.setValue(cdsOnSecondStartKey, hash);
                        return;
                    }
                }
                AppExecutorUtil.getAppExecutorService().submit(new Runnable(this, cdsEnabled){
                    final /* synthetic */ runActivity.1 this$0;
                    final /* synthetic */ boolean $cdsEnabled;

                    public final void run() {
                        CDSManager.INSTANCE.cleanupStaleCDSFiles(this.$cdsEnabled);
                        if (!this.$cdsEnabled) {
                            CDSManager.INSTANCE.removeCDS();
                            this.this$0.this$0.getSetupResult().set("removed");
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$cdsEnabled = bl;
                    }
                });
                if (cdsEnabled) {
                    new BuildCDSWhenPossibleAction(this.this$0.getSetupResult()).start();
                }
            }
            {
                this.this$0 = cDSStartupActivity;
            }
        });
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/cds/CDSStartupActivity$WaitOutcome;", "", "(Ljava/lang/String;I)V", "NO_WAIT_NEEDED", "CHECK_AGAIN", "TOO_HIGH_CPU_LOAD", "WAIT_LONG", "intellij.platform.ide.impl"})
    private static final class WaitOutcome
    extends Enum<WaitOutcome> {
        public static final /* enum */ WaitOutcome NO_WAIT_NEEDED;
        public static final /* enum */ WaitOutcome CHECK_AGAIN;
        public static final /* enum */ WaitOutcome TOO_HIGH_CPU_LOAD;
        public static final /* enum */ WaitOutcome WAIT_LONG;
        private static final /* synthetic */ WaitOutcome[] $VALUES;

        static {
            WaitOutcome[] waitOutcomeArray = new WaitOutcome[4];
            WaitOutcome[] waitOutcomeArray2 = waitOutcomeArray;
            waitOutcomeArray[0] = NO_WAIT_NEEDED = new WaitOutcome();
            waitOutcomeArray[1] = CHECK_AGAIN = new WaitOutcome();
            waitOutcomeArray[2] = TOO_HIGH_CPU_LOAD = new WaitOutcome();
            waitOutcomeArray[3] = WAIT_LONG = new WaitOutcome();
            $VALUES = waitOutcomeArray;
        }

        public static WaitOutcome[] values() {
            return (WaitOutcome[])$VALUES.clone();
        }

        public static WaitOutcome valueOf(String string) {
            return Enum.valueOf(WaitOutcome.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001cJ\b\u0010\u001f\u001a\u00020 H\u0016J\u0006\u0010!\u001a\u00020 R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0013\u001a\u0004\u0018\u00010\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\""}, d2={"Lcom/intellij/ide/cds/CDSStartupActivity$BuildCDSWhenPossibleAction;", "Ljava/lang/Runnable;", "setupResult", "Ljava/util/concurrent/atomic/AtomicReference;", "", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "cpuCount", "", "osBean", "Lcom/sun/management/OperatingSystemMXBean;", "kotlin.jvm.PlatformType", "processCpuLoad", "", "getProcessCpuLoad", "()Ljava/lang/Double;", "processCpuLoad$delegate", "Lcom/intellij/ide/cds/CDSStartupActivity$AverageCPULoad;", "getSetupResult", "()Ljava/util/concurrent/atomic/AtomicReference;", "systemCpuLoad", "getSystemCpuLoad", "systemCpuLoad$delegate", "waitIdle", "", "getWaitIdle", "()Z", "canStillWork", "needsWaitingForIdleMillis", "Lcom/intellij/ide/cds/CDSStartupActivity$WaitOutcome;", "reschedule", "outcome", "run", "", "start", "intellij.platform.ide.impl"})
    private static final class BuildCDSWhenPossibleAction
    implements Runnable {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        private final OperatingSystemMXBean osBean;
        private final int cpuCount;
        private final AverageCPULoad processCpuLoad$delegate;
        private final AverageCPULoad systemCpuLoad$delegate;
        @NotNull
        private final AtomicReference<String> setupResult;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BuildCDSWhenPossibleAction.class), "processCpuLoad", "getProcessCpuLoad()Ljava/lang/Double;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BuildCDSWhenPossibleAction.class), "systemCpuLoad", "getSystemCpuLoad()Ljava/lang/Double;"))};
        }

        private final Double getProcessCpuLoad() {
            return this.processCpuLoad$delegate.getValue(this, $$delegatedProperties[0]);
        }

        private final Double getSystemCpuLoad() {
            return this.systemCpuLoad$delegate.getValue(this, $$delegatedProperties[1]);
        }

        private final boolean getWaitIdle() {
            return Registry.is((String)"appcds.install.idleTestEnabled");
        }

        public final void start() {
            if (this.getWaitIdle()) {
                this.reschedule(WaitOutcome.WAIT_LONG);
            } else {
                this.run();
            }
        }

        public final boolean reschedule(@NotNull WaitOutcome outcome) {
            long l;
            switch (CDSStartupActivity$BuildCDSWhenPossibleAction$WhenMappings.$EnumSwitchMapping$0[outcome.ordinal()]) {
                case 1: {
                    return false;
                }
                case 2: {
                    l = Registry.intValue((String)"appcds.install.idleRecheckDelay");
                    break;
                }
                case 3: {
                    l = Registry.intValue((String)"appcds.install.idleTooHeavyCPULoadDelay");
                    break;
                }
                case 4: {
                    l = Registry.intValue((String)"appcds.install.idleLongRetryDelay");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            long time = l;
            AppExecutorUtil.getAppScheduledExecutorService().schedule(this, time, TimeUnit.MILLISECONDS);
            return true;
        }

        @NotNull
        public final WaitOutcome needsWaitingForIdleMillis() {
            Object object = this;
            boolean bl = false;
            try {
                Result.Companion companion = Result.Companion;
                BuildCDSWhenPossibleAction $this$runCatching = object;
                boolean bl2 = false;
                if (!$this$runCatching.getWaitIdle()) {
                    return WaitOutcome.NO_WAIT_NEEDED;
                }
                if (PowerSaveMode.isEnabled()) {
                    return WaitOutcome.WAIT_LONG;
                }
                if (PowerStatus.Companion.getPowerStatus() == PowerStatus.BATTERY) {
                    return WaitOutcome.WAIT_LONG;
                }
                Double processCPULoad = $this$runCatching.getProcessCpuLoad();
                Double systemCPULoad = $this$runCatching.getSystemCpuLoad();
                if (processCPULoad == null || systemCPULoad == null) {
                    return WaitOutcome.CHECK_AGAIN;
                }
                if (processCPULoad * (double)$this$runCatching.cpuCount > 2.5) {
                    return WaitOutcome.TOO_HIGH_CPU_LOAD;
                }
                if (systemCPULoad * (double)$this$runCatching.cpuCount > 3.7) {
                    return WaitOutcome.TOO_HIGH_CPU_LOAD;
                }
                if (CDSPaths.Companion.getFreeSpaceForCDS() < 0xC0000000L) {
                    return WaitOutcome.WAIT_LONG;
                }
                return WaitOutcome.NO_WAIT_NEEDED;
            }
            catch (Throwable $this$runCatching) {
                Object object2;
                Object object3;
                Result.Companion bl2 = Result.Companion;
                boolean bl3 = false;
                object = object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
                bl = false;
                boolean bl4 = false;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable == null) {
                    object2 = object;
                } else {
                    Throwable it = throwable;
                    boolean bl5 = false;
                    object2 = WaitOutcome.WAIT_LONG;
                }
                return (WaitOutcome)((Object)object2);
            }
        }

        public final boolean canStillWork() {
            return this.needsWaitingForIdleMillis().compareTo((Enum)WaitOutcome.CHECK_AGAIN) <= 0;
        }

        @Override
        public void run() {
            WaitOutcome timeToSleep = this.needsWaitingForIdleMillis();
            if (this.reschedule(timeToSleep)) {
                return;
            }
            CDSManager.INSTANCE.installCDS((Function0<Boolean>)((Function0)new Function0<Boolean>(this){

                public final boolean invoke() {
                    return ((BuildCDSWhenPossibleAction)this.receiver).canStillWork();
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(BuildCDSWhenPossibleAction.class);
                }

                public final String getName() {
                    return "canStillWork";
                }

                public final String getSignature() {
                    return "canStillWork()Z";
                }
            }), (Function1<? super CDSTaskResult, Unit>)((Function1)new Function1<CDSTaskResult, Unit>(this){
                final /* synthetic */ BuildCDSWhenPossibleAction this$0;

                public final void invoke(@NotNull CDSTaskResult result2) {
                    if (result2 instanceof CDSTaskResult.InterruptedForRetry) {
                        CDSStartupActivityKt.access$getLOG$p().info("CDS archive generation paused due to high CPU load and will be re-scheduled later");
                        this.this$0.reschedule(WaitOutcome.WAIT_LONG);
                    } else {
                        this.this$0.getSetupResult().set("enabled:" + result2.getStatusName());
                    }
                }
                {
                    this.this$0 = buildCDSWhenPossibleAction;
                    super(1);
                }
            }));
        }

        @NotNull
        public final AtomicReference<String> getSetupResult() {
            return this.setupResult;
        }

        public BuildCDSWhenPossibleAction(@NotNull AtomicReference<String> setupResult) {
            this.setupResult = setupResult;
            this.osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
            this.cpuCount = this.osBean.getAvailableProcessors();
            this.processCpuLoad$delegate = new AverageCPULoad((Function0<Double>)((Function0)new Function0<Double>(this){
                final /* synthetic */ BuildCDSWhenPossibleAction this$0;

                public final double invoke() {
                    return BuildCDSWhenPossibleAction.access$getOsBean$p(this.this$0).getProcessCpuLoad();
                }
                {
                    this.this$0 = buildCDSWhenPossibleAction;
                    super(0);
                }
            }));
            this.systemCpuLoad$delegate = new AverageCPULoad((Function0<Double>)((Function0)new Function0<Double>(this){
                final /* synthetic */ BuildCDSWhenPossibleAction this$0;

                public final double invoke() {
                    return BuildCDSWhenPossibleAction.access$getOsBean$p(this.this$0).getSystemCpuLoad();
                }
                {
                    this.this$0 = buildCDSWhenPossibleAction;
                    super(0);
                }
            }));
        }

        public static final /* synthetic */ OperatingSystemMXBean access$getOsBean$p(BuildCDSWhenPossibleAction $this) {
            return $this.osBean;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010\u0011J\u000f\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/cds/CDSStartupActivity$AverageCPULoad;", "", "compute", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "getCompute", "()Lkotlin/jvm/functions/Function0;", "index", "", "measurements", "", "times", "", "getValue", "x", "p", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Double;", "nextValue", "()Ljava/lang/Double;", "now", "", "Companion", "intellij.platform.ide.impl"})
    private static final class AverageCPULoad {
        private int index;
        private final double[] measurements;
        private final long[] times;
        @NotNull
        private final Function0<Double> compute;
        private static final int minMetricsTimeDifference = 100;
        private static final int minMeasurementTime = 2000;
        private static final int maxMeasurementTime = 5000;
        private static final int minMeasurementsCount = 3;
        private static final int samples = 128;
        public static final Companion Companion = new Companion(null);

        private final long now() {
            return System.currentTimeMillis();
        }

        @Nullable
        public final Double getValue(@Nullable Object x, @NotNull Object p) {
            return this.nextValue();
        }

        private final Double nextValue() {
            double nextResult;
            Object object;
            long now = this.now();
            AverageCPULoad averageCPULoad = this;
            boolean bl = false;
            try {
                object = Result.Companion;
                AverageCPULoad $this$runCatching = averageCPULoad;
                boolean bl2 = false;
                Double d = ((Number)$this$runCatching.compute.invoke()).doubleValue();
                bl2 = false;
                object = Result.constructor-impl((Object)d);
            }
            catch (Throwable throwable) {
                Result.Companion bl2 = Result.Companion;
                boolean bl3 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            averageCPULoad = object;
            bl = false;
            Double d = (Double)((Object)(Result.isFailure-impl((Object)averageCPULoad) ? null : averageCPULoad));
            if (d == null) {
                return null;
            }
            double d2 = nextResult = d.doubleValue();
            boolean bl4 = false;
            if (Double.isNaN(d2) || nextResult < 0.0 || nextResult > 1.0) {
                return null;
            }
            int previousRecord = (this.index + 128 - 1) % 128;
            if (now - this.times[previousRecord] < (long)100) {
                return null;
            }
            this.measurements[this.index] = nextResult;
            this.times[this.index] = now;
            this.index = (this.index + 1) % 128;
            double sum = 0.0;
            int count = 0;
            long maxDiff = 0L;
            Iterable $this$forEach$iv = (Iterable)ArraysKt.getIndices((double[])this.measurements);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                int element$iv;
                int idx = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl5 = false;
                long time = now - this.times[idx];
                if (time >= (long)5000) continue;
                long l = maxDiff;
                boolean bl6 = false;
                maxDiff = Math.max(l, time);
                sum += this.measurements[idx];
                int n = count;
                count = n + 1;
            }
            if (maxDiff < (long)2000 || count < 3) {
                return null;
            }
            return sum / (double)count;
        }

        @NotNull
        public final Function0<Double> getCompute() {
            return this.compute;
        }

        public AverageCPULoad(@NotNull Function0<Double> compute) {
            this.compute = compute;
            this.measurements = new double[128];
            this.times = new long[128];
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/cds/CDSStartupActivity$AverageCPULoad$Companion;", "", "()V", "maxMeasurementTime", "", "minMeasurementTime", "minMeasurementsCount", "minMetricsTimeDifference", "samples", "intellij.platform.ide.impl"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

