/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.LangBundle;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.reference.SoftReference;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.IconWithToolTip;
import com.intellij.ui.JBColor;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.ui.JBCachingScalableIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Bookmark
implements Navigatable,
Comparable<Bookmark> {
    static final Icon DEFAULT_ICON = new MyCheckedIcon();
    private OpenFileDescriptor myTarget;
    private Reference<RangeHighlighterEx> myHighlighterRef;
    private int myLine;
    private String myUrl;
    @NotNull
    private String myDescription;
    private char myMnemonic;
    int index;

    @ApiStatus.Internal
    public Bookmark(@NotNull String url, int line, @NotNull String description) {
        this.myUrl = url;
        this.myLine = line;
        this.myDescription = description;
    }

    Bookmark(@NotNull Project project, @NotNull VirtualFile file2, int line, @NotNull String description) {
        this.myDescription = description;
        this.initTarget(project, file2, line);
    }

    @Nullable
    OpenFileDescriptor init(@NotNull Project project) {
        if (this.myTarget != null) {
            throw new IllegalStateException("Bookmark is already initialized (file=" + this.myTarget + ")");
        }
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(this.myUrl);
        if (file2 == null) {
            return null;
        }
        this.myUrl = null;
        this.initTarget(project, file2, this.myLine);
        this.myLine = -1;
        return this.myTarget;
    }

    private void initTarget(@NotNull Project project, @NotNull VirtualFile file2, int line) {
        this.myTarget = new OpenFileDescriptor(project, file2, line, -1, true);
        this.addHighlighter();
    }

    @NotNull
    public static Font getBookmarkFont() {
        return EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
    }

    @Override
    public int compareTo(@NotNull Bookmark o) {
        int i2;
        int n = this.myMnemonic != '\u0000' ? (o.myMnemonic != '\u0000' ? this.myMnemonic - o.myMnemonic : -1) : (i2 = o.myMnemonic != '\u0000' ? 1 : 0);
        if (i2 != 0) {
            return i2;
        }
        i2 = this.myTarget.getProject().getName().compareTo(o.myTarget.getProject().getName());
        if (i2 != 0) {
            return i2;
        }
        i2 = this.myTarget.getFile().getName().compareTo(o.getFile().getName());
        if (i2 != 0) {
            return i2;
        }
        return this.getTarget().compareTo(o.getTarget());
    }

    void updateHighlighter() {
        this.release();
        this.addHighlighter();
    }

    private void addHighlighter() {
        Document document = this.getCachedDocument();
        if (document != null) {
            this.createHighlighter((MarkupModelEx)DocumentMarkupModel.forDocument(document, this.myTarget.getProject(), true));
        }
    }

    public RangeHighlighter createHighlighter(@NotNull MarkupModelEx markup) {
        RangeHighlighterEx highlighter;
        int line = this.getLine();
        if (line >= 0) {
            highlighter = markup.addPersistentLineHighlighter(CodeInsightColors.BOOKMARKS_ATTRIBUTES, line, 5001);
            if (highlighter != null) {
                highlighter.setGutterIconRenderer(new MyGutterIconRenderer(this));
                highlighter.setErrorStripeTooltip(this.getBookmarkTooltip());
            }
        } else {
            highlighter = null;
        }
        this.myHighlighterRef = highlighter == null ? null : new WeakReference<RangeHighlighterEx>(highlighter);
        return highlighter;
    }

    @Deprecated
    @Nullable
    public Document getDocument() {
        return this.getCachedDocument();
    }

    Document getCachedDocument() {
        return FileDocumentManager.getInstance().getCachedDocument(this.getFile());
    }

    public void release() {
        int line = this.getLine();
        if (line < 0) {
            return;
        }
        Document document = this.getCachedDocument();
        if (document == null) {
            return;
        }
        MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument(document, this.myTarget.getProject(), true);
        Document markupDocument = markup.getDocument();
        if (markupDocument.getLineCount() <= line) {
            return;
        }
        RangeHighlighterEx highlighter = this.findMyHighlighter();
        if (highlighter != null) {
            this.myHighlighterRef = null;
            highlighter.dispose();
        }
    }

    private RangeHighlighterEx findMyHighlighter() {
        Document document = this.getCachedDocument();
        if (document == null) {
            return null;
        }
        RangeHighlighterEx result2 = (RangeHighlighterEx)SoftReference.dereference(this.myHighlighterRef);
        if (result2 != null) {
            return result2;
        }
        MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument(document, this.myTarget.getProject(), true);
        Document markupDocument = markup.getDocument();
        boolean startOffset = false;
        int endOffset = markupDocument.getTextLength();
        Ref found = new Ref();
        markup.processRangeHighlightersOverlappingWith(0, endOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            GutterIconRenderer renderer = highlighter.getGutterIconRenderer();
            if (renderer instanceof MyGutterIconRenderer && ((MyGutterIconRenderer)renderer).myBookmark == this) {
                found.set(highlighter);
                return false;
            }
            return true;
        }));
        result2 = (RangeHighlighterEx)found.get();
        this.myHighlighterRef = result2 == null ? null : new WeakReference<RangeHighlighterEx>(result2);
        return result2;
    }

    public Icon getIcon() {
        return this.myMnemonic == '\u0000' ? DEFAULT_ICON : MnemonicIcon.getIcon(this.myMnemonic);
    }

    @NotNull
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@NotNull String description) {
        this.myDescription = description;
    }

    public char getMnemonic() {
        return this.myMnemonic;
    }

    public void setMnemonic(char mnemonic) {
        this.myMnemonic = Character.toUpperCase(mnemonic);
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myTarget.getFile();
    }

    @Nullable
    String nullizeEmptyDescription() {
        return StringUtil.nullize((String)this.myDescription);
    }

    public boolean isValid() {
        if (!this.getFile().isValid()) {
            return false;
        }
        if (this.getLine() == -1) {
            return true;
        }
        RangeHighlighterEx highlighter = this.findMyHighlighter();
        return highlighter != null && highlighter.isValid();
    }

    public boolean canNavigate() {
        return this.getTarget().canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.getTarget().canNavigateToSource();
    }

    public void navigate(boolean requestFocus) {
        this.getTarget().navigate(requestFocus);
    }

    public int getLine() {
        int targetLine = this.myTarget.getLine();
        if (targetLine == -1) {
            return -1;
        }
        RangeHighlighterEx highlighter = this.findMyHighlighter();
        if (highlighter != null && highlighter.isValid()) {
            Document document = highlighter.getDocument();
            return document.getLineNumber(highlighter.getStartOffset());
        }
        RangeMarker marker = this.myTarget.getRangeMarker();
        if (marker != null && marker.isValid()) {
            Document document = marker.getDocument();
            return document.getLineNumber(marker.getStartOffset());
        }
        return targetLine;
    }

    @NotNull
    private OpenFileDescriptor getTarget() {
        int line = this.getLine();
        if (line != this.myTarget.getLine()) {
            this.myTarget = new OpenFileDescriptor(this.myTarget.getProject(), this.myTarget.getFile(), line, -1, true);
        }
        return this.myTarget;
    }

    public String toString() {
        String description;
        StringBuilder result2 = new StringBuilder(this.myTarget == null ? this.myUrl : this.getQualifiedName());
        String text = this.nullizeEmptyDescription();
        String string = description = text == null ? null : StringUtil.escapeXmlEntities((String)text);
        if (description != null) {
            result2.append(": ").append(description);
        }
        return result2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getQualifiedName() {
        String presentableUrl = this.myTarget.getFile().getPresentableUrl();
        if (this.myTarget.getFile().isDirectory()) {
            return presentableUrl;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myTarget.getProject()).findFile(this.myTarget.getFile());
        if (psiFile == null) {
            return presentableUrl;
        }
        StructureViewBuilder builder2 = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(psiFile);
        if (builder2 instanceof TreeBasedStructureViewBuilder) {
            ItemPresentation presentation2;
            Object element2;
            StructureViewModel model = ((TreeBasedStructureViewBuilder)builder2).createStructureViewModel(null);
            try {
                element2 = model.getCurrentEditorElement();
            }
            finally {
                Disposer.dispose((Disposable)model);
            }
            if (element2 instanceof NavigationItem && (presentation2 = ((NavigationItem)element2).getPresentation()) != null) {
                presentableUrl = ((NavigationItem)element2).getName() + " " + presentation2.getLocationString();
            }
        }
        return IdeBundle.message((String)"bookmark.file.X.line.Y", (Object[])new Object[]{presentableUrl, this.getLine() + 1});
    }

    @NotNull
    private String getBookmarkTooltip() {
        String shortcutText;
        String text;
        String description;
        StringBuilder result2 = new StringBuilder("Bookmark");
        if (this.myMnemonic != '\u0000') {
            result2.append(" ").append(this.myMnemonic);
        }
        String string = description = (text = this.nullizeEmptyDescription()) == null ? null : StringUtil.escapeXmlEntities((String)text);
        if (description != null) {
            result2.append(": ").append(description);
        }
        StringBuilder shortcutDescription = new StringBuilder();
        if (this.myMnemonic != '\u0000') {
            String navigateShortcutText;
            shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)("ToggleBookmark" + this.myMnemonic));
            if (shortcutText.length() > 0) {
                shortcutDescription.append(shortcutText).append(" to toggle");
            }
            if ((navigateShortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)("GotoBookmark" + this.myMnemonic))).length() > 0) {
                if (shortcutDescription.length() > 0) {
                    shortcutDescription.append(", ");
                }
                shortcutDescription.append(navigateShortcutText).append(" to jump to");
            }
        }
        if (shortcutDescription.length() == 0 && (shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)"ToggleBookmark")).length() > 0) {
            shortcutDescription.append(shortcutText).append(" to toggle");
        }
        if (shortcutDescription.length() > 0) {
            result2.append(" (").append((CharSequence)shortcutDescription).append(")");
        }
        return result2.toString();
    }

    private static boolean darkBackground() {
        Color gutterBackground = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.GUTTER_BACKGROUND);
        if (gutterBackground == null) {
            gutterBackground = EditorColors.GUTTER_BACKGROUND.getDefaultColor();
        }
        return ColorUtil.isDark((Color)gutterBackground);
    }

    private static class MyGutterIconRenderer
    extends GutterIconRenderer
    implements DumbAware {
        private final Bookmark myBookmark;

        MyGutterIconRenderer(@NotNull Bookmark bookmark) {
            this.myBookmark = bookmark;
        }

        @NotNull
        public Icon getIcon() {
            return this.myBookmark.getIcon();
        }

        @NotNull
        public String getTooltipText() {
            return this.myBookmark.getBookmarkTooltip();
        }

        @NotNull
        public GutterDraggableObject getDraggableObject() {
            return new GutterDraggableObject(){

                public boolean copy(int line, VirtualFile file2, int actionId) {
                    myBookmark.myTarget = new OpenFileDescriptor(myBookmark.myTarget.getProject(), file2, line, -1, true);
                    myBookmark.updateHighlighter();
                    return true;
                }
            };
        }

        @NotNull
        public String getAccessibleName() {
            return LangBundle.message((String)"accessible.name.icon.bookmark.0", (Object[])new Object[]{Character.valueOf(this.myBookmark.myMnemonic)});
        }

        public boolean equals(Object obj) {
            return obj instanceof MyGutterIconRenderer && Objects.equals(this.getTooltipText(), ((MyGutterIconRenderer)((Object)obj)).getTooltipText()) && Comparing.equal((Object)this.getIcon(), (Object)((MyGutterIconRenderer)((Object)obj)).getIcon());
        }

        public int hashCode() {
            return this.getIcon().hashCode();
        }

        @Nullable
        public ActionGroup getPopupMenuActions() {
            return (ActionGroup)ActionManager.getInstance().getAction("popup@BookmarkContextMenu");
        }
    }

    private static class MyCheckedIcon
    extends JBCachingScalableIcon<MyCheckedIcon>
    implements RetrievableIcon,
    IconWithToolTip {
        private MyCheckedIcon() {
        }

        @NotNull
        public Icon retrieveIcon() {
            return IconUtil.scale((Icon)PlatformIcons.CHECK_ICON, null, (float)this.getScale());
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            IconUtil.scale((Icon)PlatformIcons.CHECK_ICON, (Component)c, (float)this.getScale()).paintIcon(c, g, x, y);
        }

        public int getIconWidth() {
            return this.scale(PlatformIcons.CHECK_ICON.getIconWidth());
        }

        private int scale(int width) {
            return (int)Math.ceil(this.scaleVal(width, ScaleType.OBJ_SCALE));
        }

        public int getIconHeight() {
            return this.scale(PlatformIcons.CHECK_ICON.getIconHeight());
        }

        @NotNull
        public MyCheckedIcon copy() {
            return new MyCheckedIcon();
        }

        public String getToolTip(boolean composite) {
            return IdeBundle.message((String)"tooltip.bookmarked", (Object[])new Object[0]);
        }
    }

    static class MnemonicIcon
    extends JBCachingScalableIcon<MnemonicIcon> {
        private static final MnemonicIcon[] cache = new MnemonicIcon[36];
        private final char myMnemonic;

        @NotNull
        public MnemonicIcon copy() {
            return new MnemonicIcon(this.myMnemonic);
        }

        @NotNull
        static MnemonicIcon getIcon(char mnemonic) {
            int index = mnemonic - 48;
            if (index > 9) {
                index -= 7;
            }
            if (index < 0 || index > cache.length - 1) {
                return new MnemonicIcon(mnemonic);
            }
            if (cache[index] == null) {
                MnemonicIcon.cache[index] = new MnemonicIcon(mnemonic);
            }
            return cache[index];
        }

        private MnemonicIcon(char mnemonic) {
            this.myMnemonic = mnemonic;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            int width = this.getIconWidth();
            int height = this.getIconHeight();
            g.setColor((Color)new JBColor(() -> !Bookmark.darkBackground() ? new Color(0xFFFFCC) : new Color(6770995)));
            g.fillRect(x, y, width, height);
            g.setColor((Color)JBColor.GRAY);
            g.drawRect(x, y, width, height);
            g.setColor(EditorColorsManager.getInstance().getGlobalScheme().getDefaultForeground());
            UISettings.setupAntialiasing((Graphics)g);
            float startingFontSize = 40.0f;
            Font font = Bookmark.getBookmarkFont().deriveFont(startingFontSize);
            FontRenderContext fontRenderContext = ((Graphics2D)g).getFontRenderContext();
            double height40 = font.createGlyphVector(fontRenderContext, new char[]{'A'}).getVisualBounds().getHeight();
            font = font.deriveFont((float)((double)(startingFontSize * (float)height) / height40 * 0.7));
            GlyphVector gv = font.createGlyphVector(fontRenderContext, new char[]{this.myMnemonic});
            Rectangle2D bounds2 = gv.getVisualBounds();
            ((Graphics2D)g).drawGlyphVector(gv, (float)((double)x + ((double)width - bounds2.getWidth()) / 2.0 - bounds2.getX()), (float)((double)y + ((double)height - bounds2.getHeight()) / 2.0 - bounds2.getY()));
        }

        public int getIconWidth() {
            return this.scale(DEFAULT_ICON.getIconWidth());
        }

        private int scale(int width) {
            return (int)Math.ceil(this.scaleVal(width, ScaleType.OBJ_SCALE));
        }

        public int getIconHeight() {
            return this.scale(DEFAULT_ICON.getIconHeight());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MnemonicIcon that = (MnemonicIcon)((Object)o);
            return this.myMnemonic == that.myMnemonic;
        }

        public int hashCode() {
            return this.myMnemonic;
        }
    }
}

