/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.searcheverywhere.AbstractGotoSEContributor;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereDataKeys;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.FileTypeRef;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoFileConfiguration;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.ui.IdeUICustomization;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class FileSearchEverywhereContributor
extends AbstractGotoSEContributor {
    private final GotoFileModel myModelForRenderer;
    private final PersistentSearchEverywhereContributorFilter<FileTypeRef> myFilter;

    public FileSearchEverywhereContributor(@NotNull AnActionEvent event) {
        super(event);
        Project project = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
        this.myModelForRenderer = new GotoFileModel(project);
        this.myFilter = FileSearchEverywhereContributor.createFileTypeFilter(project);
    }

    @NotNull
    public String getGroupName() {
        return IdeBundle.message((String)"search.everywhere.group.name.files", (Object[])new Object[0]);
    }

    public String includeNonProjectItemsText() {
        return IdeUICustomization.getInstance().projectMessage("checkbox.include.non.project.files", new Object[0]);
    }

    public int getSortWeight() {
        return 200;
    }

    @Override
    public int getElementPriority(@NotNull Object element2, @NotNull String searchPattern) {
        return super.getElementPriority(element2, searchPattern) + 2;
    }

    @NotNull
    protected FilteringGotoByModel<FileTypeRef> createModel(@NotNull Project project) {
        GotoFileModel model = new GotoFileModel(project);
        if (this.myFilter != null) {
            model.setFilterItems(this.myFilter.getSelectedElements());
        }
        return model;
    }

    @NotNull
    public List<AnAction> getActions(@NotNull Runnable onChanged) {
        return this.doGetActions(this.includeNonProjectItemsText(), this.myFilter, onChanged);
    }

    @Override
    @NotNull
    public ListCellRenderer<Object> getElementsRenderer() {
        return new AbstractGotoSEContributor.SERenderer(){

            @Override
            @NotNull
            protected PsiElementListCellRenderer.ItemMatchers getItemMatchers(@NotNull JList list2, @NotNull Object value2) {
                PsiElementListCellRenderer.ItemMatchers defaultMatchers = super.getItemMatchers(list2, value2);
                if (!(value2 instanceof PsiFileSystemItem) || FileSearchEverywhereContributor.this.myModelForRenderer == null) {
                    return defaultMatchers;
                }
                return GotoFileModel.convertToFileItemMatchers(defaultMatchers, (PsiFileSystemItem)value2, FileSearchEverywhereContributor.this.myModelForRenderer);
            }
        };
    }

    @Override
    public boolean processSelectedItem(@NotNull Object selected2, int modifiers, @NotNull String searchText) {
        VirtualFile file2;
        if (selected2 instanceof PsiFile && (file2 = ((PsiFile)selected2).getVirtualFile()) != null && this.myProject != null) {
            Pair<Integer, Integer> pos = FileSearchEverywhereContributor.getLineAndColumn(searchText);
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(this.myProject, file2, ((Integer)pos.first).intValue(), ((Integer)pos.second).intValue());
            descriptor2.setUseCurrentWindow(FileSearchEverywhereContributor.openInCurrentWindow(modifiers));
            if (descriptor2.canNavigate()) {
                descriptor2.navigate(true);
                return true;
            }
        }
        return super.processSelectedItem(selected2, modifiers, searchText);
    }

    @Override
    public Object getDataForItem(@NotNull Object element2, @NotNull String dataId) {
        if (CommonDataKeys.PSI_FILE.is(dataId) && element2 instanceof PsiFile) {
            return element2;
        }
        if (SearchEverywhereDataKeys.ITEM_STRING_DESCRIPTION.is(dataId) && (element2 instanceof PsiFile || element2 instanceof PsiDirectory)) {
            String basePath;
            String path = ((PsiFileSystemItem)element2).getVirtualFile().getPath();
            path = FileUtil.toSystemIndependentName((String)path);
            if (this.myProject != null && (basePath = this.myProject.getBasePath()) != null) {
                path = FileUtil.getRelativePath((String)basePath, (String)path, (char)'/');
            }
            return path;
        }
        return super.getDataForItem(element2, dataId);
    }

    @NotNull
    public static PersistentSearchEverywhereContributorFilter<FileTypeRef> createFileTypeFilter(@NotNull Project project) {
        List<FileTypeRef> items = FileTypeRef.forAllFileTypes();
        return new PersistentSearchEverywhereContributorFilter<FileTypeRef>(items, GotoFileConfiguration.getInstance(project), FileTypeRef::getName, FileTypeRef::getIcon);
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<Object> {
        @NotNull
        public SearchEverywhereContributor<Object> createContributor(@NotNull AnActionEvent initEvent) {
            return new FileSearchEverywhereContributor(initEvent);
        }
    }
}

