/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.runAnything.RunAnythingUtil;
import com.intellij.ide.actions.runAnything.execution.RunAnythingRunProfile;
import com.intellij.ide.actions.runAnything.handlers.RunAnythingCommandHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunAnythingRunProfileState
extends CommandLineState {
    public RunAnythingRunProfileState(@NotNull ExecutionEnvironment environment, @NotNull String originalCommand) {
        super(environment);
        Project project = environment.getProject();
        RunAnythingCommandHandler handler2 = RunAnythingCommandHandler.getMatchedHandler(project, originalCommand);
        if (handler2 != null) {
            this.setConsoleBuilder(handler2.getConsoleBuilder(project));
        }
    }

    @NotNull
    private RunAnythingRunProfile getRunProfile() {
        RunProfile runProfile = this.getEnvironment().getRunProfile();
        if (!(runProfile instanceof RunAnythingRunProfile)) {
            throw new IllegalStateException("Got " + runProfile + " instead of RunAnything profile");
        }
        return (RunAnythingRunProfile)runProfile;
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        RunAnythingRunProfile runProfile = this.getRunProfile();
        GeneralCommandLine commandLine = runProfile.getCommandLine();
        final String originalCommand = runProfile.getOriginalCommand();
        KillableColoredProcessHandler processHandler2 = new KillableColoredProcessHandler(commandLine){
            long creationTime;

            public void startNotify() {
                this.creationTime = System.currentTimeMillis();
                super.startNotify();
            }

            @Override
            protected void notifyProcessTerminated(int exitCode) {
                this.print(IdeBundle.message((String)"run.anything.console.process.finished", (Object[])new Object[]{exitCode}), ConsoleViewContentType.SYSTEM_OUTPUT);
                this.printCustomCommandOutput();
                super.notifyProcessTerminated(exitCode);
            }

            private void printCustomCommandOutput() {
                String customOutput;
                RunAnythingCommandHandler handler2 = RunAnythingCommandHandler.getMatchedHandler(RunAnythingRunProfileState.this.getEnvironment().getProject(), originalCommand);
                if (handler2 != null && (customOutput = handler2.getProcessTerminatedCustomOutput(this.creationTime)) != null) {
                    this.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                    this.print(customOutput, ConsoleViewContentType.SYSTEM_OUTPUT);
                }
            }

            @Override
            public final boolean shouldKillProcessSoftly() {
                RunAnythingCommandHandler handler2 = RunAnythingCommandHandler.getMatchedHandler(RunAnythingRunProfileState.this.getEnvironment().getProject(), originalCommand);
                return handler2 != null ? handler2.shouldKillProcessSoftly() : super.shouldKillProcessSoftly();
            }

            private void print(@NotNull String message, @NotNull ConsoleViewContentType consoleViewContentType) {
                ConsoleView console = this.getConsoleView();
                if (console != null) {
                    console.print(message, consoleViewContentType);
                }
            }

            @Nullable
            private ConsoleView getConsoleView() {
                RunContentDescriptor contentDescriptor = RunContentManager.getInstance((Project)RunAnythingRunProfileState.this.getEnvironment().getProject()).findContentDescriptor(RunAnythingRunProfileState.this.getEnvironment().getExecutor(), (ProcessHandler)this);
                ConsoleView console = null;
                if (contentDescriptor != null && contentDescriptor.getExecutionConsole() instanceof ConsoleView) {
                    console = (ConsoleView)contentDescriptor.getExecutionConsole();
                }
                return console;
            }
        };
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){
            boolean myIsFirstLineAdded;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (!this.myIsFirstLineAdded) {
                    Objects.requireNonNull(RunAnythingUtil.getOrCreateWrappedCommands(RunAnythingRunProfileState.this.getEnvironment().getProject())).add((Pair<String, String>)Pair.create((Object)StringUtil.trim((String)event.getText()), (Object)originalCommand));
                    this.myIsFirstLineAdded = true;
                }
            }
        });
        processHandler2.setHasPty(true);
        return processHandler2;
    }
}

