/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything;

import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.BigPopupUI;
import com.intellij.ide.actions.bigPopup.ShowFilterAction;
import com.intellij.ide.actions.runAnything.RunAnythingAction;
import com.intellij.ide.actions.runAnything.RunAnythingCache;
import com.intellij.ide.actions.runAnything.RunAnythingCalcThread;
import com.intellij.ide.actions.runAnything.RunAnythingChooseContextAction;
import com.intellij.ide.actions.runAnything.RunAnythingContext;
import com.intellij.ide.actions.runAnything.RunAnythingIconHandler;
import com.intellij.ide.actions.runAnything.RunAnythingMore;
import com.intellij.ide.actions.runAnything.RunAnythingMyAccessibleComponent;
import com.intellij.ide.actions.runAnything.RunAnythingSearchListModel;
import com.intellij.ide.actions.runAnything.RunAnythingUsageCollector;
import com.intellij.ide.actions.runAnything.RunAnythingUtil;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProvider;
import com.intellij.ide.actions.runAnything.groups.RunAnythingCompletionGroup;
import com.intellij.ide.actions.runAnything.groups.RunAnythingGroup;
import com.intellij.ide.actions.runAnything.items.RunAnythingItem;
import com.intellij.ide.actions.runAnything.ui.RunAnythingScrollingUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.accessibility.Accessible;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunAnythingPopupUI
extends BigPopupUI {
    public static final int SEARCH_FIELD_COLUMNS = 25;
    public static final Icon UNKNOWN_CONFIGURATION_ICON = AllIcons.Actions.Run_anything;
    static final String RUN_ANYTHING = "RunAnything";
    public static final KeyStroke DOWN_KEYSTROKE = KeyStroke.getKeyStroke(40, 0);
    public static final KeyStroke UP_KEYSTROKE = KeyStroke.getKeyStroke(38, 0);
    private static final Border RENDERER_BORDER = JBUI.Borders.empty((int)1, (int)0);
    private static final String HELP_PLACEHOLDER = "?";
    private boolean myIsUsedTrigger;
    private volatile ActionCallback myCurrentWorker;
    private boolean mySkipFocusGain = false;
    @Nullable
    private final VirtualFile myVirtualFile;
    private JLabel myTextFieldTitle;
    private boolean myIsItemSelected;
    private String myLastInputText = null;
    private final Project myProject;
    private final Module myModule;
    private RunAnythingContext mySelectedExecutingContext;
    private final List<RunAnythingContext> myAvailableExecutingContexts = new ArrayList<RunAnythingContext>();
    private RunAnythingChooseContextAction myChooseContextAction;
    private final Alarm myListRenderingAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private final ExecutorService myExecutorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Run Anything list building");

    @Nullable
    public String getUserInputText() {
        return this.myResultsList.getSelectedIndex() >= 0 ? this.myLastInputText : this.mySearchField.getText();
    }

    private void onMouseClicked(@NotNull MouseEvent event) {
        int clickCount = event.getClickCount();
        if (clickCount > 1 && clickCount % 2 == 0) {
            event.consume();
            int i2 = this.myResultsList.locationToIndex(event.getPoint());
            if (i2 != -1) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getField(), true));
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myResultsList.setSelectedIndex(i2);
                    this.executeCommand();
                });
            }
        }
    }

    private void initSearchField() {
        this.updateContextCombobox();
        this.mySearchField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                RunAnythingPopupUI.this.myIsUsedTrigger = true;
                String pattern = RunAnythingPopupUI.this.mySearchField.getText();
                if (RunAnythingPopupUI.this.mySearchField.hasFocus()) {
                    ApplicationManager.getApplication().invokeLater(() -> RunAnythingPopupUI.this.myIsItemSelected = false);
                    if (!RunAnythingPopupUI.this.myIsItemSelected) {
                        RunAnythingPopupUI.this.myLastInputText = null;
                        RunAnythingPopupUI.this.clearSelection();
                        ApplicationManager.getApplication().invokeLater(() -> RunAnythingPopupUI.this.rebuildList());
                    }
                    if (!RunAnythingPopupUI.isHelpMode(pattern)) {
                        RunAnythingPopupUI.this.updateContextCombobox();
                        RunAnythingPopupUI.adjustMainListEmptyText((JBTextField)RunAnythingPopupUI.this.mySearchField);
                        return;
                    }
                    RunAnythingPopupUI.adjustEmptyText((JBTextField)RunAnythingPopupUI.this.mySearchField, (BooleanFunction<JBTextField>)((BooleanFunction)field -> true), "", IdeBundle.message((String)"run.anything.help.list.empty.secondary.text", (Object[])new Object[0]));
                }
            }
        });
        this.mySearchField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (RunAnythingPopupUI.this.mySkipFocusGain) {
                    RunAnythingPopupUI.this.mySkipFocusGain = false;
                    return;
                }
                RunAnythingPopupUI.this.rebuildList();
            }

            @Override
            public void focusLost(FocusEvent e) {
                RunAnythingPopupUI.this.searchFinishedHandler.run();
            }
        });
    }

    private static void adjustMainListEmptyText(@NotNull JBTextField editor) {
        RunAnythingPopupUI.adjustEmptyText(editor, (BooleanFunction<JBTextField>)((BooleanFunction)field -> field.getText().isEmpty()), IdeBundle.message((String)"run.anything.main.list.empty.primary.text", (Object[])new Object[0]), IdeBundle.message((String)"run.anything.main.list.empty.secondary.text", (Object[])new Object[0]));
    }

    static boolean isHelpMode(@NotNull String pattern) {
        return pattern.startsWith(HELP_PLACEHOLDER);
    }

    private void clearSelection() {
        this.myResultsList.getSelectionModel().clearSelection();
    }

    private JTextField getField() {
        return this.mySearchField;
    }

    private void executeCommand() {
        RunAnythingGroup group;
        String pattern = this.getField().getText();
        int index = this.myResultsList.getSelectedIndex();
        if (pattern.isEmpty() && index == -1) {
            return;
        }
        RunAnythingSearchListModel model = RunAnythingPopupUI.getSearchingModel(this.myResultsList);
        if (index != -1 && model != null && this.isMoreItem(index) && (group = model.findGroupByMoreIndex(index)) != null) {
            this.myCurrentWorker.doWhenProcessed(() -> {
                RunAnythingUsageCollector.Companion.triggerMoreStatistics(this.myProject, group, ((Object)((Object)model)).getClass());
                RunAnythingSearchListModel listModel = (RunAnythingSearchListModel)((Object)((Object)this.myResultsList.getModel()));
                this.myCurrentWorker = RunAnythingPopupUI.insert(group, listModel, this.getDataContext(), this.getSearchPattern(), index, -1);
                this.myCurrentWorker.doWhenProcessed(() -> {
                    this.clearSelection();
                    ScrollingUtil.selectItem((JList)this.myResultsList, (int)index);
                });
            });
            return;
        }
        if (model != null) {
            RunAnythingUsageCollector.Companion.triggerExecCategoryStatistics(this.myProject, model.getGroups(), ((Object)((Object)model)).getClass(), index, RunAnythingAction.SHIFT_IS_PRESSED.get(), RunAnythingAction.ALT_IS_PRESSED.get());
        }
        RunAnythingUtil.executeMatched(this.getDataContext(), pattern);
        this.mySearchField.setText("");
        this.searchFinishedHandler.run();
        this.triggerUsed();
    }

    @NotNull
    public static ActionCallback insert(@NotNull RunAnythingGroup group, @NotNull RunAnythingSearchListModel listModel, @NotNull DataContext dataContext, @NotNull String pattern, int index, int itemsNumberToInsert) {
        ActionCallback callback2 = new ActionCallback();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            RunAnythingGroup.SearchResult result2;
            List items = (List)StreamEx.of((Collection)listModel.getItems()).select(RunAnythingItem.class).collect(Collectors.toList());
            try {
                result2 = (RunAnythingGroup.SearchResult)ProgressManager.getInstance().runProcess(() -> group.getItems(dataContext, items, RunAnythingPopupUI.trimHelpPattern(pattern), itemsNumberToInsert == -1 ? group.getMaxItemsToInsert() : itemsNumberToInsert), (ProgressIndicator)new EmptyProgressIndicator());
            }
            catch (ProcessCanceledException e) {
                callback2.setRejected();
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                int shift = 0;
                int i2 = index + 1;
                for (Object o : result2) {
                    listModel.add(i2, o);
                    ++shift;
                    ++i2;
                }
                listModel.shiftIndexes(index, shift);
                if (!result2.isNeedMore()) {
                    group.resetMoreIndex();
                }
                callback2.setDone();
            });
        });
        return callback2;
    }

    @NotNull
    private Project getProject() {
        return this.myProject;
    }

    @Nullable
    private Module getModule() {
        Module moduleForFile;
        Module moduleForFile2;
        if (this.myModule != null) {
            return this.myModule;
        }
        Project project = this.getProject();
        if (this.myVirtualFile != null && (moduleForFile2 = ModuleUtilCore.findModuleForFile((VirtualFile)this.myVirtualFile, (Project)project)) != null) {
            return moduleForFile2;
        }
        VirtualFile[] selectedFiles = FileEditorManager.getInstance((Project)project).getSelectedFiles();
        if (selectedFiles.length != 0 && (moduleForFile = ModuleUtilCore.findModuleForFile((VirtualFile)selectedFiles[0], (Project)project)) != null) {
            return moduleForFile;
        }
        return null;
    }

    @NotNull
    private VirtualFile getWorkDirectory() {
        if (RunAnythingAction.ALT_IS_PRESSED.get()) {
            VirtualFile file2;
            VirtualFile[] selectedFiles;
            if (this.myVirtualFile != null) {
                VirtualFile file3;
                VirtualFile virtualFile = file3 = this.myVirtualFile.isDirectory() ? this.myVirtualFile : this.myVirtualFile.getParent();
                if (file3 != null) {
                    return file3;
                }
            }
            if ((selectedFiles = FileEditorManager.getInstance((Project)this.getProject()).getSelectedFiles()).length > 0 && (file2 = selectedFiles[0].getParent()) != null) {
                return file2;
            }
        }
        return this.getBaseDirectory(this.getModule());
    }

    @NotNull
    private VirtualFile getBaseDirectory(@Nullable Module module) {
        VirtualFile projectBaseDir = this.getProject().getBaseDir();
        if (module == null) {
            return projectBaseDir;
        }
        VirtualFile firstContentRoot = this.getFirstContentRoot(module);
        if (firstContentRoot == null) {
            return projectBaseDir;
        }
        return firstContentRoot;
    }

    @Nullable
    public VirtualFile getFirstContentRoot(@NotNull Module module) {
        if (module.isDisposed()) {
            return null;
        }
        return (VirtualFile)ArrayUtil.getFirstElement((Object[])ModuleRootManager.getInstance((Module)module).getContentRoots());
    }

    private boolean isMoreItem(int index) {
        RunAnythingSearchListModel model = RunAnythingPopupUI.getSearchingModel(this.myResultsList);
        return model != null && model.isMoreIndex(index);
    }

    @Nullable
    public static RunAnythingSearchListModel getSearchingModel(@NotNull JBList list2) {
        ListModel model = list2.getModel();
        return model instanceof RunAnythingSearchListModel ? (RunAnythingSearchListModel)((Object)model) : null;
    }

    private void rebuildList() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myListRenderingAlarm.cancelAllRequests();
        this.myResultsList.getEmptyText().setText(FindBundle.message("empty.text.searching", new Object[0]));
        if (DumbService.getInstance((Project)this.myProject).isDumb()) {
            this.myResultsList.setEmptyText(IdeBundle.message((String)"run.anything.indexing.mode.not.supported", (Object[])new Object[0]));
            return;
        }
        ReadAction.nonBlocking(new RunAnythingCalcThread(this.myProject, this.getDataContext(), this.getSearchPattern())::compute).coalesceBy(new Object[]{this}).finishOnUiThread(ModalityState.defaultModalityState(), model -> this.myListRenderingAlarm.addRequest(() -> {
            this.addListDataListener((AbstractListModel<Object>)((Object)model));
            this.myResultsList.setModel((ListModel)((Object)model));
            model.update();
        }, 150)).submit((Executor)this.myExecutorService);
    }

    @Override
    protected void addListDataListener(@NotNull AbstractListModel<Object> model) {
        model.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                RunAnythingPopupUI.this.updateViewType(BigPopupUI.ViewType.FULL);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                if (RunAnythingPopupUI.this.myResultsList.isEmpty()) {
                    RunAnythingPopupUI.this.updateViewType(BigPopupUI.ViewType.SHORT);
                }
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                RunAnythingPopupUI.this.updateViewType(RunAnythingPopupUI.this.myResultsList.isEmpty() ? BigPopupUI.ViewType.SHORT : BigPopupUI.ViewType.FULL);
            }
        });
    }

    protected void resetFields() {
        this.mySkipFocusGain = false;
    }

    public void initResultsList() {
        this.myResultsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RunAnythingPopupUI.this.updateAdText(RunAnythingPopupUI.this.getDataContext());
                Object selectedValue = RunAnythingPopupUI.this.myResultsList.getSelectedValue();
                if (selectedValue == null) {
                    return;
                }
                String lastInput = RunAnythingPopupUI.this.mySearchField.getText();
                RunAnythingPopupUI.this.myIsItemSelected = true;
                if (RunAnythingPopupUI.this.isMoreItem(RunAnythingPopupUI.this.myResultsList.getSelectedIndex())) {
                    if (RunAnythingPopupUI.this.myLastInputText != null) {
                        RunAnythingPopupUI.this.mySearchField.setText(RunAnythingPopupUI.this.myLastInputText);
                    }
                    return;
                }
                RunAnythingPopupUI.this.mySearchField.setText(selectedValue instanceof RunAnythingItem ? ((RunAnythingItem)selectedValue).getCommand() : RunAnythingPopupUI.this.myLastInputText);
                if (RunAnythingPopupUI.this.myLastInputText == null) {
                    RunAnythingPopupUI.this.myLastInputText = lastInput;
                }
            }
        });
    }

    private void updateContextCombobox() {
        Object value2;
        String text;
        DataContext dataContext = this.getDataContext();
        RunAnythingProvider provider = RunAnythingProvider.findMatchedProvider(dataContext, text = (value2 = this.myResultsList.getSelectedValue()) instanceof RunAnythingItem ? ((RunAnythingItem)value2).getCommand() : this.getSearchPattern());
        if (provider != null) {
            this.myChooseContextAction.setAvailableContexts(provider.getExecutionContexts(dataContext));
        }
        AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext);
        ActionUtil.performDumbAwareUpdate((boolean)false, (AnAction)this.myChooseContextAction, (AnActionEvent)event, (boolean)false);
    }

    @Override
    @NotNull
    public JPanel createTopLeftPanel() {
        this.myTextFieldTitle = new JLabel(IdeBundle.message((String)"run.anything.run.anything.title", (Object[])new Object[0]));
        NonOpaquePanel topPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        Color foregroundColor = StartupUiUtil.isUnderDarcula() ? (UIUtil.isUnderWin10LookAndFeel() ? JBColor.WHITE : new JBColor((Color)Gray._240, (Color)Gray._200)) : UIUtil.getLabelForeground();
        this.myTextFieldTitle.setForeground(foregroundColor);
        this.myTextFieldTitle.setBorder(BorderFactory.createEmptyBorder(3, 5, 5, 0));
        if (SystemInfo.isMac) {
            this.myTextFieldTitle.setFont(this.myTextFieldTitle.getFont().deriveFont(1, (float)this.myTextFieldTitle.getFont().getSize() - 1.0f));
        } else {
            this.myTextFieldTitle.setFont(this.myTextFieldTitle.getFont().deriveFont(1));
        }
        topPanel.add(this.myTextFieldTitle);
        return topPanel;
    }

    @NotNull
    private DataContext getDataContext() {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(CommonDataKeys.PROJECT.getName(), this.getProject());
        dataMap.put(LangDataKeys.MODULE.getName(), this.getModule());
        dataMap.put(CommonDataKeys.VIRTUAL_FILE.getName(), this.getWorkDirectory());
        dataMap.put(RunAnythingAction.EXECUTOR_KEY.getName(), RunAnythingPopupUI.getExecutor());
        dataMap.put(RunAnythingProvider.EXECUTING_CONTEXT.getName(), this.myChooseContextAction.getSelectedContext());
        return SimpleDataContext.getSimpleContext(dataMap, null);
    }

    public void initMySearchField() {
        this.mySearchField.putClientProperty((Object)"JTextField.match", (Object)UNKNOWN_CONFIGURATION_ICON);
        this.setHandleMatchedConfiguration();
        RunAnythingPopupUI.adjustMainListEmptyText((JBTextField)this.mySearchField);
        this.mySearchField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                this.updateByModifierKeysEvent(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.updateByModifierKeysEvent(e);
            }

            private void updateByModifierKeysEvent(@NotNull KeyEvent e) {
                String message = e.isShiftDown() && e.isAltDown() ? IdeBundle.message((String)"run.anything.run.in.context.debug.title", (Object[])new Object[0]) : (e.isShiftDown() ? IdeBundle.message((String)"run.anything.run.debug.title", (Object[])new Object[0]) : (e.isAltDown() ? IdeBundle.message((String)"run.anything.run.in.context.title", (Object[])new Object[0]) : IdeBundle.message((String)"run.anything.run.anything.title", (Object[])new Object[0])));
                RunAnythingPopupUI.this.myTextFieldTitle.setText(message);
                RunAnythingPopupUI.this.updateMatchedRunConfigurationStuff(e.isAltDown());
            }
        });
        this.initSearchField();
        this.mySearchField.setColumns(25);
    }

    public static void adjustEmptyText(@NotNull JBTextField textEditor, @NotNull BooleanFunction<JBTextField> function, @NotNull String leftText, @NotNull String rightText) {
        textEditor.putClientProperty((Object)"StatusVisibleFunction", function);
        StatusText statusText = textEditor.getEmptyText();
        statusText.setShowAboveCenter(false);
        statusText.setText(leftText, SimpleTextAttributes.GRAY_ATTRIBUTES);
        statusText.appendText(false, 0, rightText, SimpleTextAttributes.GRAY_ATTRIBUTES, null);
        statusText.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
    }

    private void setHandleMatchedConfiguration() {
        this.mySearchField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                RunAnythingPopupUI.this.updateMatchedRunConfigurationStuff(RunAnythingAction.ALT_IS_PRESSED.get());
            }
        });
    }

    private void updateMatchedRunConfigurationStuff(boolean isAltPressed) {
        ExtendableTextField textField2 = this.mySearchField;
        String pattern = textField2.getText();
        DataContext dataContext = this.getDataContext();
        RunAnythingProvider provider = RunAnythingProvider.findMatchedProvider(dataContext, pattern);
        if (provider == null) {
            return;
        }
        Object value2 = provider.findMatchingValue(dataContext, pattern);
        if (value2 == null) {
            return;
        }
        Icon icon2 = provider.getIcon(value2);
        if (icon2 == null) {
            return;
        }
        textField2.putClientProperty((Object)"JTextField.match", (Object)icon2);
    }

    private void updateAdText(@NotNull DataContext dataContext) {
        String adText;
        RunAnythingProvider provider;
        Object value2 = this.myResultsList.getSelectedValue();
        if (value2 instanceof RunAnythingItem && (provider = RunAnythingProvider.findMatchedProvider(dataContext, ((RunAnythingItem)value2).getCommand())) != null && (adText = provider.getAdText()) != null) {
            this.setAdText(adText);
        }
    }

    private void triggerUsed() {
        if (this.myIsUsedTrigger) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(RUN_ANYTHING);
        }
        this.myIsUsedTrigger = false;
    }

    public void setAdText(@NotNull String s) {
        this.myHintLabel.setText(s);
    }

    @NotNull
    public static com.intellij.execution.Executor getExecutor() {
        com.intellij.execution.Executor runExecutor = DefaultRunExecutor.getRunExecutorInstance();
        com.intellij.execution.Executor debugExecutor = ExecutorRegistry.getInstance().getExecutorById("Debug");
        return !RunAnythingAction.SHIFT_IS_PRESSED.get() ? runExecutor : debugExecutor;
    }

    @NotNull
    public static String trimHelpPattern(@NotNull String pattern) {
        return RunAnythingPopupUI.isHelpMode(pattern) ? pattern.substring(HELP_PLACEHOLDER.length()) : pattern;
    }

    @Override
    public void installScrollingActions() {
        RunAnythingScrollingUtil.installActions((JList)this.myResultsList, this.getField(), () -> {
            this.myIsItemSelected = true;
            this.mySearchField.setText(this.myLastInputText);
            this.clearSelection();
        }, UISettings.getInstance().getCycleScrolling());
        super.installScrollingActions();
    }

    public RunAnythingPopupUI(@NotNull AnActionEvent actionEvent) {
        super(actionEvent.getProject());
        this.myCurrentWorker = ActionCallback.DONE;
        this.myVirtualFile = (VirtualFile)actionEvent.getData(CommonDataKeys.VIRTUAL_FILE);
        this.myProject = (Project)Objects.requireNonNull(actionEvent.getData(CommonDataKeys.PROJECT));
        this.myModule = (Module)actionEvent.getData(LangDataKeys.MODULE);
        this.init();
        this.initSearchActions();
        this.initResultsList();
        this.initSearchField();
        this.initMySearchField();
    }

    @Override
    @NotNull
    public JBList<Object> createList() {
        RunAnythingSearchListModel.RunAnythingMainListModel listModel = new RunAnythingSearchListModel.RunAnythingMainListModel();
        this.addListDataListener((AbstractListModel<Object>)((Object)listModel));
        return new JBList((ListModel)((Object)listModel));
    }

    private void initSearchActions() {
        this.myResultsList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RunAnythingPopupUI.this.onMouseClicked(e);
            }
        });
        DumbAwareAction.create(e -> RunAnythingUtil.jumpNextGroup(true, this.myResultsList)).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"TAB"}), (JComponent)this.mySearchField, (Disposable)this);
        DumbAwareAction.create(e -> RunAnythingUtil.jumpNextGroup(false, this.myResultsList)).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"shift TAB"}), (JComponent)this.mySearchField, (Disposable)this);
        AnAction escape = ActionManager.getInstance().getAction("EditorEscape");
        DumbAwareAction.create(__ -> {
            this.triggerUsed();
            this.searchFinishedHandler.run();
        }).registerCustomShortcutSet(escape == null ? CommonShortcuts.ESCAPE : escape.getShortcutSet(), (JComponent)((Object)this));
        DumbAwareAction.create(e -> this.executeCommand()).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER", "shift ENTER", "alt ENTER", "alt shift ENTER", "meta ENTER"}), (JComponent)this.mySearchField, (Disposable)this);
        DumbAwareAction.create(e -> {
            RunAnythingSearchListModel model = RunAnythingPopupUI.getSearchingModel(this.myResultsList);
            if (model == null) {
                return;
            }
            Object selectedValue = this.myResultsList.getSelectedValue();
            int index = this.myResultsList.getSelectedIndex();
            if (!(selectedValue instanceof RunAnythingItem) || this.isMoreItem(index)) {
                return;
            }
            RunAnythingCache.getInstance(this.getProject()).getState().getCommands().remove(((RunAnythingItem)selectedValue).getCommand());
            model.remove(index);
            model.shiftIndexes(index, -1);
            if (!model.isEmpty()) {
                ScrollingUtil.selectItem((JList)this.myResultsList, (int)(index < model.getSize() ? index : index - 1));
            }
        }).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"shift BACK_SPACE"}), (JComponent)this.mySearchField, (Disposable)this);
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void exitDumbMode() {
                ApplicationManager.getApplication().invokeLater(() -> RunAnythingPopupUI.this.rebuildList());
            }
        });
    }

    @Override
    @NotNull
    protected ListCellRenderer<Object> createCellRenderer() {
        return new MyListRenderer();
    }

    @Override
    @NotNull
    protected JPanel createSettingsPanel() {
        JPanel res2 = new JPanel(new FlowLayout(2, 0, 0));
        res2.setOpaque(false);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        this.myChooseContextAction = new RunAnythingChooseContextAction(res2){

            @Override
            public void setAvailableContexts(@NotNull List<? extends RunAnythingContext> executionContexts) {
                RunAnythingPopupUI.this.myAvailableExecutingContexts.clear();
                RunAnythingPopupUI.this.myAvailableExecutingContexts.addAll(executionContexts);
            }

            @Override
            @NotNull
            public List<RunAnythingContext> getAvailableContexts() {
                return RunAnythingPopupUI.this.myAvailableExecutingContexts;
            }

            @Override
            public void setSelectedContext(@Nullable RunAnythingContext context) {
                RunAnythingPopupUI.this.mySelectedExecutingContext = context;
            }

            @Override
            @Nullable
            public RunAnythingContext getSelectedContext() {
                return RunAnythingPopupUI.this.mySelectedExecutingContext;
            }
        };
        actionGroup.addAction((AnAction)this.myChooseContextAction);
        actionGroup.addAction((AnAction)new RunAnythingShowFilterAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("run.anything.toolbar", (ActionGroup)actionGroup, true);
        toolbar.setLayoutPolicy(0);
        toolbar.updateActionsImmediately();
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setOpaque(false);
        res2.add(toolbarComponent);
        return res2;
    }

    @Override
    @NotNull
    protected String getInitialHint() {
        return IdeBundle.message((String)"run.anything.hint.initial.text", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)UP_KEYSTROKE), KeymapUtil.getKeystrokeText((KeyStroke)DOWN_KEYSTROKE)});
    }

    @Override
    @NotNull
    protected String getAccessibleName() {
        return IdeBundle.message((String)"run.anything.accessible.name", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected ExtendableTextField createSearchField() {
        ExtendableTextField searchField = super.createSearchField();
        Consumer extensionConsumer = extension -> searchField.addExtension(extension);
        searchField.addPropertyChangeListener((PropertyChangeListener)new RunAnythingIconHandler((Consumer<? super ExtendableTextComponent.Extension>)extensionConsumer, (JTextComponent)searchField));
        return searchField;
    }

    public void dispose() {
        this.resetFields();
    }

    private class RunAnythingShowFilterAction
    extends ShowFilterAction {
        @NotNull
        private final Collection<RunAnythingGroup> myTemplateGroups = RunAnythingCompletionGroup.createCompletionGroups();

        private RunAnythingShowFilterAction() {
        }

        @Override
        @NotNull
        public String getDimensionServiceKey() {
            return "RunAnythingAction_Filter_Popup";
        }

        @Override
        protected boolean isEnabled() {
            return true;
        }

        @Override
        protected boolean isActive() {
            return this.myTemplateGroups.size() != this.getVisibleGroups().size();
        }

        @Override
        protected ElementsChooser<?> createChooser() {
            ElementsChooser<RunAnythingGroup> res2 = new ElementsChooser<RunAnythingGroup>(new ArrayList<RunAnythingGroup>(this.myTemplateGroups), false){

                @Override
                protected String getItemText(@NotNull RunAnythingGroup value2) {
                    return value2.getTitle();
                }
            };
            res2.markElements(this.getVisibleGroups());
            ElementsChooser.ElementsMarkListener<RunAnythingGroup> listener2 = (element2, isMarked) -> {
                RunAnythingCache.getInstance(RunAnythingPopupUI.this.myProject).saveGroupVisibilityKey(element2 instanceof RunAnythingCompletionGroup ? ((RunAnythingCompletionGroup)element2).getProvider().getClass().getCanonicalName() : element2.getTitle(), isMarked);
                RunAnythingPopupUI.this.rebuildList();
            };
            res2.addElementsMarkListener(listener2);
            return res2;
        }

        @NotNull
        private List<RunAnythingGroup> getVisibleGroups() {
            return ContainerUtil.filter(this.myTemplateGroups, group -> RunAnythingCache.getInstance(RunAnythingPopupUI.this.myProject).isGroupVisible((RunAnythingGroup)group));
        }
    }

    private class MyListRenderer
    extends ColoredListCellRenderer<Object> {
        private final RunAnythingMyAccessibleComponent myMainPanel = new RunAnythingMyAccessibleComponent(new BorderLayout());

        private MyListRenderer() {
        }

        public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean hasFocus) {
            String title;
            Color foreground;
            Color bg;
            Component cmp = null;
            if (RunAnythingPopupUI.this.isMoreItem(index)) {
                cmp = RunAnythingMore.get(isSelected);
            }
            if (cmp == null) {
                if (value2 instanceof RunAnythingItem) {
                    cmp = ((RunAnythingItem)value2).createComponent(RunAnythingPopupUI.this.myLastInputText, isSelected, hasFocus);
                } else {
                    cmp = super.getListCellRendererComponent(list2, value2, index, isSelected, isSelected);
                    JPanel p = new JPanel(new BorderLayout());
                    p.setBackground(UIUtil.getListBackground((boolean)isSelected, (boolean)true));
                    p.add(cmp, "Center");
                    cmp = p;
                }
            }
            if ((bg = cmp.getBackground()) == null) {
                cmp.setBackground(UIUtil.getListBackground((boolean)isSelected));
                bg = cmp.getBackground();
            }
            if ((foreground = cmp.getForeground()) == null) {
                cmp.setForeground(UIUtil.getListForeground((boolean)isSelected));
                foreground = cmp.getBackground();
            }
            this.myMainPanel.removeAll();
            RunAnythingSearchListModel model = RunAnythingPopupUI.getSearchingModel(RunAnythingPopupUI.this.myResultsList);
            if (model != null && (title = model.getTitle(index)) != null) {
                this.myMainPanel.add((Component)RunAnythingUtil.createTitle(" " + title, UIUtil.getListBackground((boolean)false, (boolean)false)), "North");
            }
            JPanel wrapped = new JPanel(new BorderLayout());
            wrapped.setBackground(bg);
            wrapped.setForeground(foreground);
            wrapped.setBorder(RENDERER_BORDER);
            wrapped.add(cmp, "Center");
            this.myMainPanel.add((Component)wrapped, "Center");
            if (cmp instanceof Accessible) {
                this.myMainPanel.setAccessible((Accessible)((Object)cmp));
            }
            return this.myMainPanel;
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index, boolean selected2, boolean hasFocus) {
        }
    }
}

