/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TabNavigationActionBase
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(TabNavigationActionBase.class);
    private final NavigationType myNavigationType;

    TabNavigationActionBase(@NotNull NavigationType navigationType) {
        this.myNavigationType = navigationType;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null || project.isDisposed()) {
            return;
        }
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project);
        if (windowManager.isEditorComponentActive()) {
            this.doNavigate(dataContext, project);
            return;
        }
        this.doNavigate((ContentManager)PlatformDataKeys.NONEMPTY_CONTENT_MANAGER.getData(dataContext));
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        presentation2.setEnabled(false);
        if (project == null || project.isDisposed()) {
            return;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        if (toolWindowManager != null && toolWindowManager.isEditorComponentActive()) {
            FileEditorManagerEx editorManager = FileEditorManagerEx.getInstanceEx(project);
            EditorWindow currentWindow = (EditorWindow)EditorWindow.DATA_KEY.getData(dataContext);
            if (currentWindow == null) {
                editorManager.getCurrentWindow();
            }
            if (currentWindow != null) {
                Object[] editors = currentWindow.getEditors();
                switch (this.myNavigationType) {
                    case PREV: 
                    case NEXT: {
                        presentation2.setEnabled(editors.length > 1);
                        break;
                    }
                    case LAST: {
                        int index = ArrayUtil.indexOf((Object[])editors, (Object)currentWindow.getSelectedEditor());
                        presentation2.setEnabled(index < editors.length);
                        break;
                    }
                    default: {
                        int targetIndex = this.myNavigationType.ordinal();
                        presentation2.setEnabled(targetIndex < editors.length);
                    }
                }
            }
            return;
        }
        ContentManager contentManager2 = (ContentManager)PlatformDataKeys.NONEMPTY_CONTENT_MANAGER.getData(dataContext);
        presentation2.setEnabled(contentManager2 != null && contentManager2.getContentCount() > 1 && contentManager2.isSingleSelection());
    }

    private void doNavigate(@Nullable ContentManager contentManager2) {
        if (contentManager2 == null) {
            return;
        }
        Content targetContent = null;
        switch (this.myNavigationType) {
            case PREV: {
                contentManager2.selectPreviousContent();
                return;
            }
            case NEXT: {
                contentManager2.selectNextContent();
                return;
            }
            case LAST: {
                targetContent = contentManager2.getContent(contentManager2.getContentCount() - 1);
                break;
            }
            default: {
                int targetIndex = this.myNavigationType.ordinal();
                if (contentManager2.getContentCount() < targetIndex + 1) break;
                targetContent = contentManager2.getContent(targetIndex);
            }
        }
        if (targetContent != null) {
            contentManager2.setSelectedContent(targetContent, true);
        }
    }

    private void doNavigate(DataContext dataContext, Project project) {
        int targetIndex;
        Object[] files2;
        int index;
        VirtualFile selectedFile;
        FileEditorManagerEx editorManager = FileEditorManagerEx.getInstanceEx(project);
        EditorWindow currentWindow = (EditorWindow)EditorWindow.DATA_KEY.getData(dataContext);
        if (currentWindow == null) {
            currentWindow = editorManager.getCurrentWindow();
        }
        if ((selectedFile = currentWindow.getSelectedFile()) == null) {
            selectedFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        }
        LOG.assertTrue((index = ArrayUtil.find((Object[])(files2 = currentWindow.getFiles()), (Object)selectedFile)) != -1);
        switch (this.myNavigationType) {
            case PREV: {
                targetIndex = (index + files2.length - 1) % files2.length;
                break;
            }
            case NEXT: {
                targetIndex = (index + files2.length + 1) % files2.length;
                break;
            }
            case LAST: {
                targetIndex = files2.length - 1;
                break;
            }
            default: {
                targetIndex = this.myNavigationType.ordinal();
            }
        }
        if (targetIndex < files2.length) {
            editorManager.openFile((VirtualFile)files2[targetIndex], true);
        }
    }

    public static class GoToLastTabAction
    extends GoToTabAction {
        public GoToLastTabAction() {
            super(NavigationType.LAST);
        }
    }

    public static class GoToTab9Action
    extends GoToTabAction {
        private GoToTab9Action() {
            super(NavigationType.NUM9);
        }
    }

    public static class GoToTab8Action
    extends GoToTabAction {
        private GoToTab8Action() {
            super(NavigationType.NUM8);
        }
    }

    public static class GoToTab7Action
    extends GoToTabAction {
        private GoToTab7Action() {
            super(NavigationType.NUM7);
        }
    }

    public static class GoToTab6Action
    extends GoToTabAction {
        private GoToTab6Action() {
            super(NavigationType.NUM6);
        }
    }

    public static class GoToTab5Action
    extends GoToTabAction {
        private GoToTab5Action() {
            super(NavigationType.NUM5);
        }
    }

    public static class GoToTab4Action
    extends GoToTabAction {
        private GoToTab4Action() {
            super(NavigationType.NUM4);
        }
    }

    public static class GoToTab3Action
    extends GoToTabAction {
        private GoToTab3Action() {
            super(NavigationType.NUM3);
        }
    }

    public static class GoToTab2Action
    extends GoToTabAction {
        private GoToTab2Action() {
            super(NavigationType.NUM2);
        }
    }

    public static class GoToTab1Action
    extends GoToTabAction {
        private GoToTab1Action() {
            super(NavigationType.NUM1);
        }
    }

    private static abstract class GoToTabAction
    extends TabNavigationActionBase {
        protected GoToTabAction(@NotNull NavigationType navigationType) {
            super(navigationType);
            if (navigationType == NavigationType.LAST) {
                this.getTemplatePresentation().setText(ActionsBundle.messagePointer((String)"action.GoToLastTab.text", (Object[])new Object[0]));
                this.getTemplatePresentation().setDescription(ActionsBundle.messagePointer((String)"action.GoToLastTab.description", (Object[])new Object[0]));
            } else {
                this.getTemplatePresentation().setText(ActionsBundle.messagePointer((String)"action.GoToTab.text", (Object[])new Object[]{navigationType.ordinal() + 1}));
                this.getTemplatePresentation().setDescription(ActionsBundle.messagePointer((String)"action.GoToTab.description", (Object[])new Object[]{navigationType.ordinal() + 1}));
            }
        }

        @Override
        public void update(@NotNull AnActionEvent event) {
            super.update(event);
        }
    }

    static enum NavigationType {
        NUM1,
        NUM2,
        NUM3,
        NUM4,
        NUM5,
        NUM6,
        NUM7,
        NUM8,
        NUM9,
        PREV,
        NEXT,
        LAST;

    }
}

