/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.lang.Language;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RelatedItemLineMarkerGotoAdapter
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context) {
        ArrayList<PsiElement> parents2 = new ArrayList<PsiElement>();
        HashSet<Language> languages = new HashSet<Language>();
        for (PsiElement current2 = context; current2 != null; current2 = current2.getParent()) {
            parents2.add(current2);
            languages.add(current2.getLanguage());
            if (current2 instanceof PsiFile) break;
        }
        ArrayList<LineMarkerProvider> providers = new ArrayList<LineMarkerProvider>();
        for (Language language : languages) {
            providers.addAll(LineMarkersPass.getMarkerProviders(language, context.getProject()));
        }
        ArrayList items = new ArrayList();
        for (LineMarkerProvider provider : providers) {
            if (!(provider instanceof RelatedItemLineMarkerProvider)) continue;
            ArrayList markers = new ArrayList();
            RelatedItemLineMarkerProvider relatedItemLineMarkerProvider = (RelatedItemLineMarkerProvider)provider;
            for (PsiElement parent : parents2) {
                ContainerUtil.addIfNotNull(markers, (Object)relatedItemLineMarkerProvider.getLineMarkerInfo(parent));
            }
            relatedItemLineMarkerProvider.collectNavigationMarkers(parents2, markers, true);
            RelatedItemLineMarkerGotoAdapter.addItemsForMarkers(markers, items);
        }
        return items;
    }

    private static void addItemsForMarkers(List<? extends RelatedItemLineMarkerInfo> markers, List<? super GotoRelatedItem> result2) {
        HashSet addedFiles = new HashSet();
        for (RelatedItemLineMarkerInfo relatedItemLineMarkerInfo : markers) {
            Collection items = relatedItemLineMarkerInfo.createGotoRelatedItems();
            for (GotoRelatedItem item : items) {
                PsiFile file2;
                PsiElement element2 = item.getElement();
                if (element2 instanceof PsiFile && addedFiles.contains(file2 = (PsiFile)element2)) continue;
                if (element2 != null) {
                    ContainerUtil.addIfNotNull(addedFiles, (Object)element2.getContainingFile());
                }
                result2.add((GotoRelatedItem)item);
            }
        }
    }
}

