/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.lang.LangBundle;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoRelatedSymbolAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        PsiElement element2 = GotoRelatedSymbolAction.getContextElement(e.getDataContext());
        e.getPresentation().setEnabled(element2 != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        PsiElement element2 = GotoRelatedSymbolAction.getContextElement(dataContext);
        if (element2 == null) {
            return;
        }
        RelativePoint popupLocation = JBPopupFactory.getInstance().guessBestPopupLocation(dataContext);
        List<GotoRelatedItem> items = NavigationUtil.collectRelatedItems(element2, dataContext);
        if (items.isEmpty()) {
            JComponent label2 = HintUtil.createErrorLabel(LangBundle.message((String)"hint.text.no.related.symbols", (Object[])new Object[0]));
            label2.setBorder((Border)JBUI.Borders.empty((int)2, (int)7));
            JBPopupFactory.getInstance().createBalloonBuilder(label2).setFadeoutTime(3000L).setFillColor(HintUtil.getErrorColor()).createBalloon().show(popupLocation, Balloon.Position.above);
            return;
        }
        if (items.size() == 1 && items.get(0).getElement() != null) {
            items.get(0).navigate();
            return;
        }
        NavigationUtil.getRelatedItemsPopup(items, "Choose Target").show(popupLocation);
    }

    @NotNull
    public static List<GotoRelatedItem> getItems(@NotNull PsiFile psiFile, @Nullable Editor editor, @Nullable DataContext dataContext) {
        return NavigationUtil.collectRelatedItems(GotoRelatedSymbolAction.getContextElement(psiFile, editor), dataContext);
    }

    @Nullable
    private static PsiElement getContextElement(@NotNull DataContext dataContext) {
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (file2 != null && editor != null) {
            return GotoRelatedSymbolAction.getContextElement(file2, editor);
        }
        return element2 == null ? file2 : element2;
    }

    @NotNull
    private static PsiElement getContextElement(@NotNull PsiFile psiFile, @Nullable Editor editor) {
        PsiElement element2;
        PsiFile contextElement = psiFile;
        if (editor != null && (element2 = psiFile.findElementAt(editor.getCaretModel().getOffset())) != null) {
            contextElement = element2;
        }
        return contextElement;
    }
}

