/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FileStatusManager;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public abstract class CloseEditorsActionBase
extends AnAction
implements DumbAware {
    protected ArrayList<Pair<EditorComposite, EditorWindow>> getFilesToClose(AnActionEvent event) {
        ArrayList<Pair<EditorComposite, EditorWindow>> res2 = new ArrayList<Pair<EditorComposite, EditorWindow>>();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        FileEditorManagerEx editorManager = FileEditorManagerEx.getInstanceEx(project);
        EditorWindow editorWindow = (EditorWindow)EditorWindow.DATA_KEY.getData(dataContext);
        EditorWindow[] windows = editorWindow != null ? new EditorWindow[]{editorWindow} : editorManager.getWindows();
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project);
        if (fileStatusManager != null) {
            for (int i2 = 0; i2 != windows.length; ++i2) {
                EditorWithProviderComposite[] editors;
                EditorWindow window = windows[i2];
                for (EditorWithProviderComposite editor : editors = window.getEditors()) {
                    if (!this.isFileToClose(editor, window) && !this.isFileToCloseInContext(event.getDataContext(), editor, window)) continue;
                    res2.add((Pair<EditorComposite, EditorWindow>)Pair.create((Object)editor, (Object)window));
                }
            }
        }
        return res2;
    }

    protected abstract boolean isFileToClose(EditorComposite var1, EditorWindow var2);

    protected boolean isFileToCloseInContext(DataContext dataContext, EditorComposite editor, EditorWindow window) {
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project, () -> {
            ArrayList<Pair<EditorComposite, EditorWindow>> filesToClose = this.getFilesToClose(e);
            for (int i2 = 0; i2 != filesToClose.size(); ++i2) {
                Pair<EditorComposite, EditorWindow> we = filesToClose.get(i2);
                ((EditorWindow)we.getSecond()).closeFile(((EditorComposite)we.getFirst()).getFile());
            }
        }, IdeBundle.message((String)"command.close.all.unmodified.editors", (Object[])new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent event) {
        boolean enabled;
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        EditorWindow editorWindow = (EditorWindow)EditorWindow.DATA_KEY.getData(dataContext);
        boolean inSplitter = editorWindow != null && editorWindow.inSplitter();
        presentation2.setText(this.getPresentationText(inSplitter));
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        boolean bl = enabled = project != null && this.isActionEnabled(project, event);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            presentation2.setVisible(enabled);
        } else {
            presentation2.setEnabled(enabled);
        }
    }

    protected boolean isActionEnabled(Project project, AnActionEvent event) {
        return this.getFilesToClose(event).size() > 0;
    }

    protected abstract String getPresentationText(boolean var1);
}

