/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.AboutPopupDescriptionProvider;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBPoint;
import com.intellij.util.ui.JBRectangle;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryManagerMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AboutPopup {
    private static JBPopup ourPopup;
    private static final Logger LOG;
    private static final String THIRD_PARTY_LIBRARIES_FILE_PATH = "license/third-party-libraries.html";

    public static void show(@Nullable Window window, boolean showDebugInfo) {
        RelativePoint location;
        ApplicationInfoEx appInfo = (ApplicationInfoEx)ApplicationInfo.getInstance();
        PopupPanel panel2 = new PopupPanel(new BorderLayout());
        Icon image = IconLoader.getIcon((String)appInfo.getAboutImageUrl());
        if (appInfo.showLicenseeInfo()) {
            InfoSurface infoSurface = new InfoSurface(image, showDebugInfo);
            infoSurface.setPreferredSize(new Dimension(image.getIconWidth(), image.getIconHeight()));
            panel2.setInfoSurface(infoSurface);
        } else {
            panel2.add((Component)new JLabel(image), "North");
        }
        if (window != null) {
            Rectangle r = window.getBounds();
            location = new RelativePoint((Component)window, new Point((r.width - image.getIconWidth()) / 2, (r.height - image.getIconHeight()) / 2));
        } else {
            Rectangle r = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
            location = new RelativePoint(new Point((r.width - image.getIconWidth()) / 2, (r.height - image.getIconHeight()) / 2));
        }
        ourPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)panel2).setRequestFocus(true).setFocusable(true).setResizable(false).setMovable(false).setModalContext(false).setShowShadow(true).setShowBorder(false).setCancelKeyEnabled(true).setCancelOnClickOutside(true).setCancelOnOtherWindowOpen(true).createPopup();
        Disposer.register((Disposable)ourPopup, (Disposable)new Disposable(){

            public void dispose() {
                ourPopup = null;
            }
        });
        ourPopup.show(location);
    }

    private static void copyInfoToClipboard(String text) {
        try {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Color createColor(long rgba) {
        return rgba == -1L ? Color.BLACK : new Color((int)rgba, rgba > 0xFFFFFFL);
    }

    @NotNull
    private static String getExtraInfo() {
        String nonBundledPlugins;
        String extraInfo = SystemInfo.getOsNameAndVersion() + "\n";
        extraInfo = extraInfo + "GC: " + (String)ManagementFactory.getGarbageCollectorMXBeans().stream().map(MemoryManagerMXBean::getName).collect(StringUtil.joining()) + "\n";
        extraInfo = extraInfo + "Memory: " + Runtime.getRuntime().maxMemory() / 0x100000L + "M\n";
        extraInfo = extraInfo + "Cores: " + Runtime.getRuntime().availableProcessors() + "\n";
        String registryKeys = (String)Registry.getAll().stream().filter(RegistryValue::isChangedFromDefault).map(v -> v.getKey() + "=" + v.asString()).collect(StringUtil.joining());
        if (!StringUtil.isEmpty((String)registryKeys)) {
            extraInfo = extraInfo + "Registry: " + registryKeys + "\n";
        }
        if (!StringUtil.isEmpty((String)(nonBundledPlugins = (String)Arrays.stream(PluginManagerCore.getPlugins()).filter(p -> !p.isBundled() && p.isEnabled()).map(p -> p.getPluginId().getIdString()).collect(StringUtil.joining())))) {
            extraInfo = extraInfo + "Non-Bundled Plugins: " + nonBundledPlugins;
        }
        if (SystemInfo.isUnix && !SystemInfo.isMac) {
            extraInfo = extraInfo + "\nCurrent Desktop: " + (String)ObjectUtils.notNull((Object)System.getenv("XDG_CURRENT_DESKTOP"), (Object)"Undefined");
        }
        return extraInfo;
    }

    public static void showOpenSoftwareSources(final @NotNull String htmlText) {
        DialogWrapper dialog2 = new DialogWrapper(true){
            {
                super(x0);
                this.init();
                this.setAutoAdjustable(false);
                this.setOKButtonText(CommonBundle.message((String)"close.action.name", (Object[])new Object[0]));
            }

            protected JComponent createCenterPanel() {
                JPanel centerPanel = new JPanel(new BorderLayout(JBUIScale.scale((int)5), JBUIScale.scale((int)5)));
                JEditorPane viewer = SwingHelper.createHtmlViewer(true, null, (Color)JBColor.WHITE, (Color)JBColor.BLACK);
                viewer.setFocusable(true);
                viewer.addHyperlinkListener((HyperlinkListener)new BrowserHyperlinkListener());
                String resultHtmlText = this.getScaledHtmlText();
                if (StartupUiUtil.isUnderDarcula()) {
                    resultHtmlText = resultHtmlText.replaceAll("779dbd", "5676a0");
                }
                viewer.setText(resultHtmlText);
                StyleSheet styleSheet = ((HTMLDocument)viewer.getDocument()).getStyleSheet();
                styleSheet.addRule("body {font-family: \"Segoe UI\", Tahoma, sans-serif;}");
                styleSheet.addRule("body {margin-top:0;padding-top:0;}");
                styleSheet.addRule("body {font-size:" + JBUIScale.scaleFontSize((float)14.0f) + "pt;}");
                viewer.setCaretPosition(0);
                viewer.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)5, (int)5));
                JBScrollPane scrollPane = new JBScrollPane((Component)viewer, 20, 31);
                centerPanel.add((Component)scrollPane, "Center");
                return centerPanel;
            }

            protected Action @NotNull [] createActions() {
                return new Action[]{this.getOKAction()};
            }

            @NotNull
            private String getScaledHtmlText() {
                Pattern pattern = Pattern.compile("(\\d+)px");
                Matcher matcher = pattern.matcher(htmlText);
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    matcher.appendReplacement(sb, JBUIScale.scale((int)Integer.parseInt(matcher.group(1))) + "px");
                }
                matcher.appendTail(sb);
                return sb.toString();
            }
        };
        ourPopup.cancel();
        dialog2.setTitle(String.format("Third-Party Software Used by %s %s", ApplicationNamesInfo.getInstance().getFullProductName(), ApplicationInfo.getInstance().getFullVersion()));
        dialog2.setSize(JBUIScale.scale((int)750), JBUIScale.scale((int)650));
        dialog2.show();
    }

    static {
        LOG = Logger.getInstance(AboutPopup.class);
    }

    public static class PopupPanel
    extends JPanel {
        private InfoSurface myInfoSurface;

        public PopupPanel(LayoutManager layout) {
            super(layout);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessiblePopupPanel();
            }
            return this.accessibleContext;
        }

        public void setInfoSurface(InfoSurface infoSurface) {
            this.myInfoSurface = infoSurface;
            this.add((Component)infoSurface, "North");
            DumbAwareAction.create(e -> AboutPopup.copyInfoToClipboard(this.myInfoSurface.getText())).registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"meta C", "control C"}), (JComponent)this);
        }

        protected class AccessiblePopupPanel
        extends JPanel.AccessibleJPanel
        implements AccessibleAction {
            protected AccessiblePopupPanel() {
                super(PopupPanel.this);
            }

            @Override
            public String getAccessibleName() {
                ApplicationInfoEx appInfo = (ApplicationInfoEx)ApplicationInfo.getInstance();
                return "About " + appInfo.getFullApplicationName();
            }

            @Override
            public String getAccessibleDescription() {
                if (PopupPanel.this.myInfoSurface != null) {
                    return "Press Copy key to copy system information to clipboard";
                }
                return null;
            }

            @Override
            public AccessibleAction getAccessibleAction() {
                return this;
            }

            @Override
            public int getAccessibleActionCount() {
                if (PopupPanel.this.myInfoSurface != null) {
                    return 1;
                }
                return 0;
            }

            @Override
            public String getAccessibleActionDescription(int i2) {
                if (i2 == 0 && PopupPanel.this.myInfoSurface != null) {
                    return "Copy system information to clipboard";
                }
                return null;
            }

            @Override
            public boolean doAccessibleAction(int i2) {
                if (i2 == 0 && PopupPanel.this.myInfoSurface != null) {
                    AboutPopup.copyInfoToClipboard(PopupPanel.this.myInfoSurface.getText());
                    return true;
                }
                return false;
            }
        }
    }

    private static final class InfoSurface
    extends JPanel {
        private static final ExtensionPointName<AboutPopupDescriptionProvider> EP_NAME = new ExtensionPointName("com.intellij.aboutPopupDescriptionProvider");
        private final Color myColor;
        private final Color myLinkColor;
        private final Icon myImage;
        private final boolean myShowDebugInfo;
        private Font myFont;
        private Font myBoldFont;
        private final List<AboutBoxLine> myLines = new ArrayList<AboutBoxLine>();
        private final StringBuilder myInfo = new StringBuilder();
        private final List<Link> myLinks = new ArrayList<Link>();
        private Link myActiveLink;
        private boolean myShowCopy = false;
        private float myShowCopyAlpha;
        private final Alarm myAlarm = new Alarm();

        InfoSurface(Icon image, boolean showDebugInfo) {
            ApplicationInfoImpl appInfo = (ApplicationInfoImpl)ApplicationInfoEx.getInstanceEx();
            this.myImage = image;
            this.myColor = Color.white;
            long aboutLinkColor = appInfo.getAboutLinkColor();
            this.myLinkColor = aboutLinkColor == -1L ? JBUI.CurrentTheme.Link.linkColor() : new Color((int)aboutLinkColor, aboutLinkColor > 0xFFFFFFL);
            this.myShowDebugInfo = showDebugInfo;
            this.setOpaque(false);
            this.setBackground(this.myColor);
            this.setFocusable(true);
            String appName = appInfo.getFullApplicationName();
            String edition = ApplicationNamesInfo.getInstance().getEditionName();
            if (edition != null) {
                appName = appName + " (" + edition + ")";
            }
            this.myLines.add(new AboutBoxLine(appName, true));
            this.appendLast();
            String buildInfo = IdeBundle.message((String)"about.box.build.number", (Object[])new Object[]{appInfo.getBuild().asString()});
            Calendar cal = appInfo.getBuildDate();
            String buildDate = "";
            if (appInfo.getBuild().isSnapshot()) {
                buildDate = new SimpleDateFormat("HH:mm, ").format(cal.getTime());
            }
            buildDate = buildDate + DateFormatUtil.formatAboutDialogDate((Date)cal.getTime());
            buildInfo = buildInfo + IdeBundle.message((String)"about.box.build.date", (Object[])new Object[]{buildDate});
            this.myLines.add(new AboutBoxLine(buildInfo));
            this.appendLast();
            this.myLines.add(new AboutBoxLine(""));
            LicensingFacade la = LicensingFacade.getInstance();
            if (la != null) {
                String licensedTo = la.getLicensedToMessage();
                if (licensedTo != null) {
                    this.myLines.add(new AboutBoxLine(licensedTo, true));
                    this.appendLast();
                }
                for (String message : la.getLicenseRestrictionsMessages()) {
                    this.myLines.add(new AboutBoxLine(message));
                    this.appendLast();
                }
            }
            this.myLines.add(new AboutBoxLine(""));
            Properties properties = System.getProperties();
            String javaVersion = properties.getProperty("java.runtime.version", properties.getProperty("java.version", "unknown"));
            String arch = properties.getProperty("os.arch", "");
            this.myLines.add(new AboutBoxLine(IdeBundle.message((String)"about.box.jre", (Object[])new Object[]{javaVersion, arch})));
            this.appendLast();
            String vmVersion = properties.getProperty("java.vm.name", "unknown");
            String vmVendor = properties.getProperty("java.vendor", "unknown");
            this.myLines.add(new AboutBoxLine(IdeBundle.message((String)"about.box.vm", (Object[])new Object[]{vmVersion, vmVendor})));
            this.appendLast();
            for (AboutPopupDescriptionProvider aboutInfoProvider : (AboutPopupDescriptionProvider[])EP_NAME.getExtensions()) {
                String[] lines;
                String description = aboutInfoProvider.getDescription();
                if (description == null || (lines = description.split("[\n]+")).length == 0) continue;
                this.myLines.add(new AboutBoxLine(""));
                for (String line : lines) {
                    this.myLines.add(new AboutBoxLine(line));
                    this.appendLast();
                }
            }
            this.myLines.add(new AboutBoxLine(""));
            this.myLines.add(new AboutBoxLine(""));
            this.myLines.add(new AboutBoxLine(IdeBundle.message((String)"about.box.powered.by", (Object[])new Object[0]) + " ").keepWithNext());
            String thirdPartyLibraries = InfoSurface.loadThirdPartyLibraries();
            if (thirdPartyLibraries != null) {
                this.myLines.add(new AboutBoxLine(IdeBundle.message((String)"about.box.open.source.software", (Object[])new Object[0]), () -> AboutPopup.showOpenSoftwareSources(thirdPartyLibraries)));
            } else {
                this.myLines.add(new AboutBoxLine(IdeBundle.message((String)"about.box.open.source.software", (Object[])new Object[0])));
            }
            this.addMouseListener(new MouseAdapter(){
                static final double maxAlpha = 1.0;
                static final double fadeStep = 0.05;
                static final int animationDelay = 15;

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (myActiveLink != null) {
                        event.consume();
                        myActiveLink.actionPerformed(new ActionEvent(event.getSource(), event.getID(), event.paramString()));
                    }
                    if (this.getCopyIconArea().contains(event.getPoint())) {
                        AboutPopup.copyInfoToClipboard(this.getText());
                        if (ourPopup != null) {
                            ourPopup.cancel();
                        }
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!myShowCopy) {
                        myShowCopy = true;
                        myAlarm.cancelAllRequests();
                        myAlarm.addRequest(new Runnable(){

                            @Override
                            public void run() {
                                if ((double)myShowCopyAlpha < 1.0) {
                                    myShowCopyAlpha = (float)Math.min((double)myShowCopyAlpha + 0.05, 1.0);
                                    this.repaint();
                                    myAlarm.addRequest((Runnable)this, 15);
                                }
                            }
                        }, 15);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (myShowCopy) {
                        myShowCopy = false;
                        myAlarm.cancelAllRequests();
                        myAlarm.addRequest(new Runnable(){

                            @Override
                            public void run() {
                                if ((double)myShowCopyAlpha >= 0.05) {
                                    myShowCopyAlpha = (float)((double)myShowCopyAlpha - 0.05);
                                    this.repaint();
                                    myAlarm.addRequest((Runnable)this, 15);
                                }
                            }
                        }, 15);
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent event) {
                    boolean hadLink = myActiveLink != null || this.getCursor() == Cursor.getPredefinedCursor(12);
                    myActiveLink = null;
                    Point point = event.getPoint();
                    for (Link link : myLinks) {
                        if (!link.myRectangle.contains(point)) continue;
                        myActiveLink = link;
                        if (!hadLink) {
                            this.setCursor(Cursor.getPredefinedCursor(12));
                        }
                        return;
                    }
                    if (this.getCopyIconArea().contains(point)) {
                        this.setCursor(Cursor.getPredefinedCursor(12));
                        return;
                    }
                    if (hadLink && myActiveLink == null) {
                        this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
        }

        @Nullable
        private static String loadThirdPartyLibraries() {
            File thirdPartyLibrariesFile = new File(PathManager.getHomePath(), AboutPopup.THIRD_PARTY_LIBRARIES_FILE_PATH);
            if (thirdPartyLibrariesFile.isFile()) {
                try {
                    return FileUtil.loadFile((File)thirdPartyLibrariesFile);
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
            return null;
        }

        private Rectangle getCopyIconArea() {
            return new Rectangle((Point)this.getCopyIconCoord(), (Dimension)JBUI.size((int)16));
        }

        private void appendLast() {
            this.myInfo.append(this.myLines.get(this.myLines.size() - 1).getText()).append("\n");
        }

        @Override
        public void paint(Graphics g) {
            ApplicationInfo appInfo;
            int[] aboutLogoRect;
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            GraphicsConfig config2 = new GraphicsConfig(g);
            UISettings.setupAntialiasing((Graphics)g);
            JBFont labelFont = JBFont.label();
            if (SystemInfo.isWindows) {
                labelFont = JBUI.Fonts.create((String)(SystemInfo.isWinVistaOrNewer ? "Segoe UI" : "Tahoma"), (int)14);
            }
            int startFontSize = 14;
            for (int labelSize = JBUIScale.scale((int)startFontSize); labelSize != JBUIScale.scale((int)6); --labelSize) {
                this.myLinks.clear();
                g2.setPaint(this.myColor);
                this.myImage.paintIcon(this, g2, 0, 0);
                g2.setColor(this.myColor);
                TextRenderer renderer = this.createTextRenderer(g2);
                UIUtil.setupComposite((Graphics2D)g2);
                this.myFont = labelFont.deriveFont(0, labelSize);
                this.myBoldFont = labelFont.deriveFont(1, labelSize + 1);
                try {
                    renderer.render(0, 0, this.myLines);
                    break;
                }
                catch (TextRenderer.OverflowException overflowException) {
                    continue;
                }
            }
            if ((aboutLogoRect = (appInfo = ApplicationInfo.getInstance()).getAboutLogoRect()) != null) {
                this.myLinks.add(new Link((Rectangle)new JBRectangle(aboutLogoRect[0], aboutLogoRect[1], aboutLogoRect[2], aboutLogoRect[3]), appInfo.getCompanyURL()));
            }
            if (appInfo instanceof ApplicationInfoEx) {
                long copyrightForeground = ((ApplicationInfoEx)appInfo).getCopyrightForeground();
                Object color = copyrightForeground < 0L ? JBColor.BLACK : new Color((int)copyrightForeground, copyrightForeground > 0xFFFFFFL);
                g2.setColor((Color)color);
                if (SystemInfo.isMac) {
                    g2.setFont((Font)JBUI.Fonts.miniFont());
                } else {
                    g2.setFont((Font)JBUI.Fonts.create((String)(SystemInfo.isWinVistaOrNewer ? "Segoe UI" : "Tahoma"), (int)12));
                }
                g2.setColor(AboutPopup.createColor(((ApplicationInfoEx)appInfo).getAboutForeground()));
            } else {
                g2.setColor((Color)JBColor.BLACK);
            }
            JBPoint copyrightCoord = this.getCopyrightCoord();
            g2.drawString(this.getCopyrightText(), copyrightCoord.x, copyrightCoord.y);
            if (this.myShowDebugInfo) {
                g2.setColor(AboutPopup.createColor(((ApplicationInfoEx)appInfo).getAboutForeground()));
                for (Link link : this.myLinks) {
                    g2.drawRect(((Link)link).myRectangle.x, ((Link)link).myRectangle.y, ((Link)link).myRectangle.width, ((Link)link).myRectangle.height);
                }
            }
            config2.restore();
            if (this.myShowCopy) {
                JBPoint coord = this.getCopyIconCoord();
                float alpha = this.myShowCopyAlpha;
                config2 = new GraphicsConfig(g).paintWithAlpha(MathUtil.clamp((float)alpha, (float)0.0f, (float)1.0f));
                AllIcons.General.CopyHovered.paintIcon(this, g, coord.x, coord.y);
                config2.restore();
            }
        }

        @NotNull
        protected String getCopyrightText() {
            return " ";
        }

        @NotNull
        private TextRenderer createTextRenderer(Graphics2D g) {
            JBRectangle r = this.getTextRendererRect();
            return new TextRenderer(r.x, r.y, r.width, r.height, g);
        }

        protected JBRectangle getTextRendererRect() {
            return new JBRectangle(115, 156, 500, 220);
        }

        protected JBPoint getCopyrightCoord() {
            return new JBPoint(115, 395);
        }

        protected JBPoint getCopyIconCoord() {
            return new JBPoint(66, 156);
        }

        public String getText() {
            return this.myInfo + AboutPopup.getExtraInfo();
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleInfoSurface();
            }
            return this.accessibleContext;
        }

        protected class AccessibleInfoSurface
        extends JPanel.AccessibleJPanel {
            protected AccessibleInfoSurface() {
                super(InfoSurface.this);
            }

            @Override
            public String getAccessibleName() {
                String text = "System Information\n" + InfoSurface.this.getText() + "\n" + InfoSurface.this.getCopyrightText();
                return AccessibleContextUtil.replaceLineSeparatorsWithPunctuation((String)text);
            }
        }

        private static class Link
        implements ActionListener {
            private final Rectangle myRectangle;
            private final ActionListener myAction;

            private Link(Rectangle rectangle, ActionListener action2) {
                this.myRectangle = rectangle;
                this.myAction = action2;
            }

            private Link(Rectangle rectangle, String url) {
                this.myRectangle = rectangle;
                this.myAction = e -> BrowserUtil.browse((String)url);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.myAction.actionPerformed(e);
            }
        }

        private static class AboutBoxLine
        implements ActionListener {
            private final String myText;
            private final boolean myBold;
            private boolean myKeepWithNext;
            private final Runnable myRunnable;

            AboutBoxLine(String text, boolean bold) {
                this.myText = text;
                this.myBold = bold;
                this.myRunnable = null;
            }

            AboutBoxLine(String text) {
                this(text, false);
            }

            AboutBoxLine(String text, @NotNull Runnable runnable2) {
                this.myText = text;
                this.myBold = false;
                this.myRunnable = runnable2;
            }

            public String getText() {
                return this.myText;
            }

            public boolean isBold() {
                return this.myBold;
            }

            public boolean isRunnable() {
                return this.myRunnable != null;
            }

            public boolean isKeepWithNext() {
                return this.myKeepWithNext;
            }

            public AboutBoxLine keepWithNext() {
                this.myKeepWithNext = true;
                return this;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.myRunnable != null) {
                    this.myRunnable.run();
                }
            }
        }

        private class TextRenderer {
            private final int xBase;
            private final int yBase;
            private final int w;
            private final int h;
            private final Graphics2D g2;
            private int x = 0;
            private int y = 0;
            private FontMetrics fontmetrics;
            private int fontAscent;
            private int fontHeight;
            private Font font;

            TextRenderer(int xBase, int yBase, int w, int h, Graphics2D g2) {
                this.xBase = xBase;
                this.yBase = yBase;
                this.w = w;
                this.h = h;
                this.g2 = g2;
                if (SystemInfo.isWindows) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
            }

            public void render(int indentX, int indentY, List<? extends AboutBoxLine> lines) throws OverflowException {
                this.x = indentX;
                this.y = indentY;
                ApplicationInfoEx appInfo = (ApplicationInfoEx)ApplicationInfo.getInstance();
                for (AboutBoxLine aboutBoxLine : lines) {
                    String s = aboutBoxLine.getText();
                    this.setFont(aboutBoxLine.isBold() ? InfoSurface.this.myBoldFont : InfoSurface.this.myFont);
                    if (aboutBoxLine.isRunnable()) {
                        this.g2.setColor(InfoSurface.this.myLinkColor);
                        FontMetrics metrics = this.g2.getFontMetrics(this.font);
                        Rectangle myRectangle = new Rectangle(this.xBase + this.x, this.yBase + this.y - this.fontAscent, metrics.stringWidth(s + " "), this.fontHeight);
                        InfoSurface.this.myLinks.add(new Link(myRectangle, aboutBoxLine));
                    } else {
                        this.g2.setColor(AboutPopup.createColor(appInfo.getAboutForeground()));
                    }
                    this.renderString(s, indentX);
                    if (aboutBoxLine.isKeepWithNext() || aboutBoxLine.equals(lines.get(lines.size() - 1))) continue;
                    this.lineFeed(indentX, s);
                }
            }

            private void renderString(String s, int indentX) throws OverflowException {
                List words = StringUtil.split((String)s, (String)" ");
                for (String word : words) {
                    int wordWidth = this.fontmetrics.stringWidth(word);
                    if (this.x + wordWidth >= this.w) {
                        this.lineFeed(indentX, word);
                    }
                    this.renderWord(word, indentX);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void renderWord(String s, int indentX) throws OverflowException {
                FontMetrics fm = null;
                Font f = null;
                try {
                    for (int j = 0; j != s.length(); ++j) {
                        int cW;
                        char c = s.charAt(j);
                        if (!this.g2.getFont().canDisplay(c)) {
                            f = this.g2.getFont();
                            fm = this.fontmetrics;
                            this.g2.setFont(new Font("Monospaced", f.getStyle(), f.getSize()));
                            this.fontmetrics = this.g2.getFontMetrics();
                        }
                        if (this.x + (cW = this.fontmetrics.charWidth(c)) >= this.w) {
                            this.lineFeed(indentX, s);
                        }
                        this.g2.drawChars(new char[]{c}, 0, 1, this.xBase + this.x, this.yBase + this.y);
                        this.x += cW;
                    }
                    this.x += this.fontmetrics.charWidth(' ');
                    if (f == null) return;
                }
                catch (Throwable throwable) {
                    if (f == null) throw throwable;
                    this.g2.setFont(f);
                    this.fontmetrics = fm;
                    throw throwable;
                }
                this.g2.setFont(f);
                this.fontmetrics = fm;
            }

            private void lineFeed(int indent, String s) throws OverflowException {
                this.x = indent;
                this.y = s.length() == 0 ? (this.y += this.fontHeight / 3) : (this.y += this.fontHeight);
                if (this.y >= this.h) {
                    throw new OverflowException();
                }
            }

            private void setFont(Font font) {
                this.font = font;
                this.fontmetrics = this.g2.getFontMetrics(font);
                this.g2.setFont(font);
                this.fontAscent = this.fontmetrics.getAscent();
                this.fontHeight = this.fontmetrics.getHeight();
            }

            public class OverflowException
            extends Exception {
            }
        }
    }
}

