/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.internal.statistic.eventLog.EventField;
import com.intellij.internal.statistic.eventLog.EventFields;
import com.intellij.internal.statistic.eventLog.EventId;
import com.intellij.internal.statistic.eventLog.EventId1;
import com.intellij.internal.statistic.eventLog.EventId3;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TipsOfTheDayUsagesCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("ui.tips", 4);
    public static final EventId NEXT_TIP = GROUP.registerEvent("next.tip");
    public static final EventId PREVIOUS_TIP = GROUP.registerEvent("previous.tip");
    public static final EventId1<DialogType> DIALOG_SHOWN = GROUP.registerEvent("dialog.shown", (EventField)EventFields.Enum((String)"type", DialogType.class));
    private static final EventId3<String, String, String> TIP_SHOWN = GROUP.registerEvent("tip.shown", (EventField)EventFields.String((String)"filename").withCustomRule("tip_info"), (EventField)EventFields.String((String)"algorithm").withCustomEnum("tips_order_algorithm"), EventFields.Version);

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void triggerTipShown(@NotNull TipAndTrickBean tip, @NotNull String algorithm, @Nullable String version2) {
        TIP_SHOWN.log((Object)tip.fileName, (Object)algorithm, (Object)version2);
    }

    public static class TipInfoValidationRule
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "tip_info".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            TipAndTrickBean tip;
            PluginInfo info = context.pluginInfo;
            if (info != null) {
                return info.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
            }
            Object filename = context.eventData.get("filename");
            if (filename instanceof String && (tip = TipAndTrickBean.findByFileName((String)filename)) != null) {
                PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)tip.getPluginDescriptor());
                context.setPluginInfo(pluginInfo);
                return pluginInfo.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
            }
            return ValidationResultType.REJECTED;
        }
    }

    public static enum DialogType {
        automatically,
        manually;

    }
}

