/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;

public final class Paths {
    public static final char DELIM = '/';
    private static boolean myIsCaseSensitive;

    public static String getNameOf(String path) {
        int i2 = path.lastIndexOf(47);
        if (i2 == -1 || path.length() == 1) {
            return path;
        }
        return path.substring(i2 + 1);
    }

    public static String getParentOf(String path) {
        int i2 = path.lastIndexOf(47);
        if (i2 == -1) {
            return "";
        }
        if (i2 == 0) {
            i2 = 1;
        }
        return path.substring(0, i2);
    }

    public static String appended(String path, String child2) {
        path = Paths.appendParent(path);
        return path + child2;
    }

    public static String renamed(String path, String newName) {
        return Paths.appended(Paths.getParentOf(path), newName);
    }

    public static String reparented(String path, String newParentPath) {
        return Paths.appended(newParentPath, Paths.getNameOf(path));
    }

    public static String relativeIfUnder(String path, String root) {
        if (!Paths.isParent(root, path)) {
            return null;
        }
        if ((path = path.substring(root.length())).length() == 0) {
            return "";
        }
        if (path.charAt(0) != '/') {
            return null;
        }
        return path.substring(1);
    }

    public static Iterable<String> split(String path) {
        String root = FileUtil.extractRootPath((String)path);
        if (root == null) {
            return StringUtil.tokenize((String)path, (String)String.valueOf('/'));
        }
        Iterable tail = StringUtil.tokenize((String)path.substring(root.length()), (String)String.valueOf('/'));
        return ContainerUtil.concat(Collections.singleton(root), (Iterable)tail);
    }

    public static boolean isParent(String parent, String path) {
        if (Paths.equals(parent, path)) {
            return true;
        }
        parent = Paths.appendParent(parent);
        return myIsCaseSensitive ? path.startsWith(parent) : StringUtil.startsWithIgnoreCase((String)path, (String)parent);
    }

    private static String appendParent(String parent) {
        if (parent.isEmpty()) {
            return parent;
        }
        if (parent.charAt(parent.length() - 1) != '/') {
            parent = parent + '/';
        }
        return parent;
    }

    public static boolean isParentOrChild(String p1, String p2) {
        return Paths.isParent(p1, p2) || Paths.isParent(p2, p1);
    }

    public static boolean equals(String p1, String p2) {
        return myIsCaseSensitive ? p1.equals(p2) : p1.equalsIgnoreCase(p2);
    }

    public static void setCaseSensitive(boolean b) {
        myIsCaseSensitive = b;
    }

    public static boolean isCaseSensitive() {
        return myIsCaseSensitive;
    }

    public static void useSystemCaseSensitivity() {
        myIsCaseSensitive = SystemInfo.isFileSystemCaseSensitive;
    }

    static {
        Paths.useSystemCaseSensitivity();
    }
}

