/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.library.impl;

import com.intellij.framework.FrameworkAvailabilityCondition;
import com.intellij.framework.library.DownloadableLibraryFileDescription;
import com.intellij.framework.library.FrameworkLibraryVersion;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.download.impl.DownloadableFileSetDescriptionImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkLibraryVersionImpl
extends DownloadableFileSetDescriptionImpl<DownloadableLibraryFileDescription>
implements FrameworkLibraryVersion {
    @Nullable
    private final String myLibraryName;
    @NotNull
    private final FrameworkAvailabilityCondition myAvailabilityCondition;
    private final String myLibraryCategory;

    public FrameworkLibraryVersionImpl(@Nullable String libraryName, @NotNull String versionString, @NotNull FrameworkAvailabilityCondition availabilityCondition, @NotNull List<DownloadableLibraryFileDescription> libraryFiles, @NotNull String category) {
        super(category, versionString, libraryFiles);
        this.myLibraryName = libraryName;
        this.myAvailabilityCondition = availabilityCondition;
        this.myLibraryCategory = category;
    }

    @NotNull
    public FrameworkAvailabilityCondition getAvailabilityCondition() {
        return this.myAvailabilityCondition;
    }

    @NotNull
    public String getDefaultLibraryName() {
        String libName = StringUtil.isEmptyOrSpaces((String)this.myLibraryName) ? this.myLibraryCategory : this.myLibraryName;
        return this.myVersionString.length() > 0 ? libName + "-" + this.myVersionString : this.myLibraryCategory;
    }

    @NotNull
    public String getPresentableName() {
        return this.getDefaultLibraryName();
    }

    public String getVersionNumber() {
        return this.getVersionString();
    }
}

