/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.exclude.old;

import com.intellij.framework.detection.impl.exclude.old.DisabledAutodetectionByTypeElement;
import com.intellij.util.containers.SortedList;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisabledAutodetectionInfo {
    private List<DisabledAutodetectionByTypeElement> myElements = new SortedList(DisabledAutodetectionByTypeElement.COMPARATOR);

    @XCollection(propertyElementName="autodetection-disabled")
    public List<DisabledAutodetectionByTypeElement> getElements() {
        return this.myElements;
    }

    public void setElements(List<DisabledAutodetectionByTypeElement> elements2) {
        this.myElements = elements2;
    }

    public boolean isDisabled(@NotNull String facetType, @NotNull String moduleName, String url) {
        DisabledAutodetectionByTypeElement element2 = this.findElement(facetType);
        return element2 != null && element2.isDisabled(moduleName, url);
    }

    public void replaceElement(@NotNull String facetTypeId, @Nullable DisabledAutodetectionByTypeElement element2) {
        DisabledAutodetectionByTypeElement old = this.findElement(facetTypeId);
        if (old != null) {
            this.myElements.remove(old);
        }
        if (element2 != null) {
            this.myElements.add(element2);
        }
    }

    @Nullable
    public DisabledAutodetectionByTypeElement findElement(@NotNull String facetTypeId) {
        for (DisabledAutodetectionByTypeElement element2 : this.myElements) {
            if (!facetTypeId.equals(element2.getFacetTypeId())) continue;
            return element2;
        }
        return null;
    }

    public void addDisabled(@NotNull String facetTypeId) {
        DisabledAutodetectionByTypeElement element2 = this.findElement(facetTypeId);
        if (element2 != null) {
            element2.disableInProject();
        } else {
            this.myElements.add(new DisabledAutodetectionByTypeElement(facetTypeId));
        }
    }

    public void addDisabled(@NotNull String facetTypeId, @NotNull String moduleName) {
        DisabledAutodetectionByTypeElement element2 = this.findElement(facetTypeId);
        if (element2 != null) {
            element2.addDisabled(moduleName);
        } else {
            this.myElements.add(new DisabledAutodetectionByTypeElement(facetTypeId, moduleName));
        }
    }

    public void addDisabled(@NotNull String facetTypeId, @NotNull String moduleName, String url, boolean recursively) {
        DisabledAutodetectionByTypeElement element2 = this.findElement(facetTypeId);
        if (element2 != null) {
            element2.addDisabled(moduleName, url, recursively);
        } else {
            this.myElements.add(new DisabledAutodetectionByTypeElement(facetTypeId, moduleName, url, recursively));
        }
    }

    public void addDisabled(@NotNull String facetTypeId, @NotNull String moduleName, String ... urls) {
        for (String url : urls) {
            this.addDisabled(facetTypeId, moduleName, url, false);
        }
    }
}

