/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.impl.FrameworkDetectorRegistryImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TIntObjectHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class DetectedFrameworksData {
    private static final Logger LOG = Logger.getInstance(DetectedFrameworksData.class);
    private PersistentHashMap<Integer, TIntHashSet> myExistentFrameworkFiles;
    private final TIntObjectHashMap<TIntHashSet> myNewFiles;
    private final MultiMap<Integer, DetectedFrameworkDescription> myDetectedFrameworks;
    private final Object myLock = new Object();

    public DetectedFrameworksData(@NotNull Project project) {
        this.myDetectedFrameworks = new MultiMap();
        Path file2 = ProjectUtil.getProjectCachePath((Project)project, (Path)FrameworkDetectorRegistryImpl.getDetectionDirPath(), (boolean)true).resolve("files");
        this.myNewFiles = new TIntObjectHashMap();
        try {
            this.myExistentFrameworkFiles = new PersistentHashMap(file2, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new TIntHashSetExternalizer());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            PersistentHashMap.deleteFilesStartingWith((File)file2.toFile());
            try {
                this.myExistentFrameworkFiles = new PersistentHashMap(file2, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new TIntHashSetExternalizer());
            }
            catch (IOException e1) {
                LOG.error((Throwable)e1);
            }
        }
    }

    public void saveDetected() {
        try {
            this.myExistentFrameworkFiles.close();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<VirtualFile> retainNewFiles(@NotNull Integer detectorId, @NotNull Collection<? extends VirtualFile> files2) {
        Object object = this.myLock;
        synchronized (object) {
            TIntHashSet oldSet = (TIntHashSet)this.myNewFiles.get(detectorId.intValue());
            if (oldSet == null) {
                oldSet = new TIntHashSet();
                this.myNewFiles.put(detectorId.intValue(), (Object)oldSet);
            }
            TIntHashSet existentFilesSet = null;
            try {
                existentFilesSet = (TIntHashSet)this.myExistentFrameworkFiles.get((Object)detectorId);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            ArrayList<VirtualFile> newFiles = new ArrayList<VirtualFile>();
            TIntHashSet newSet = new TIntHashSet();
            for (VirtualFile virtualFile : files2) {
                int fileId = FileBasedIndex.getFileId((VirtualFile)virtualFile);
                if (existentFilesSet != null && existentFilesSet.contains(fileId)) continue;
                newFiles.add(virtualFile);
                newSet.add(fileId);
            }
            if (newSet.equals((Object)oldSet)) {
                return Collections.emptyList();
            }
            this.myNewFiles.put(detectorId.intValue(), (Object)newSet);
            return newFiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getDetectorsForDetectedFrameworks() {
        Object object = this.myLock;
        synchronized (object) {
            return new HashSet<Integer>(this.myDetectedFrameworks.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends DetectedFrameworkDescription> updateFrameworksList(Integer detectorId, Collection<? extends DetectedFrameworkDescription> frameworks) {
        Object object = this.myLock;
        synchronized (object) {
            Collection oldFrameworks = this.myDetectedFrameworks.remove((Object)detectorId);
            this.myDetectedFrameworks.putValues((Object)detectorId, frameworks);
            if (oldFrameworks != null) {
                frameworks.removeAll(oldFrameworks);
            }
            return frameworks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putExistentFrameworkFiles(Integer id2, Collection<? extends VirtualFile> files2) {
        Object object = this.myLock;
        synchronized (object) {
            TIntHashSet set = null;
            try {
                set = (TIntHashSet)this.myExistentFrameworkFiles.get((Object)id2);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            if (set == null) {
                set = new TIntHashSet();
                try {
                    this.myExistentFrameworkFiles.put((Object)id2, (Object)set);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
            for (VirtualFile virtualFile : files2) {
                set.add(FileBasedIndex.getFileId((VirtualFile)virtualFile));
            }
        }
    }

    private static class TIntHashSetExternalizer
    implements DataExternalizer<TIntHashSet> {
        private TIntHashSetExternalizer() {
        }

        public void save(@NotNull DataOutput out, TIntHashSet value2) throws IOException {
            out.writeInt(value2.size());
            TIntIterator iterator2 = value2.iterator();
            while (iterator2.hasNext()) {
                out.writeInt(iterator2.next());
            }
        }

        public TIntHashSet read(@NotNull DataInput in) throws IOException {
            int size = in.readInt();
            TIntHashSet set = new TIntHashSet(size);
            while (size-- > 0) {
                set.add(in.readInt());
            }
            return set;
        }
    }
}

