/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.diagnostic.PluginException;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.MathUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class RangesAssert {
    private static final Logger LOG = Logger.getInstance(RangesAssert.class);

    RangesAssert() {
    }

    public void assertInvalidRanges(int startOffset, int newEndOffset, FormattingDocumentModel model, String message) {
        Class<?> problematicLanguageClass;
        StringBuilder buffer = new StringBuilder();
        int minOffset = MathUtil.clamp((int)newEndOffset, (int)0, (int)startOffset);
        int maxOffset = MathUtil.clamp((int)newEndOffset, (int)startOffset, (int)model.getTextLength());
        StringBuilder messageBuffer = new StringBuilder();
        messageBuffer.append(message);
        if (model instanceof FormattingDocumentModelImpl) {
            Language language = ((FormattingDocumentModelImpl)model).getFile().getLanguage();
            messageBuffer.append(" in #").append(language.getDisplayName());
            problematicLanguageClass = language.getClass();
        } else {
            problematicLanguageClass = null;
        }
        messageBuffer.append(" #formatter");
        messageBuffer.append("\nRange: [").append(startOffset).append(",").append(newEndOffset).append("], ").append("text fragment: [").append(minOffset).append(",").append(maxOffset).append("]\n");
        buffer.append("Fragment text: '").append(model.getText(new TextRange(minOffset, maxOffset))).append("'\n");
        buffer.append("File text:(").append(model.getTextLength()).append(")\n'");
        buffer.append(model.getText(new TextRange(0, model.getTextLength())).toString());
        buffer.append("'\n");
        buffer.append("model (").append(model.getClass()).append("): ").append(model);
        if (model instanceof FormattingDocumentModelImpl) {
            FormattingDocumentModelImpl modelImpl = (FormattingDocumentModelImpl)model;
            buffer.append("Psi Tree:\n");
            PsiFile file2 = modelImpl.getFile();
            List roots = file2.getViewProvider().getAllFiles();
            for (PsiFile root : roots) {
                buffer.append("Root ");
                DebugUtil.treeToBuffer(buffer, (ASTNode)root.getNode(), 0, false, true, true, true);
            }
            buffer.append('\n');
        }
        PluginException t = problematicLanguageClass != null ? PluginException.createByClass((String)"", null, problematicLanguageClass) : null;
        LOG.error(messageBuffer.toString(), (Throwable)t, new Attachment[]{AttachmentFactory.createContext(buffer, new Object[0])});
    }

    public boolean checkChildRange(@NotNull TextRange parentRange, @NotNull TextRange childRange, @NotNull FormattingDocumentModel model) {
        if (childRange.getStartOffset() < parentRange.getStartOffset()) {
            this.assertInvalidRanges(childRange.getStartOffset(), parentRange.getStartOffset(), model, "child block start is less than parent block start");
            return false;
        }
        if (childRange.getEndOffset() > parentRange.getEndOffset()) {
            this.assertInvalidRanges(childRange.getStartOffset(), parentRange.getStartOffset(), model, "child block end is after parent block end");
            return false;
        }
        return true;
    }
}

