/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.FindUtil;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.impl.FindPopupPanel;
import com.intellij.find.impl.FindUI;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FindUIHelper
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private FindModel myModel;
    FindModel myPreviousModel;
    @NotNull
    private Runnable myOkHandler;
    FindUI myUI;

    FindUIHelper(@NotNull Project project, @NotNull FindModel model, @NotNull Runnable okHandler) {
        this.myProject = project;
        this.myModel = model;
        this.myOkHandler = okHandler;
        this.myUI = this.getOrCreateUI();
        this.myUI.initByModel();
    }

    private FindUI getOrCreateUI() {
        if (this.myUI == null) {
            FindPopupPanel panel2;
            FindPopupPanel component2 = panel2 = new FindPopupPanel(this);
            this.myUI = panel2;
            this.registerAction("ReplaceInPath", true, (JComponent)((Object)component2), this.myUI);
            this.registerAction("FindInPath", false, (JComponent)((Object)component2), this.myUI);
            Disposer.register((Disposable)this.myUI.getDisposable(), (Disposable)this);
        } else {
            IdeEventQueue.getInstance().flushDelayedKeyEvents();
        }
        return this.myUI;
    }

    private void registerAction(String actionName, final boolean replace, JComponent component2, final FindUI ui) {
        final AnAction action2 = ActionManager.getInstance().getAction(actionName);
        new AnAction(){

            public boolean isDumbAware() {
                return action2.isDumbAware();
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                ui.saveSettings();
                FindUIHelper.this.myModel.copyFrom(FindManager.getInstance((Project)FindUIHelper.this.myProject).getFindInProjectModel());
                FindUtil.initStringToFindWithSelection(FindUIHelper.this.myModel, (Editor)e.getData(CommonDataKeys.EDITOR));
                FindUIHelper.this.myModel.setReplaceState(replace);
                ui.initByModel();
            }
        }.registerCustomShortcutSet(action2.getShortcutSet(), component2);
    }

    boolean canSearchThisString() {
        return this.myUI != null && (!StringUtil.isEmpty((String)this.myUI.getStringToFind()) || !this.myModel.isReplaceState() && !this.myModel.isFindAllEnabled() && this.myUI.getFileTypeMask() != null);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public FindModel getModel() {
        return this.myModel;
    }

    public void setModel(@NotNull FindModel model) {
        this.myModel = model;
        this.myUI.initByModel();
    }

    public void setOkHandler(@NotNull Runnable okHandler) {
        this.myOkHandler = okHandler;
    }

    public void showUI() {
        this.myUI = this.getOrCreateUI();
        this.myUI.showUI();
    }

    public void dispose() {
        if (this.myUI != null && !Disposer.isDisposed((Disposable)this.myUI.getDisposable())) {
            Disposer.dispose((Disposable)this.myUI.getDisposable());
        }
        this.myUI = null;
    }

    void updateFindSettings() {
        ((FindManagerImpl)FindManager.getInstance((Project)this.myProject)).changeGlobalSettings(this.myModel);
        FindSettings findSettings = FindSettings.getInstance();
        findSettings.setCaseSensitive(this.myModel.isCaseSensitive());
        if (this.myModel.isReplaceState()) {
            findSettings.setPreserveCase(this.myModel.isPreserveCase());
        }
        findSettings.setWholeWordsOnly(this.myModel.isWholeWordsOnly());
        boolean saveContextBetweenRestarts = false;
        findSettings.setInStringLiteralsOnly(saveContextBetweenRestarts && this.myModel.isInStringLiteralsOnly());
        findSettings.setInCommentsOnly(saveContextBetweenRestarts && this.myModel.isInCommentsOnly());
        findSettings.setExceptComments(saveContextBetweenRestarts && this.myModel.isExceptComments());
        findSettings.setExceptStringLiterals(saveContextBetweenRestarts && this.myModel.isExceptStringLiterals());
        findSettings.setExceptCommentsAndLiterals(saveContextBetweenRestarts && this.myModel.isExceptCommentsAndStringLiterals());
        findSettings.setRegularExpressions(this.myModel.isRegularExpressions());
        if (!this.myModel.isMultipleFiles()) {
            findSettings.setForward(this.myModel.isForward());
            findSettings.setFromCursor(this.myModel.isFromCursor());
            findSettings.setGlobal(this.myModel.isGlobal());
        } else {
            String directoryName = this.myModel.getDirectoryName();
            if (directoryName != null && !directoryName.isEmpty()) {
                findSettings.setWithSubdirectories(this.myModel.isWithSubdirectories());
            } else if (StringUtil.isEmpty((String)this.myModel.getModuleName()) && this.myModel.getCustomScopeName() != null) {
                findSettings.setCustomScope(this.myModel.getCustomScopeName());
            }
        }
        findSettings.setFileMask(this.myModel.getFileFilter());
    }

    String getTitle() {
        if (this.myModel.isReplaceState()) {
            return this.myModel.isMultipleFiles() ? FindBundle.message("find.replace.in.project.dialog.title", new Object[0]) : FindBundle.message("find.replace.text.dialog.title", new Object[0]);
        }
        return this.myModel.isMultipleFiles() ? FindBundle.message("find.in.path.dialog.title", new Object[0]) : FindBundle.message("find.text.dialog.title", new Object[0]);
    }

    public boolean isReplaceState() {
        return this.myModel.isReplaceState();
    }

    @NotNull
    public Runnable getOkHandler() {
        return this.myOkHandler;
    }

    public void doOKAction() {
        this.updateFindSettings();
        this.myOkHandler.run();
    }
}

