/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUsagesOptions
implements Cloneable {
    @NotNull
    public SearchScope searchScope;
    public boolean isSearchForTextOccurrences = true;
    public boolean isUsages;
    public SearchRequestCollector fastTrack;

    public FindUsagesOptions(@NotNull Project project) {
        this(project, null);
    }

    public FindUsagesOptions(@NotNull Project project, @Nullable DataContext dataContext) {
        this(FindUsagesOptions.findScopeByName(project, dataContext, FindSettings.getInstance().getDefaultScopeName()));
    }

    public FindUsagesOptions(@NotNull SearchScope searchScope) {
        this.searchScope = searchScope;
    }

    @ApiStatus.Internal
    @NotNull
    public static SearchScope findScopeByName(@NotNull Project project, @Nullable DataContext dataContext, @Nullable String scopeName) {
        List<SearchScope> predefined = PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(project, dataContext, true, false, false, false, false);
        for (SearchScope scope : predefined) {
            if (!scope.getDisplayName().equals(scopeName)) continue;
            return scope;
        }
        return ProjectScope.getProjectScope((Project)project);
    }

    public FindUsagesOptions clone() {
        try {
            return (FindUsagesOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindUsagesOptions that = (FindUsagesOptions)o;
        if (this.isSearchForTextOccurrences != that.isSearchForTextOccurrences) {
            return false;
        }
        if (this.isUsages != that.isUsages) {
            return false;
        }
        return this.searchScope.equals(that.searchScope);
    }

    public int hashCode() {
        int result2 = this.searchScope.hashCode();
        result2 = 31 * result2 + (this.isSearchForTextOccurrences ? 1 : 0);
        result2 = 31 * result2 + (this.isUsages ? 1 : 0);
        return result2;
    }

    @NonNls
    public String toString() {
        return this.getClass().getSimpleName() + "{searchScope=" + this.searchScope + ", isSearchForTextOccurrences=" + this.isSearchForTextOccurrences + ", isUsages=" + this.isUsages + '}';
    }

    @NotNull
    public String generateUsagesString() {
        return "Usages";
    }
}

