/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.SearchTextArea;
import com.intellij.find.editorHeaderActions.ContextAwareShortcutProvider;
import com.intellij.find.editorHeaderActions.Embeddable;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.ShowMoreOptions;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.find.editorHeaderActions.VariantsCompletionAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.ui.ListFocusTraversalPolicy;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchReplaceComponent
extends EditorHeaderComponent
implements DataProvider {
    private final EventDispatcher<Listener> myEventDispatcher = EventDispatcher.create(Listener.class);
    private final MyTextComponentWrapper mySearchFieldWrapper;
    private JTextComponent mySearchTextComponent;
    private final MyTextComponentWrapper myReplaceFieldWrapper;
    private JTextComponent myReplaceTextComponent;
    private final JPanel myLeftPanel;
    private final JPanel myRightPanel;
    private final DefaultActionGroup mySearchFieldActions;
    private final ActionToolbarImpl mySearchActionsToolbar;
    private final List<AnAction> myEmbeddedSearchActions = new ArrayList<AnAction>();
    private final List<Component> myExtraSearchButtons = new ArrayList<Component>();
    private final BooleanGetter mySearchToolbarModifiedFlagGetter;
    private final DefaultActionGroup myReplaceFieldActions;
    private final ActionToolbarImpl myReplaceActionsToolbar;
    private final List<AnAction> myEmbeddedReplaceActions = new ArrayList<AnAction>();
    private final List<Component> myExtraReplaceButtons = new ArrayList<Component>();
    private final JPanel myReplaceToolbarWrapper;
    private final Project myProject;
    private final JComponent myTargetComponent;
    private final Runnable myCloseAction;
    private final Runnable myReplaceAction;
    private final DataProvider myDataProviderDelegate;
    private boolean myMultilineMode;
    @NotNull
    private String myStatusText = "";
    @NotNull
    private Color myStatusColor = UIUtil.getLabelForeground();
    private DefaultActionGroup myTouchbarActions;

    @NotNull
    public static Builder buildFor(@Nullable Project project, @NotNull JComponent component2) {
        return new Builder(project, component2);
    }

    private SearchReplaceComponent(@Nullable Project project, @NotNull JComponent targetComponent, @NotNull DefaultActionGroup searchToolbar1Actions, @NotNull BooleanGetter searchToolbar1ModifiedFlagGetter, @NotNull DefaultActionGroup searchToolbar2Actions, @NotNull DefaultActionGroup searchFieldActions, @NotNull DefaultActionGroup replaceToolbar1Actions, @NotNull DefaultActionGroup replaceToolbar2Actions, @NotNull DefaultActionGroup replaceFieldActions, @Nullable Runnable replaceAction, @Nullable Runnable closeAction2, @Nullable DataProvider dataProvider) {
        ShortcutSet shortcutSet;
        this.myProject = project;
        this.myTargetComponent = targetComponent;
        this.mySearchToolbarModifiedFlagGetter = searchToolbar1ModifiedFlagGetter;
        this.mySearchFieldActions = searchFieldActions;
        this.myReplaceFieldActions = replaceFieldActions;
        this.myReplaceAction = replaceAction;
        this.myCloseAction = closeAction2;
        for (Object child2 : searchToolbar2Actions.getChildren(null)) {
            if (!(child2 instanceof Embeddable)) continue;
            this.myEmbeddedSearchActions.add((AnAction)child2);
            shortcutSet = ActionUtil.getMnemonicAsShortcut((AnAction)child2);
            if (shortcutSet == null) continue;
            child2.registerCustomShortcutSet(shortcutSet, (JComponent)this);
        }
        for (AnAction action2 : this.myEmbeddedSearchActions) {
            searchToolbar2Actions.remove(action2);
        }
        for (Object child2 : replaceToolbar2Actions.getChildren(null)) {
            if (!(child2 instanceof Embeddable)) continue;
            this.myEmbeddedReplaceActions.add((AnAction)child2);
            shortcutSet = ActionUtil.getMnemonicAsShortcut((AnAction)child2);
            if (shortcutSet == null) continue;
            child2.registerCustomShortcutSet(shortcutSet, (JComponent)this);
        }
        for (AnAction action3 : this.myEmbeddedReplaceActions) {
            replaceToolbar2Actions.remove(action3);
        }
        this.mySearchFieldWrapper = new MyTextComponentWrapper(){

            public void setContent(JComponent wrapped) {
                super.setContent(wrapped);
                SearchReplaceComponent.this.mySearchTextComponent = 1.unwrapTextComponent(wrapped);
            }
        };
        this.myReplaceFieldWrapper = new MyTextComponentWrapper(){

            public void setContent(JComponent wrapped) {
                super.setContent(wrapped);
                SearchReplaceComponent.this.myReplaceTextComponent = 2.unwrapTextComponent(wrapped);
            }
        };
        this.myReplaceFieldWrapper.setBorder((Border)JBUI.Borders.emptyTop((int)1));
        this.myLeftPanel = new JPanel(new GridBagLayout());
        this.myLeftPanel.setBackground(JBColor.border());
        GridBagConstraints constraints2 = new GridBagConstraints();
        constraints2.gridx = 0;
        constraints2.gridy = 0;
        constraints2.fill = 1;
        constraints2.weightx = 1.0;
        constraints2.weighty = 1.0;
        this.myLeftPanel.add((Component)((Object)this.mySearchFieldWrapper), constraints2);
        ++constraints2.gridy;
        this.myLeftPanel.add((Component)((Object)this.myReplaceFieldWrapper), constraints2);
        this.myLeftPanel.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)0, (int)1));
        searchToolbar1Actions.addAll(searchToolbar2Actions.getChildren(null));
        replaceToolbar1Actions.addAll(replaceToolbar2Actions.getChildren(null));
        this.mySearchActionsToolbar = this.createSearchToolbar1(searchToolbar1Actions);
        this.mySearchActionsToolbar.setForceShowFirstComponent(true);
        NonOpaquePanel searchPair = new NonOpaquePanel((LayoutManager)new BorderLayout());
        searchPair.add((Component)this.mySearchActionsToolbar, "Center");
        this.myReplaceActionsToolbar = this.createReplaceToolbar1(replaceToolbar1Actions);
        this.myReplaceActionsToolbar.setBorder((Border)JBUI.Borders.empty());
        Wrapper replaceToolbarWrapper1 = new Wrapper((JComponent)this.myReplaceActionsToolbar);
        this.myReplaceToolbarWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.myReplaceToolbarWrapper.add((Component)replaceToolbarWrapper1, "West");
        this.myReplaceToolbarWrapper.setBorder((Border)JBUI.Borders.emptyTop((int)3));
        JLabel closeLabel = new JLabel(null, AllIcons.Actions.Close, 4);
        closeLabel.setBorder(JBUI.Borders.empty((int)2));
        closeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SearchReplaceComponent.this.close();
            }
        });
        closeLabel.setToolTipText(FindBundle.message("tooltip.close.search.bar.escape", new Object[0]));
        searchPair.add((Component)new Wrapper((JComponent)closeLabel), "East");
        this.myRightPanel = new NonOpaquePanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.myRightPanel.add((Component)searchPair);
        this.myRightPanel.add(this.myReplaceToolbarWrapper);
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.33f);
        this.myRightPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)6));
        splitter.setFirstComponent((JComponent)this.myLeftPanel);
        splitter.setSecondComponent((JComponent)this.myRightPanel);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_SECOND_MIN_SIZE);
        splitter.setHonorComponentsPreferredSize(true);
        splitter.setDividerPositionStrategy(Splitter.DividerPositionStrategy.KEEP_FIRST_SIZE);
        splitter.setAndLoadSplitterProportionKey("FindSplitterProportion");
        splitter.setOpaque(false);
        splitter.getDivider().setOpaque(false);
        this.add((Component)splitter, "Center");
        this.update("", "", false, false);
        this.myDataProviderDelegate = dataProvider;
        new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Component focusOwner = IdeFocusManager.getInstance((Project)SearchReplaceComponent.this.myProject).getFocusOwner();
                if (UIUtil.isAncestor((Component)SearchReplaceComponent.this, (Component)focusOwner)) {
                    focusOwner.transferFocus();
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(9, 0)), (JComponent)this);
        new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Component focusOwner = IdeFocusManager.getInstance((Project)SearchReplaceComponent.this.myProject).getFocusOwner();
                if (UIUtil.isAncestor((Component)SearchReplaceComponent.this, (Component)focusOwner)) {
                    focusOwner.transferFocusBackward();
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(9, 64)), (JComponent)this);
    }

    public void resetUndoRedoActions() {
        UIUtil.resetUndoRedoActions((JTextComponent)this.mySearchTextComponent);
        UIUtil.resetUndoRedoActions((JTextComponent)this.myReplaceTextComponent);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.addTextToRecent(this.mySearchTextComponent);
        if (this.myReplaceTextComponent != null) {
            this.addTextToRecent(this.myReplaceTextComponent);
        }
    }

    public void requestFocusInTheSearchFieldAndSelectContent(Project project) {
        this.mySearchTextComponent.selectAll();
        IdeFocusManager.getInstance((Project)project).requestFocus((Component)this.mySearchTextComponent, true);
        if (this.myReplaceTextComponent != null) {
            this.myReplaceTextComponent.selectAll();
        }
    }

    public void setStatusText(@NotNull String status) {
        this.myStatusText = status;
    }

    @NotNull
    public String getStatusText() {
        return this.myStatusText;
    }

    @NotNull
    public Color getStatusColor() {
        return this.myStatusColor;
    }

    public void replace() {
        if (this.myReplaceAction != null) {
            this.myReplaceAction.run();
        }
    }

    public void close() {
        if (this.myCloseAction != null) {
            this.myCloseAction.run();
        }
    }

    public void setRegularBackground() {
        this.mySearchTextComponent.setBackground(UIUtil.getTextFieldBackground());
        this.myStatusColor = UIUtil.getLabelForeground();
    }

    public void setNotFoundBackground() {
        this.mySearchTextComponent.setBackground(LightColors.RED);
        this.myStatusColor = UIUtil.getErrorForeground();
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (SpeedSearchSupply.SPEED_SEARCH_CURRENT_QUERY.is(dataId)) {
            return this.mySearchTextComponent.getText();
        }
        if (TouchbarDataKeys.ACTIONS_KEY.is(dataId)) {
            if (this.myTouchbarActions == null) {
                this.myTouchbarActions = new DefaultActionGroup();
                this.myTouchbarActions.add((AnAction)new PrevOccurrenceAction());
                this.myTouchbarActions.add((AnAction)new NextOccurrenceAction());
            }
            return this.myTouchbarActions;
        }
        return this.myDataProviderDelegate != null ? this.myDataProviderDelegate.getData(dataId) : null;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void addListener(@NotNull Listener listener2) {
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    public boolean isMultiline() {
        return this.myMultilineMode;
    }

    private void setMultilineInternal(boolean multiline) {
        boolean stateChanged = multiline != this.myMultilineMode;
        this.myMultilineMode = multiline;
        if (stateChanged) {
            ((Listener)this.myEventDispatcher.getMulticaster()).multilineStateChanged();
        }
    }

    @NotNull
    public JTextComponent getSearchTextComponent() {
        return this.mySearchTextComponent;
    }

    @NotNull
    public JTextComponent getReplaceTextComponent() {
        return this.myReplaceTextComponent;
    }

    private void updateSearchComponent(@NotNull String textToSet) {
        if (!this.updateTextComponent(true)) {
            SearchReplaceComponent.replaceTextInTextComponentEnsuringSelection(textToSet, this.mySearchTextComponent);
            return;
        }
        this.mySearchTextComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                ApplicationManager.getApplication().invokeLater(() -> ((Listener)SearchReplaceComponent.this.myEventDispatcher.getMulticaster()).searchFieldDocumentChanged());
            }
        });
        this.mySearchTextComponent.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtil.isEmpty((String)SearchReplaceComponent.this.mySearchTextComponent.getText())) {
                    SearchReplaceComponent.this.close();
                } else {
                    IdeFocusManager.getInstance((Project)SearchReplaceComponent.this.myProject).requestFocus((Component)SearchReplaceComponent.this.myTargetComponent, true);
                    SearchReplaceComponent.this.addTextToRecent(SearchReplaceComponent.this.mySearchTextComponent);
                }
            }
        }, KeyStroke.getKeyStroke(10, SystemInfo.isMac ? 256 : 128), 0);
        this.mySearchTextComponent.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        new VariantsCompletionAction(this.mySearchTextComponent);
    }

    private static void replaceTextInTextComponentEnsuringSelection(@NotNull String textToSet, JTextComponent component2) {
        String existingText = component2.getText();
        if (!existingText.equals(textToSet)) {
            component2.setText(textToSet);
            if (component2.getSelectionStart() == component2.getSelectionEnd()) {
                component2.selectAll();
            }
        }
    }

    private void updateReplaceComponent(@NotNull String textToSet) {
        if (!this.updateTextComponent(false)) {
            SearchReplaceComponent.replaceTextInTextComponentEnsuringSelection(textToSet, this.myReplaceTextComponent);
            return;
        }
        this.myReplaceTextComponent.setText(textToSet);
        this.myReplaceTextComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                ApplicationManager.getApplication().invokeLater(() -> ((Listener)SearchReplaceComponent.this.myEventDispatcher.getMulticaster()).replaceFieldDocumentChanged());
            }
        });
        if (!this.isMultiline()) {
            this.installReplaceOnEnterAction(this.myReplaceTextComponent);
        }
        new VariantsCompletionAction(this.myReplaceTextComponent);
        this.myReplaceFieldWrapper.revalidate();
        this.myReplaceFieldWrapper.repaint();
    }

    public void update(@NotNull String findText, @NotNull String replaceText, boolean replaceMode, boolean multiline) {
        this.setMultilineInternal(multiline);
        boolean needToResetSearchFocus = this.mySearchTextComponent != null && this.mySearchTextComponent.hasFocus();
        boolean needToResetReplaceFocus = this.myReplaceTextComponent != null && this.myReplaceTextComponent.hasFocus();
        this.updateSearchComponent(findText);
        this.updateReplaceComponent(replaceText);
        this.myReplaceFieldWrapper.setVisible(replaceMode);
        this.myReplaceToolbarWrapper.setVisible(replaceMode);
        if (needToResetReplaceFocus) {
            this.myReplaceTextComponent.requestFocusInWindow();
        }
        if (needToResetSearchFocus) {
            this.mySearchTextComponent.requestFocusInWindow();
        }
        this.updateBindings();
        this.updateActions();
        ArrayList<Component> focusOrder = new ArrayList<Component>();
        focusOrder.add(this.mySearchTextComponent);
        focusOrder.add(this.myReplaceTextComponent);
        focusOrder.addAll(this.myExtraSearchButtons);
        focusOrder.addAll(this.myExtraReplaceButtons);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new ListFocusTraversalPolicy(focusOrder));
        this.revalidate();
        this.repaint();
    }

    public void updateActions() {
        this.mySearchActionsToolbar.updateActionsImmediately();
        this.myReplaceActionsToolbar.updateActionsImmediately();
        JComponent textComponent = this.mySearchFieldWrapper.getTargetComponent();
        if (textComponent instanceof SearchTextArea) {
            ((SearchTextArea)textComponent).updateExtraActions();
        }
        if ((textComponent = this.myReplaceFieldWrapper.getTargetComponent()) instanceof SearchTextArea) {
            ((SearchTextArea)textComponent).updateExtraActions();
        }
    }

    public void addTextToRecent(@NotNull JTextComponent textField2) {
        String text = textField2.getText();
        if (text.length() > 0) {
            FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance((Project)this.myProject);
            if (textField2 == this.mySearchTextComponent) {
                findInProjectSettings.addStringToFind(text);
                if (this.mySearchFieldWrapper.getTargetComponent() instanceof SearchTextField) {
                    ((SearchTextField)this.mySearchFieldWrapper.getTargetComponent()).addCurrentTextToHistory();
                }
            } else {
                findInProjectSettings.addStringToReplace(text);
                if (this.myReplaceFieldWrapper.getTargetComponent() instanceof SearchTextField) {
                    ((SearchTextField)this.myReplaceFieldWrapper.getTargetComponent()).addCurrentTextToHistory();
                }
            }
        }
    }

    private boolean updateTextComponent(boolean search2) {
        JTextComponent oldComponent;
        JTextComponent jTextComponent = oldComponent = search2 ? this.mySearchTextComponent : this.myReplaceTextComponent;
        if (oldComponent != null) {
            return false;
        }
        MyTextComponentWrapper wrapper2 = search2 ? this.mySearchFieldWrapper : this.myReplaceFieldWrapper;
        final JBTextArea textComponent = new JBTextArea();
        textComponent.setRows(this.isMultiline() ? 2 : 1);
        textComponent.setColumns(12);
        if (search2) {
            textComponent.getAccessibleContext().setAccessibleName(FindBundle.message("find.search.accessible.name", new Object[0]));
        } else {
            textComponent.getAccessibleContext().setAccessibleName(FindBundle.message("find.replace.accessible.name", new Object[0]));
        }
        SearchTextArea textArea = new SearchTextArea((JTextArea)textComponent, search2);
        if (search2) {
            this.myExtraSearchButtons.clear();
            this.myExtraSearchButtons.addAll(textArea.setExtraActions(this.myEmbeddedSearchActions.toArray(AnAction.EMPTY_ARRAY)));
        } else {
            this.myExtraReplaceButtons.clear();
            this.myExtraReplaceButtons.addAll(textArea.setExtraActions(this.myEmbeddedReplaceActions.toArray(AnAction.EMPTY_ARRAY)));
        }
        textComponent.putClientProperty((Object)"StatusVisibleFunction", c -> c.getText().isEmpty() && c.isFocusOwner());
        wrapper2.setContent(textArea);
        UIUtil.addUndoRedoActions((JTextComponent)textComponent);
        textComponent.putClientProperty((Object)"AuxEditorComponent", (Object)Boolean.TRUE);
        textComponent.setBackground(UIUtil.getTextFieldBackground());
        textComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                textComponent.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                textComponent.repaint();
            }
        });
        new CloseAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                SearchReplaceComponent.this.close();
            }
        }.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"EditorEscape"), textArea);
        return true;
    }

    private void installReplaceOnEnterAction(@NotNull JTextComponent c) {
        ActionListener action2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchReplaceComponent.this.replace();
            }
        };
        c.registerKeyboardAction(action2, KeyStroke.getKeyStroke(10, 0), 0);
    }

    private void updateBindings() {
        this.updateBindings(this.mySearchFieldActions, (JComponent)((Object)this.mySearchFieldWrapper));
        this.updateBindings(this.mySearchActionsToolbar, (JComponent)((Object)this.mySearchFieldWrapper));
        this.updateBindings(this.myReplaceFieldActions, (JComponent)((Object)this.myReplaceFieldWrapper));
        this.updateBindings(this.myReplaceActionsToolbar, (JComponent)this.myReplaceToolbarWrapper);
    }

    private void updateBindings(@NotNull DefaultActionGroup group, @NotNull JComponent shortcutHolder) {
        this.updateBindings((List<? extends AnAction>)ContainerUtil.immutableList((Object[])group.getChildActionsOrStubs()), shortcutHolder);
    }

    private void updateBindings(@NotNull ActionToolbarImpl toolbar, @NotNull JComponent shortcutHolder) {
        this.updateBindings(toolbar.getActions(), shortcutHolder);
    }

    private void updateBindings(@NotNull List<? extends AnAction> actions, @NotNull JComponent shortcutHolder) {
        DataContext context = DataManager.getInstance().getDataContext((Component)this);
        for (AnAction anAction : actions) {
            ShortcutSet shortcut = null;
            if (anAction instanceof ContextAwareShortcutProvider) {
                shortcut = ((ContextAwareShortcutProvider)anAction).getShortcut(context);
            } else if (anAction instanceof ShortcutProvider) {
                shortcut = ((ShortcutProvider)anAction).getShortcut();
            }
            if (shortcut == null) continue;
            anAction.registerCustomShortcutSet(shortcut, shortcutHolder);
        }
    }

    @NotNull
    private ActionToolbarImpl createSearchToolbar1(@NotNull DefaultActionGroup group) {
        ActionToolbarImpl toolbar = this.createToolbar((ActionGroup)group);
        toolbar.setSecondaryActionsTooltip(FindBundle.message("find.popup.show.filter.popup", new Object[0]));
        toolbar.setSecondaryActionsIcon(AllIcons.General.Filter, true);
        toolbar.setNoGapMode();
        toolbar.setSecondaryButtonPopupStateModifier(new ActionToolbarImpl.SecondaryGroupUpdater(){

            @Override
            public void update(@NotNull AnActionEvent e) {
                Icon icon2 = e.getPresentation().getIcon();
                if (icon2 != null && SearchReplaceComponent.this.mySearchToolbarModifiedFlagGetter.get()) {
                    e.getPresentation().setIcon(ExecutionUtil.getLiveIndicator((Icon)icon2));
                }
            }
        });
        KeyboardShortcut keyboardShortcut = ActionManager.getInstance().getKeyboardShortcut("ShowFilterPopup");
        if (keyboardShortcut != null) {
            toolbar.setSecondaryActionsShortcut(KeymapUtil.getShortcutText((Shortcut)keyboardShortcut));
        }
        new ShowMoreOptions(toolbar, (JComponent)((Object)this.mySearchFieldWrapper));
        return toolbar;
    }

    @NotNull
    private ActionToolbarImpl createReplaceToolbar1(@NotNull DefaultActionGroup group) {
        ActionToolbarImpl toolbar = this.createToolbar((ActionGroup)group);
        toolbar.setForceMinimumSize(true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        return toolbar;
    }

    @NotNull
    private ActionToolbarImpl createToolbar(@NotNull ActionGroup group) {
        ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", group, true);
        toolbar.setTargetComponent(this);
        toolbar.setLayoutPolicy(2);
        Utils.setSmallerFontForChildren(toolbar);
        return toolbar;
    }

    private static class MyTextComponentWrapper
    extends Wrapper {
        private MyTextComponentWrapper() {
        }

        @Nullable
        public JTextComponent getTextComponent() {
            JComponent wrapped = this.getTargetComponent();
            return wrapped != null ? MyTextComponentWrapper.unwrapTextComponent(wrapped) : null;
        }

        @NotNull
        protected static JTextComponent unwrapTextComponent(@NotNull JComponent wrapped) {
            if (wrapped instanceof SearchTextField) {
                return ((SearchTextField)wrapped).getTextEditor();
            }
            if (wrapped instanceof SearchTextArea) {
                return ((SearchTextArea)wrapped).getTextArea();
            }
            throw new AssertionError();
        }
    }

    public static class Builder {
        private final Project myProject;
        private final JComponent myTargetComponent;
        private DataProvider myDataProvider;
        private Runnable myReplaceAction;
        private Runnable myCloseAction;
        private final DefaultActionGroup mySearchActions = DefaultActionGroup.createFlatGroup(() -> "search bar 1");
        private final DefaultActionGroup myExtraSearchActions = DefaultActionGroup.createFlatGroup(() -> "search bar 2");
        private final DefaultActionGroup mySearchFieldActions = DefaultActionGroup.createFlatGroup(() -> "search field actions");
        private BooleanGetter mySearchToolbarModifiedFlagGetter = BooleanGetter.FALSE;
        private final DefaultActionGroup myReplaceActions = DefaultActionGroup.createFlatGroup(() -> "replace bar 1");
        private final DefaultActionGroup myExtraReplaceActions = DefaultActionGroup.createFlatGroup(() -> "replace bar 1");
        private final DefaultActionGroup myReplaceFieldActions = DefaultActionGroup.createFlatGroup(() -> "replace field actions");

        private Builder(@Nullable Project project, @NotNull JComponent component2) {
            this.myProject = project;
            this.myTargetComponent = component2;
        }

        @NotNull
        public Builder withDataProvider(@NotNull DataProvider provider) {
            this.myDataProvider = provider;
            return this;
        }

        @NotNull
        public Builder withReplaceAction(@NotNull Runnable action2) {
            this.myReplaceAction = action2;
            return this;
        }

        @NotNull
        public Builder withCloseAction(@NotNull Runnable action2) {
            this.myCloseAction = action2;
            return this;
        }

        @NotNull
        public Builder addSearchFieldActions(AnAction ... actions) {
            this.mySearchFieldActions.addAll(actions);
            return this;
        }

        @NotNull
        public Builder addReplaceFieldActions(AnAction ... actions) {
            this.myReplaceFieldActions.addAll(actions);
            return this;
        }

        @NotNull
        public Builder addPrimarySearchActions(AnAction ... actions) {
            this.mySearchActions.addAll(actions);
            return this;
        }

        @NotNull
        public Builder addSecondarySearchActions(AnAction ... actions) {
            for (AnAction action2 : actions) {
                this.mySearchActions.addAction(action2).setAsSecondary(true);
            }
            return this;
        }

        @NotNull
        public Builder withSecondarySearchActionsIsModifiedGetter(@NotNull BooleanGetter getter) {
            this.mySearchToolbarModifiedFlagGetter = getter;
            return this;
        }

        @NotNull
        public Builder addExtraSearchActions(AnAction ... actions) {
            this.myExtraSearchActions.addAll(actions);
            return this;
        }

        @NotNull
        public Builder addPrimaryReplaceActions(AnAction ... actions) {
            this.myReplaceActions.addAll(actions);
            return this;
        }

        @NotNull
        public Builder addExtraReplaceAction(AnAction ... actions) {
            this.myExtraReplaceActions.addAll(actions);
            return this;
        }

        @NotNull
        public SearchReplaceComponent build() {
            return new SearchReplaceComponent(this.myProject, this.myTargetComponent, this.mySearchActions, this.mySearchToolbarModifiedFlagGetter, this.myExtraSearchActions, this.mySearchFieldActions, this.myReplaceActions, this.myExtraReplaceActions, this.myReplaceFieldActions, this.myReplaceAction, this.myCloseAction, this.myDataProvider);
        }
    }

    public static interface Listener
    extends EventListener {
        public void searchFieldDocumentChanged();

        public void replaceFieldDocumentChanged();

        public void multilineStateChanged();
    }

    private static abstract class CloseAction
    extends DumbAwareAction
    implements LightEditCompatible {
        private CloseAction() {
        }
    }
}

