/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionDescriptor;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLDistributionLegacy
extends WSLDistribution {
    private static final WslDistributionDescriptor LEGACY_WSL = new WslDistributionDescriptor("UBUNTU_LEGACY", "ubuntu_bash", "bash.exe", "Ubuntu (Legacy)");
    private static final String WSL_ROOT_CHUNK = "\\lxss\\rootfs";
    private static final AtomicNullableLazyValue<String> WSL_ROOT_IN_WINDOWS_PROVIDER = AtomicNullableLazyValue.createValue(() -> {
        String localAppDataPath = System.getenv().get("LOCALAPPDATA");
        return StringUtil.isEmpty((String)localAppDataPath) ? null : localAppDataPath + WSL_ROOT_CHUNK;
    });

    @Nullable
    private static Path getExecutableRootPath() {
        String windir = System.getenv().get("windir");
        return StringUtil.isEmpty((String)windir) ? null : Paths.get(windir, "System32");
    }

    @Nullable
    public static WSLDistributionLegacy getInstance() {
        Path executableRoot = WSLDistributionLegacy.getExecutableRootPath();
        if (executableRoot == null) {
            return null;
        }
        Path executablePath = executableRoot.resolve(LEGACY_WSL.getExecutablePath());
        if (Files.exists(executablePath, LinkOption.NOFOLLOW_LINKS)) {
            return new WSLDistributionLegacy(executablePath);
        }
        return null;
    }

    private WSLDistributionLegacy(@NotNull Path executablePath) {
        super(LEGACY_WSL, executablePath);
    }

    @Override
    @NotNull
    protected String getRunCommandLineParameter() {
        return "-c";
    }

    @Override
    @Nullable
    public String getWslPath(@NotNull String windowsPath) {
        String wslRootInHost = (String)WSL_ROOT_IN_WINDOWS_PROVIDER.getValue();
        if (wslRootInHost == null) {
            return null;
        }
        if (FileUtil.isAncestor((String)wslRootInHost, (String)windowsPath, (boolean)true)) {
            return FileUtil.toSystemIndependentName((String)windowsPath.substring(wslRootInHost.length()));
        }
        return super.getWslPath(windowsPath);
    }

    @Override
    @Nullable
    public String getWindowsPath(@NotNull String wslPath) {
        String windowsPath = super.getWindowsPath(wslPath);
        if (windowsPath != null) {
            return windowsPath;
        }
        String wslRootInHost = (String)WSL_ROOT_IN_WINDOWS_PROVIDER.getValue();
        if (wslRootInHost == null) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)(wslRootInHost + wslPath));
    }
}

