/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.ide.macro.PromptingMacro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.WorkingDirectoryProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class ProgramParametersConfigurator {
    private static final ExtensionPointName<WorkingDirectoryProvider> WORKING_DIRECTORY_PROVIDER_EP_NAME = ExtensionPointName.create((String)"com.intellij.module.workingDirectoryProvider");
    @Deprecated
    public static final String MODULE_WORKING_DIR = "%MODULE_WORKING_DIR%";

    public void configureConfiguration(@NotNull SimpleProgramParameters parameters2, @NotNull CommonProgramRunConfigurationParameters configuration) {
        Project project = configuration.getProject();
        Module module = this.getModule(configuration);
        String parametersString = this.expandPathAndMacros(configuration.getProgramParameters(), module, project);
        parameters2.getProgramParametersList().addParametersString(parametersString);
        parameters2.setWorkingDirectory(this.getWorkingDir(configuration, project, module));
        HashMap<String, String> envs = new HashMap<String, String>(configuration.getEnvs());
        EnvironmentUtil.inlineParentOccurrences(envs);
        for (Map.Entry entry : envs.entrySet()) {
            entry.setValue(this.expandPath((String)entry.getValue(), module, project));
        }
        parameters2.setEnv(envs);
        parameters2.setPassParentEnvs(configuration.isPassParentEnvs());
    }

    @Contract(value="!null, _, _ -> !null")
    @Nullable
    public String expandPathAndMacros(String s, @Nullable Module module, @NotNull Project project) {
        String path = s;
        if (path != null) {
            path = this.expandPath(path, module, project);
        }
        if (path != null) {
            path = ProgramParametersConfigurator.expandMacros(path, ProgramParametersConfigurator.projectContext(project, module), false);
        }
        return path;
    }

    private static DataContext projectContext(Project project, Module module) {
        return dataId -> {
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return project;
            }
            if (LangDataKeys.MODULE.is(dataId) || LangDataKeys.MODULE_CONTEXT.is(dataId)) {
                return module;
            }
            return null;
        };
    }

    public static String expandMacros(@Nullable String path) {
        return !StringUtil.isEmpty((String)path) ? ProgramParametersConfigurator.expandMacros(path, DataContext.EMPTY_CONTEXT, false) : path;
    }

    @NotNull
    public static List<String> expandMacrosAndParseParameters(@Nullable String parametersStringWithMacros) {
        if (StringUtil.isEmpty((String)parametersStringWithMacros)) {
            return Collections.emptyList();
        }
        String expandedParametersString = ProgramParametersConfigurator.expandMacros(parametersStringWithMacros, DataContext.EMPTY_CONTEXT, true);
        return ParametersListUtil.parse((String)expandedParametersString);
    }

    private static String expandMacros(String path, DataContext dataContext, boolean applyParameterEscaping) {
        if (!Registry.is((String)"allow.macros.for.run.configurations")) {
            return path;
        }
        for (Macro macro : MacroManager.getInstance().getMacros()) {
            String template = "$" + macro.getName() + "$";
            int index = path.indexOf(template);
            while (index != -1 && index < path.length() + template.length()) {
                String value2 = StringUtil.notNullize((String)ProgramParametersConfigurator.previewOrExpandMacro(macro, dataContext));
                if (applyParameterEscaping) {
                    value2 = ParametersListUtil.escape((CharSequence)value2);
                }
                path = path.substring(0, index) + value2 + path.substring(index + template.length());
                index += value2.length();
                index = path.indexOf(template, index);
            }
        }
        return path;
    }

    @Nullable
    private static String previewOrExpandMacro(Macro macro, DataContext dataContext) {
        try {
            return macro instanceof PromptingMacro ? macro.expand(dataContext) : macro.preview();
        }
        catch (Macro.ExecutionCancelledException e) {
            return null;
        }
    }

    @Nullable
    public String getWorkingDir(@NotNull CommonProgramRunConfigurationParameters configuration, @NotNull Project project, @Nullable Module module) {
        String workingDirectory = configuration.getWorkingDirectory();
        String projectDirectory = this.getDefaultWorkingDir(project);
        if (StringUtil.isEmptyOrSpaces((String)workingDirectory) && (workingDirectory = projectDirectory) == null) {
            return null;
        }
        if (MODULE_WORKING_DIR.equals(workingDirectory = this.expandPathAndMacros(workingDirectory, module, project)) || "$MODULE_DIR$".equals(workingDirectory)) {
            workingDirectory = "$MODULE_WORKING_DIR$";
        }
        if ("$MODULE_WORKING_DIR$".equals(workingDirectory)) {
            String moduleDirectory;
            if (module != null && (moduleDirectory = this.getDefaultWorkingDir(module)) != null) {
                return moduleDirectory;
            }
            if (projectDirectory != null) {
                return projectDirectory;
            }
        }
        if (projectDirectory != null && !OSAgnosticPathUtil.isAbsolute((String)workingDirectory)) {
            workingDirectory = projectDirectory + '/' + workingDirectory;
        }
        return workingDirectory;
    }

    @Nullable
    protected String getDefaultWorkingDir(@NotNull Project project) {
        String path = project.getBasePath();
        return path != null && LocalFileSystem.getInstance().findFileByPath(path) != null ? path : null;
    }

    @Nullable
    protected String getDefaultWorkingDir(@NotNull Module module) {
        for (WorkingDirectoryProvider provider : (WorkingDirectoryProvider[])WORKING_DIRECTORY_PROVIDER_EP_NAME.getExtensions()) {
            @SystemIndependent String path = provider.getWorkingDirectoryPath(module);
            if (path == null) continue;
            return path;
        }
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (roots.length > 0) {
            return roots[0].getPath();
        }
        return null;
    }

    public void checkWorkingDirectoryExist(@NotNull CommonProgramRunConfigurationParameters configuration, @NotNull Project project, @Nullable Module module) throws RuntimeConfigurationWarning {
        String workingDir = this.getWorkingDir(configuration, project, module);
        if (workingDir == null) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"dialog.message.working.directory.null.for.project.module", (Object[])new Object[]{project.getName(), project.getBasePath(), module == null ? "null" : "'" + module.getName() + "' (" + module.getModuleFilePath() + ")"}));
        }
        if (!Files.exists(Paths.get(workingDir, new String[0]), new LinkOption[0])) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"dialog.message.working.directory.doesn.t.exist", (Object[])new Object[]{workingDir}));
        }
    }

    protected String expandPath(@Nullable String path, @Nullable Module module, @NotNull Project project) {
        if (module != null && "$MODULE_DIR$".equals(path) && module.getModuleFilePath().contains("/.idea/") && ExternalProjectSystemRegistry.getInstance().getExternalSource(module) != null) {
            return this.getDefaultWorkingDir(module);
        }
        path = PathMacroManager.getInstance((ComponentManager)project).expandPath(path);
        if (module != null) {
            path = PathMacroManager.getInstance((ComponentManager)module).expandPath(path);
        }
        return path;
    }

    @Nullable
    protected Module getModule(CommonProgramRunConfigurationParameters cp) {
        return cp instanceof ModuleBasedConfiguration ? ((ModuleBasedConfiguration)cp).getConfigurationModule().getModule() : null;
    }
}

