/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.InputRedirectAware;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.ui.CommandLinePanel;
import com.intellij.execution.ui.FragmentedSettingsUtil;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonParameterFragments<Settings extends CommonProgramRunConfigurationParameters> {
    private final List<SettingsEditorFragment<Settings, ?>> myFragments = new ArrayList();
    private final SettingsEditorFragment<Settings, LabeledComponent<TextFieldWithBrowseButton>> myWorkingDirectory;

    public CommonParameterFragments(@NotNull Project project, Computable<Boolean> hasModule) {
        RawCommandLineEditor programArguments = new RawCommandLineEditor();
        CommandLinePanel.setMinimumWidth((Component)programArguments, (int)200);
        String message = ExecutionBundle.message((String)"run.configuration.program.placeholder", (Object[])new Object[0]);
        programArguments.getEditorField().getEmptyText().setText(message);
        programArguments.getEditorField().getAccessibleContext().setAccessibleName(message);
        FragmentedSettingsUtil.setupPlaceholderVisibility((JBTextField)programArguments.getEditorField());
        MacrosDialog.addMacroSupport((ExtendableTextField)programArguments.getEditorField(), MacrosDialog.Filters.ALL, hasModule);
        SettingsEditorFragment parameters2 = new SettingsEditorFragment("commandLineParameters", null, null, (JComponent)programArguments, 100, (settings, component2) -> component2.setText(settings.getProgramParameters()), (settings, component2) -> settings.setProgramParameters(component2.getText()), settings -> true);
        parameters2.setHint(ExecutionBundle.message((String)"run.configuration.program.hint", (Object[])new Object[0]));
        this.myFragments.add(parameters2);
        TextFieldWithBrowseButton workingDirectoryField = new TextFieldWithBrowseButton();
        workingDirectoryField.addBrowseFolderListener(ExecutionBundle.message((String)"select.working.directory.message", (Object[])new Object[0]), null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        MacrosDialog.addMacroSupport((ExtendableTextField)workingDirectoryField.getTextField(), MacrosDialog.Filters.DIRECTORY_PATH, hasModule);
        LabeledComponent field = LabeledComponent.create((JComponent)workingDirectoryField, (String)ExecutionBundle.message((String)"run.configuration.working.directory.label", (Object[])new Object[0]));
        field.setLabelLocation("West");
        this.myWorkingDirectory = new SettingsEditorFragment("workingDirectory", null, null, (JComponent)field, (settings, component2) -> ((TextFieldWithBrowseButton)component2.getComponent()).setText(settings.getWorkingDirectory()), (settings, component2) -> settings.setWorkingDirectory(((TextFieldWithBrowseButton)component2.getComponent()).getText()), settings -> StringUtil.isNotEmpty((String)settings.getWorkingDirectory()));
        this.myFragments.add(this.myWorkingDirectory);
        this.myFragments.add(CommonParameterFragments.createEnvParameters());
    }

    public List<SettingsEditorFragment<Settings, ?>> getFragments() {
        return this.myFragments;
    }

    public <S extends InputRedirectAware> SettingsEditorFragment<S, ?> createRedirectFragment(Computable<Boolean> hasModule) {
        TextFieldWithBrowseButton inputFile = new TextFieldWithBrowseButton();
        inputFile.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(null, null, (ComponentWithBrowseButton)inputFile, null, FileChooserDescriptorFactory.createSingleFileDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            @Nullable
            protected VirtualFile getInitialFile() {
                VirtualFile initialFile = super.getInitialFile();
                if (initialFile != null) {
                    return initialFile;
                }
                String text = ((TextFieldWithBrowseButton)((LabeledComponent)CommonParameterFragments.this.myWorkingDirectory.component()).getComponent()).getText();
                return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)text));
            }
        });
        MacrosDialog.addMacroSupport((ExtendableTextField)inputFile.getTextField(), MacrosDialog.Filters.ALL, hasModule);
        LabeledComponent labeledComponent = LabeledComponent.create((JComponent)inputFile, (String)ExecutionBundle.message((String)"redirect.input.from", (Object[])new Object[0]));
        labeledComponent.setLabelLocation("West");
        return new SettingsEditorFragment("redirectInput", ExecutionBundle.message((String)"redirect.input.from.name", (Object[])new Object[0]), ExecutionBundle.message((String)"group.operating.system", (Object[])new Object[0]), (JComponent)labeledComponent, (settings, component2) -> ((TextFieldWithBrowseButton)component2.getComponent()).setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)settings.getInputRedirectOptions().getRedirectInputPath()))), (settings, component2) -> {
            String filePath = ((TextFieldWithBrowseButton)component2.getComponent()).getText();
            settings.getInputRedirectOptions().setRedirectInput(component2.isVisible() && StringUtil.isNotEmpty((String)filePath));
            settings.getInputRedirectOptions().setRedirectInputPath(StringUtil.isEmpty((String)filePath) ? null : FileUtil.toSystemIndependentName((String)filePath));
        }, settings -> StringUtil.isNotEmpty((String)settings.getInputRedirectOptions().getRedirectInputPath()));
    }

    public static <S extends CommonProgramRunConfigurationParameters> SettingsEditorFragment<S, ?> createEnvParameters() {
        EnvironmentVariablesComponent env = new EnvironmentVariablesComponent();
        env.setLabelLocation("West");
        UIUtil.setMonospaced((Component)((TextFieldWithBrowseButton)env.getComponent()).getTextField());
        SettingsEditorFragment fragment = new SettingsEditorFragment("environmentVariables", ExecutionBundle.message((String)"environment.variables.fragment.name", (Object[])new Object[0]), ExecutionBundle.message((String)"group.operating.system", (Object[])new Object[0]), (JComponent)((Object)env), (settings, c) -> env.reset((CommonProgramRunConfigurationParameters)settings), (settings, c) -> {
            if (!env.isVisible()) {
                settings.setEnvs(Collections.emptyMap());
                settings.setPassParentEnvs(true);
            } else {
                env.apply((CommonProgramRunConfigurationParameters)settings);
            }
        }, s -> true);
        fragment.setHint(ExecutionBundle.message((String)"environment.variables.fragment.hint", (Object[])new Object[0]));
        return fragment;
    }
}

