/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.events;

import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.TestFailed;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestFailedEvent
extends TreeNodeEvent {
    private final String myLocalizedFailureMessage;
    private final String myStacktrace;
    private final boolean myTestError;
    private final String myComparisonFailureActualText;
    private final String myComparisonFailureExpectedText;
    private final String myExpectedFilePath;
    private final String myActualFilePath;
    private final long myDurationMillis;
    private final boolean myExpectedFileTemp;
    private final boolean myActualFileTemp;
    private final boolean myPrintExpectedAndActualValues;

    public TestFailedEvent(@NotNull TestFailed testFailed, boolean testError) {
        this(testFailed, testError, null);
    }

    public TestFailedEvent(@NotNull TestFailed testFailed, boolean testError, @Nullable String expectedFilePath) {
        this(testFailed, testError, expectedFilePath, null);
    }

    public TestFailedEvent(@NotNull TestFailed testFailed, boolean testError, @Nullable String expectedFilePath, @Nullable String actualFilePath) {
        super(testFailed.getTestName(), TreeNodeEvent.getNodeId((ServiceMessage)testFailed));
        if (testFailed.getFailureMessage() == null) {
            throw new NullPointerException();
        }
        this.myLocalizedFailureMessage = testFailed.getFailureMessage();
        this.myStacktrace = testFailed.getStacktrace();
        this.myTestError = testError;
        this.myExpectedFilePath = expectedFilePath;
        String expected = testFailed.getExpected();
        if (expected == null && expectedFilePath != null) {
            expected = TestFailedEvent.loadExpectedText(expectedFilePath);
        }
        this.myComparisonFailureExpectedText = expected;
        this.myActualFilePath = actualFilePath;
        String actual = testFailed.getActual();
        if (actual == null && actualFilePath != null) {
            try {
                actual = FileUtil.loadFile((File)new File(actualFilePath));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.myComparisonFailureActualText = actual;
        Map attributes = testFailed.getAttributes();
        this.myDurationMillis = TestFailedEvent.parseDuration((String)attributes.get("duration"));
        this.myActualFileTemp = Boolean.parseBoolean((String)attributes.get("actualIsTempFile"));
        this.myExpectedFileTemp = Boolean.parseBoolean((String)attributes.get("expectedIsTempFile"));
        this.myPrintExpectedAndActualValues = TestFailedEvent.parsePrintExpectedAndActual(testFailed);
    }

    private static boolean parsePrintExpectedAndActual(@NotNull TestFailed testFailed) {
        return !Boolean.FALSE.toString().equals(testFailed.getAttributes().get("printExpectedAndActual"));
    }

    public boolean isExpectedFileTemp() {
        return this.myExpectedFileTemp;
    }

    public boolean isActualFileTemp() {
        return this.myActualFileTemp;
    }

    private static long parseDuration(@Nullable String durationStr) {
        if (!StringUtil.isEmpty((String)durationStr)) {
            try {
                return Long.parseLong(durationStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    public TestFailedEvent(@NotNull String testName, @NotNull String localizedFailureMessage, @Nullable String stackTrace, boolean testError, @Nullable String comparisonFailureActualText, @Nullable String comparisonFailureExpectedText) {
        this(testName, null, localizedFailureMessage, stackTrace, testError, comparisonFailureActualText, comparisonFailureExpectedText, null, null, false, false, -1L);
    }

    public TestFailedEvent(@Nullable String testName, @Nullable String id2, @NotNull String localizedFailureMessage, @Nullable String stackTrace, boolean testError, @Nullable String comparisonFailureActualText, @Nullable String comparisonFailureExpectedText, @Nullable String expectedFilePath, @Nullable String actualFilePath, boolean expectedFileTemp, boolean actualFileTemp, long durationMillis) {
        this(testName, id2, localizedFailureMessage, stackTrace, testError, comparisonFailureActualText, comparisonFailureExpectedText, true, expectedFilePath, actualFilePath, expectedFileTemp, actualFileTemp, durationMillis);
    }

    private TestFailedEvent(@Nullable String testName, @Nullable String id2, @NotNull String localizedFailureMessage, @Nullable String stackTrace, boolean testError, @Nullable String comparisonFailureActualText, @Nullable String comparisonFailureExpectedText, boolean printExpectedAndActualValues, @Nullable String expectedFilePath, @Nullable String actualFilePath, boolean expectedFileTemp, boolean actualFileTemp, long durationMillis) {
        super(testName, id2);
        this.myLocalizedFailureMessage = localizedFailureMessage;
        this.myStacktrace = stackTrace;
        this.myTestError = testError;
        this.myExpectedFilePath = expectedFilePath;
        if (comparisonFailureExpectedText == null && expectedFilePath != null) {
            comparisonFailureExpectedText = TestFailedEvent.loadExpectedText(expectedFilePath);
        }
        this.myComparisonFailureActualText = comparisonFailureActualText;
        this.myPrintExpectedAndActualValues = printExpectedAndActualValues;
        this.myActualFilePath = actualFilePath;
        this.myComparisonFailureExpectedText = comparisonFailureExpectedText;
        this.myDurationMillis = durationMillis;
        this.myExpectedFileTemp = expectedFileTemp;
        this.myActualFileTemp = actualFileTemp;
    }

    private static String loadExpectedText(@NotNull String expectedFilePath) {
        try {
            int jarSep = expectedFilePath.indexOf("!/");
            if (jarSep == -1) {
                return FileUtil.loadFile((File)new File(expectedFilePath));
            }
            String localPath = expectedFilePath.substring(0, jarSep);
            String jarPath = expectedFilePath.substring(jarSep + "!/".length());
            return FileUtil.loadTextAndClose((InputStream)URLUtil.getJarEntryURL((File)new File(localPath), (String)jarPath).openStream());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @NotNull
    public String getLocalizedFailureMessage() {
        return this.myLocalizedFailureMessage;
    }

    @Nullable
    public String getStacktrace() {
        return this.myStacktrace;
    }

    public boolean isTestError() {
        return this.myTestError;
    }

    @Nullable
    public String getComparisonFailureActualText() {
        return this.myComparisonFailureActualText;
    }

    @Nullable
    public String getComparisonFailureExpectedText() {
        return this.myComparisonFailureExpectedText;
    }

    @Override
    protected void appendToStringInfo(@NotNull StringBuilder buf) {
        TestFailedEvent.append(buf, "localizedFailureMessage", this.myLocalizedFailureMessage);
        TestFailedEvent.append(buf, "stacktrace", this.myStacktrace);
        TestFailedEvent.append(buf, "isTestError", this.myTestError);
        TestFailedEvent.append(buf, "comparisonFailureActualText", this.myComparisonFailureActualText);
        TestFailedEvent.append(buf, "comparisonFailureExpectedText", this.myComparisonFailureExpectedText);
    }

    @Deprecated
    public String getFilePath() {
        return this.myExpectedFilePath;
    }

    @Nullable
    public String getExpectedFilePath() {
        return this.myExpectedFilePath;
    }

    public boolean shouldPrintExpectedAndActualValues() {
        return this.myPrintExpectedAndActualValues;
    }

    @Nullable
    public String getActualFilePath() {
        return this.myActualFilePath;
    }

    public long getDurationMillis() {
        return this.myDurationMillis;
    }
}

