/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.autotest;

import com.intellij.AppTopics;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.execution.testframework.autotest.AutoTestWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.PsiErrorElementUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.messages.MessageBusConnection;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DelayedDocumentWatcher
implements AutoTestWatcher {
    private final Project myProject;
    private final int myDelayMillis;
    private final IntConsumer myModificationStampConsumer;
    private final Predicate<? super VirtualFile> myChangedFileFilter;
    private final MyDocumentAdapter myListener;
    private Disposable myDisposable;
    private SingleAlarm myAlarm;
    private final Set<VirtualFile> myChangedFiles = new ObjectOpenHashSet();
    private boolean myDocumentSavingInProgress = false;
    private MessageBusConnection myConnection;
    private int myModificationStamp = 0;

    @Deprecated
    public DelayedDocumentWatcher(@NotNull Project project, int delayMillis, @NotNull Consumer<? super Integer> modificationStampConsumer, @Nullable Condition<? super VirtualFile> changedFileFilter) {
        this(project, delayMillis, (int it) -> modificationStampConsumer.consume((Object)it), (? super VirtualFile it) -> changedFileFilter.value(it));
    }

    public DelayedDocumentWatcher(@NotNull Project project, int delayMillis, @NotNull IntConsumer modificationStampConsumer, @Nullable Predicate<? super VirtualFile> changedFileFilter) {
        this.myProject = project;
        this.myDelayMillis = delayMillis;
        this.myModificationStampConsumer = modificationStampConsumer;
        this.myChangedFileFilter = changedFileFilter;
        this.myListener = new MyDocumentAdapter();
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public void activate() {
        if (this.myConnection == null) {
            this.myDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)this.myProject, (Disposable)this.myDisposable);
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)this.myListener, this.myDisposable);
            this.myConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject);
            this.myConnection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

                public void beforeAllDocumentsSaving() {
                    DelayedDocumentWatcher.this.myDocumentSavingInProgress = true;
                    ApplicationManager.getApplication().invokeLater(() -> DelayedDocumentWatcher.this.myDocumentSavingInProgress = false, ModalityState.any());
                }
            });
            LookupManager.getInstance(this.myProject).addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("activeLookup".equals(evt.getPropertyName()) && evt.getNewValue() == null && !DelayedDocumentWatcher.this.myChangedFiles.isEmpty()) {
                        DelayedDocumentWatcher.this.myAlarm.cancelAndRequest();
                    }
                }
            }, this.myDisposable);
            this.myAlarm = new SingleAlarm((Runnable)new MyRunnable(), this.myDelayMillis, Alarm.ThreadToUse.SWING_THREAD, this.myDisposable);
        }
    }

    @Override
    public void deactivate() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
            this.myDisposable = null;
        }
        if (this.myConnection != null) {
            this.myConnection.disconnect();
            this.myConnection = null;
        }
    }

    @Override
    public boolean isUpToDate(int modificationStamp) {
        return this.myModificationStamp == modificationStamp;
    }

    private void asyncCheckErrors(@NotNull Collection<? extends VirtualFile> files2, @NotNull Consumer<? super Boolean> errorsFoundConsumer) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            boolean errorsFound = (Boolean)ReadAction.compute(() -> {
                for (VirtualFile file2 : files2) {
                    if (!PsiErrorElementUtil.hasErrors(this.myProject, file2)) continue;
                    return true;
                }
                return false;
            });
            ApplicationManager.getApplication().invokeLater(() -> errorsFoundConsumer.consume((Object)errorsFound), ModalityState.any());
        });
    }

    private class MyRunnable
    implements Runnable {
        private MyRunnable() {
        }

        @Override
        public void run() {
            int oldModificationStamp = DelayedDocumentWatcher.this.myModificationStamp;
            DelayedDocumentWatcher.this.asyncCheckErrors(DelayedDocumentWatcher.this.myChangedFiles, (Consumer<? super Boolean>)errorsFound -> {
                if (Disposer.isDisposed((Disposable)DelayedDocumentWatcher.this.myDisposable)) {
                    return;
                }
                if (DelayedDocumentWatcher.this.myModificationStamp != oldModificationStamp) {
                    return;
                }
                LookupEx activeLookup = LookupManager.getInstance(DelayedDocumentWatcher.this.myProject).getActiveLookup();
                if (activeLookup != null && activeLookup.isCompletion()) {
                    return;
                }
                if (errorsFound.booleanValue()) {
                    return;
                }
                DelayedDocumentWatcher.this.myChangedFiles.clear();
                DelayedDocumentWatcher.this.myModificationStampConsumer.accept(DelayedDocumentWatcher.this.myModificationStamp);
            });
        }
    }

    private class MyDocumentAdapter
    implements DocumentListener {
        private MyDocumentAdapter() {
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            if (DelayedDocumentWatcher.this.myDocumentSavingInProgress) {
                return;
            }
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(event.getDocument());
            if (file2 == null) {
                return;
            }
            if (!DelayedDocumentWatcher.this.myChangedFiles.contains(file2)) {
                if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file2)) {
                    return;
                }
                if (DelayedDocumentWatcher.this.myChangedFileFilter != null && !DelayedDocumentWatcher.this.myChangedFileFilter.test(file2)) {
                    return;
                }
                DelayedDocumentWatcher.this.myChangedFiles.add(file2);
            }
            DelayedDocumentWatcher.this.myAlarm.cancelAndRequest();
            DelayedDocumentWatcher.this.myModificationStamp++;
        }
    }
}

