/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SourceScope {
    public abstract GlobalSearchScope getGlobalSearchScope();

    public abstract Project getProject();

    public abstract GlobalSearchScope getLibrariesScope();

    @NotNull
    private static Map<Module, Collection<Module>> buildAllDependencies(@NotNull Project project) {
        Graph graph2 = ModuleManager.getInstance((Project)project).moduleGraph();
        HashMap<Module, Collection<Module>> result2 = new HashMap<Module, Collection<Module>>();
        for (Module module : graph2.getNodes()) {
            SourceScope.buildDependenciesForModule(module, (Graph<Module>)graph2, result2);
        }
        return result2;
    }

    private static void buildDependenciesForModule(@NotNull Module module, final Graph<Module> graph2, Map<Module, Collection<Module>> map2) {
        final HashSet deps = new HashSet();
        map2.put(module, deps);
        new Object(){

            void traverse(Module m) {
                Iterator iterator2 = graph2.getIn((Object)m);
                while (iterator2.hasNext()) {
                    Module dep = (Module)iterator2.next();
                    if (deps.contains(dep)) continue;
                    deps.add(dep);
                    this.traverse(dep);
                }
            }
        }.traverse(module);
    }

    public static SourceScope wholeProject(final Project project) {
        return new SourceScope(){

            @Override
            public GlobalSearchScope getGlobalSearchScope() {
                return GlobalSearchScope.allScope((Project)project);
            }

            @Override
            public Project getProject() {
                return project;
            }

            @Override
            public Module[] getModulesToCompile() {
                return ModuleManager.getInstance((Project)project).getModules();
            }

            @Override
            public GlobalSearchScope getLibrariesScope() {
                return this.getGlobalSearchScope();
            }
        };
    }

    public static SourceScope modulesWithDependencies(final Module[] modules2) {
        if (modules2 == null || modules2.length == 0) {
            return null;
        }
        return new ModuleSourceScope(modules2[0].getProject()){

            @Override
            public GlobalSearchScope getGlobalSearchScope() {
                return SourceScope.evaluateScopesAndUnite(modules2, module -> module.getModuleRuntimeScope(true));
            }

            @Override
            public GlobalSearchScope getLibrariesScope() {
                return SourceScope.evaluateScopesAndUnite(modules2, module -> new ModuleWithDependenciesAndLibsDependencies(module));
            }

            @Override
            public Module[] getModulesToCompile() {
                return modules2;
            }
        };
    }

    private static GlobalSearchScope evaluateScopesAndUnite(Module[] modules2, ScopeForModuleEvaluator evaluator) {
        GlobalSearchScope[] scopes = (GlobalSearchScope[])ContainerUtil.map2Array((Object[])modules2, GlobalSearchScope.class, module -> evaluator.evaluate((Module)module));
        return GlobalSearchScope.union((GlobalSearchScope[])scopes);
    }

    public static SourceScope modules(final Module[] modules2) {
        if (modules2 == null || modules2.length == 0) {
            return null;
        }
        return new ModuleSourceScope(modules2[0].getProject()){

            @Override
            public GlobalSearchScope getGlobalSearchScope() {
                return SourceScope.evaluateScopesAndUnite(modules2, module -> GlobalSearchScope.moduleScope((Module)module));
            }

            @Override
            public GlobalSearchScope getLibrariesScope() {
                return SourceScope.evaluateScopesAndUnite(modules2, module -> GlobalSearchScope.moduleWithLibrariesScope((Module)module));
            }

            @Override
            public Module[] getModulesToCompile() {
                return modules2;
            }
        };
    }

    public abstract Module[] getModulesToCompile();

    private static class ModuleWithDependenciesAndLibsDependencies
    extends GlobalSearchScope {
        private final GlobalSearchScope myMainScope;
        private final List<GlobalSearchScope> myScopes = new ArrayList<GlobalSearchScope>();

        ModuleWithDependenciesAndLibsDependencies(Module module) {
            super(module.getProject());
            this.myMainScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            Map map2 = SourceScope.buildAllDependencies(module.getProject());
            Collection modules2 = (Collection)map2.get(module);
            for (Module dependency : modules2) {
                this.myScopes.add(GlobalSearchScope.moduleWithLibrariesScope((Module)dependency));
            }
        }

        public boolean contains(@NotNull VirtualFile file2) {
            return this.findScopeFor(file2) != null;
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            GlobalSearchScope scope = this.findScopeFor(file1);
            assert (scope != null);
            if (scope.contains(file2)) {
                return scope.compare(file1, file2);
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return this.myMainScope.isSearchInModuleContent(aModule);
        }

        public boolean isSearchInLibraries() {
            return true;
        }

        @NotNull
        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            return this.myMainScope.getUnloadedModulesBelongingToScope();
        }

        @Nullable
        private GlobalSearchScope findScopeFor(VirtualFile file2) {
            if (this.myMainScope.contains(file2)) {
                return this.myMainScope;
            }
            int size = this.myScopes.size();
            for (int i2 = 0; i2 < size; ++i2) {
                GlobalSearchScope scope = this.myScopes.get(i2);
                if (!scope.contains(file2)) continue;
                return scope;
            }
            return null;
        }
    }

    private static interface ScopeForModuleEvaluator {
        public GlobalSearchScope evaluate(Module var1);
    }

    private static abstract class ModuleSourceScope
    extends SourceScope {
        private final Project myProject;

        ModuleSourceScope(Project project) {
            this.myProject = project;
        }

        @Override
        public Project getProject() {
            return this.myProject;
        }
    }
}

