/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.util.Processor;
import com.intellij.util.ui.EditableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

public class ProjectStartupTasksTableModel
extends AbstractTableModel
implements EditableModel {
    public static final int NAME_COLUMN = 0;
    public static final int IS_SHARED_COLUMN = 1;
    private final Set<RunnerAndConfigurationSettings> mySharedConfigurations = new HashSet<RunnerAndConfigurationSettings>();
    private final List<RunnerAndConfigurationSettings> myAllConfigurations = new ArrayList<RunnerAndConfigurationSettings>();

    public void setData(Collection<? extends RunnerAndConfigurationSettings> shared, Collection<? extends RunnerAndConfigurationSettings> local) {
        this.mySharedConfigurations.clear();
        this.myAllConfigurations.clear();
        this.mySharedConfigurations.addAll(shared);
        this.myAllConfigurations.addAll(shared);
        this.myAllConfigurations.addAll(local);
        this.myAllConfigurations.sort(new RunnerAndConfigurationSettingsComparator());
    }

    public void addRow() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void exchangeRows(int oldIndex, int newIndex) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean canExchangeRows(int oldIndex, int newIndex) {
        return false;
    }

    public void removeRow(int idx) {
        RunnerAndConfigurationSettings settings = this.myAllConfigurations.remove(idx);
        if (settings != null) {
            this.mySharedConfigurations.remove(settings);
            this.fireTableDataChanged();
        }
    }

    @Override
    public int getRowCount() {
        return this.myAllConfigurations.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int columnIndex) {
        if (1 == columnIndex) {
            return Boolean.class;
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (0 == columnIndex) {
            return this.myAllConfigurations.get(rowIndex).getName();
        }
        if (1 == columnIndex) {
            return this.mySharedConfigurations.contains(this.myAllConfigurations.get(rowIndex));
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (1 == columnIndex) {
            if (Boolean.TRUE.equals(aValue)) {
                this.mySharedConfigurations.add(this.myAllConfigurations.get(rowIndex));
            } else {
                this.mySharedConfigurations.remove(this.myAllConfigurations.get(rowIndex));
            }
            this.fireTableRowsUpdated(rowIndex, rowIndex + 1);
        }
    }

    @Override
    @NotNull
    public String getColumnName(int column) {
        if (0 == column) {
            return "Run Configuration";
        }
        if (1 == column) {
            return "Shared";
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (0 == columnIndex) {
            return false;
        }
        return this.myAllConfigurations.get(rowIndex).isShared();
    }

    public void addConfiguration(@NotNull RunnerAndConfigurationSettings configuration) {
        if (this.myAllConfigurations.contains(configuration)) {
            return;
        }
        this.myAllConfigurations.add(configuration);
        this.myAllConfigurations.sort(RunnerAndConfigurationSettingsComparator.getInstance());
        if (configuration.isShared()) {
            this.mySharedConfigurations.add(configuration);
        }
        this.fireTableDataChanged();
    }

    public Set<RunnerAndConfigurationSettings> getSharedConfigurations() {
        return this.mySharedConfigurations;
    }

    public List<RunnerAndConfigurationSettings> getAllConfigurations() {
        return this.myAllConfigurations;
    }

    public void reValidateConfigurations(Processor<? super RunnerAndConfigurationSettings> existenceChecker) {
        Iterator<RunnerAndConfigurationSettings> iterator2 = this.myAllConfigurations.iterator();
        while (iterator2.hasNext()) {
            RunnerAndConfigurationSettings settings = iterator2.next();
            if (existenceChecker.process((Object)settings)) continue;
            iterator2.remove();
            this.mySharedConfigurations.remove(settings);
        }
    }

    public static class RunnerAndConfigurationSettingsComparator
    implements Comparator<RunnerAndConfigurationSettings> {
        private static final RunnerAndConfigurationSettingsComparator ourInstance = new RunnerAndConfigurationSettingsComparator();

        public static RunnerAndConfigurationSettingsComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(RunnerAndConfigurationSettings o1, RunnerAndConfigurationSettings o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }
}

