/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStartupConfigurationBase
implements PersistentStateComponent<ProjectStartupConfigurationBase> {
    @XCollection(propertyElementName="configurations")
    private List<ConfigurationDescriptor> myList = new ArrayList<ConfigurationDescriptor>();

    protected ProjectStartupConfigurationBase() {
    }

    @Nullable
    public ProjectStartupConfigurationBase getState() {
        return this;
    }

    public void loadState(@NotNull ProjectStartupConfigurationBase state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public void clear() {
        this.myList.clear();
    }

    @Transient
    public List<ConfigurationDescriptor> getList() {
        return this.myList;
    }

    public void setList(@NotNull List<? extends ConfigurationDescriptor> list2) {
        this.myList.clear();
        list2.sort(new ConfigurationDescriptorComparator());
        this.myList.addAll(list2);
    }

    public boolean isEmpty() {
        return this.myList.isEmpty();
    }

    public void setConfigurations(@NotNull Collection<? extends RunnerAndConfigurationSettings> collection) {
        List names2 = ContainerUtil.map(collection, settings -> new ConfigurationDescriptor(settings.getUniqueID(), settings.getName()));
        this.setList(names2);
    }

    public boolean deleteConfiguration(String id2) {
        List<ConfigurationDescriptor> list2 = this.getList();
        Iterator<ConfigurationDescriptor> iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            ConfigurationDescriptor descriptor2 = iterator2.next();
            if (!descriptor2.getId().equals(id2)) continue;
            iterator2.remove();
            return true;
        }
        return false;
    }

    public boolean rename(String oldId, RunnerAndConfigurationSettings settings) {
        List<ConfigurationDescriptor> list2 = this.getList();
        for (ConfigurationDescriptor descriptor2 : list2) {
            if (!descriptor2.getId().equals(oldId)) continue;
            ArrayList<ConfigurationDescriptor> newList = new ArrayList<ConfigurationDescriptor>(list2);
            newList.remove(descriptor2);
            newList.add(new ConfigurationDescriptor(settings.getUniqueID(), settings.getName()));
            this.setList(newList);
            return true;
        }
        return false;
    }

    private static class ConfigurationDescriptorComparator
    implements Comparator<ConfigurationDescriptor> {
        private ConfigurationDescriptorComparator() {
        }

        @Override
        public int compare(ConfigurationDescriptor o1, ConfigurationDescriptor o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }

    @Tag(value="configuration")
    public static class ConfigurationDescriptor {
        private String myId;
        private String myName;

        public ConfigurationDescriptor() {
        }

        public ConfigurationDescriptor(@NotNull String id2, @NotNull String name) {
            this.myId = id2;
            this.myName = name;
        }

        @Attribute(value="id")
        public String getId() {
            return this.myId;
        }

        @Attribute(value="name")
        public String getName() {
            return this.myName;
        }

        public void setId(String id2) {
            this.myId = id2;
        }

        public void setName(String name) {
            this.myName = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigurationDescriptor that = (ConfigurationDescriptor)o;
            if (!this.myId.equals(that.myId)) {
                return false;
            }
            return this.myName.equals(that.myName);
        }

        public int hashCode() {
            int result2 = this.myId.hashCode();
            result2 = 31 * result2 + this.myName.hashCode();
            return result2;
        }
    }
}

