/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceView;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewManagerImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import org.jetbrains.annotations.NotNull;

public class ShowServicesAction
extends ToggleAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Presentation presentation2 = e.getPresentation();
        ToolWindow toolWindow = (ToolWindow)e.getData(PlatformDataKeys.TOOL_WINDOW);
        if (toolWindow == null) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        Content content2 = toolWindow.getContentManager().getSelectedContent();
        presentation2.setEnabledAndVisible(content2 != null && content2.getComponent() instanceof ServiceView);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return true;
        }
        return ((ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)project)).isShowServicesTree();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        ((ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)project)).setShowServicesTree(state);
    }
}

