/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.RepaintLinkMouseListenerBase;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.treeStructure.Tree;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ServiceViewTreeLinkMouseListener
extends RepaintLinkMouseListenerBase<Object> {
    private final Tree myTree;

    public ServiceViewTreeLinkMouseListener(@NotNull Tree tree) {
        this.myTree = tree;
    }

    @Override
    protected void repaintComponent(MouseEvent e) {
        ExpandableItemsHandler handler2 = this.myTree.getExpandableItemsHandler();
        if (handler2.isEnabled() && !handler2.getExpandedItems().isEmpty()) {
            this.myTree.dispatchEvent((AWTEvent)new MouseEvent((Component)e.getSource(), 504, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
        }
        this.myTree.repaint();
    }

    @Override
    @Nullable
    protected Object getTagAt(@NotNull MouseEvent e) {
        TreePath path = this.myTree.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return null;
        }
        Rectangle rectangle = this.myTree.getPathBounds(path);
        if (rectangle == null) {
            return null;
        }
        int dx = e.getX() - rectangle.x;
        Object treeNode = path.getLastPathComponent();
        int row = this.myTree.getRowForLocation(e.getX(), e.getY());
        boolean isLeaf = this.myTree.getModel().isLeaf(treeNode);
        Component component2 = this.myTree.getCellRenderer().getTreeCellRendererComponent((JTree)this.myTree, treeNode, true, false, isLeaf, row, true);
        return component2 instanceof ColoredTreeCellRenderer ? ((ColoredTreeCellRenderer)component2).getFragmentTagAt(dx) : null;
    }

    @Override
    protected boolean isEnabled() {
        return this.myTree.getRowCount() > 0;
    }
}

