/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceModelFilter;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Condition;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ServiceViewModel
implements Disposable,
InvokerSupplier,
ServiceModel.ServiceModelEventListener {
    protected final ServiceModel myModel;
    protected final ServiceModelFilter myModelFilter;
    private final ServiceModelFilter.ServiceViewFilter myFilter;
    private final List<ServiceViewModelListener> myListeners = new CopyOnWriteArrayList<ServiceViewModelListener>();
    private volatile boolean myShowGroups;
    private volatile boolean myShowContributorRoots;

    protected ServiceViewModel(@NotNull ServiceModel model, @NotNull ServiceModelFilter modelFilter, @NotNull ServiceModelFilter.ServiceViewFilter filter2) {
        this.myModel = model;
        this.myModelFilter = modelFilter;
        this.myFilter = filter2;
        this.myModel.addEventListener(this);
    }

    @NotNull
    List<? extends ServiceModel.ServiceViewItem> getRoots() {
        return this.getRoots(false);
    }

    @NotNull
    List<? extends ServiceModel.ServiceViewItem> getVisibleRoots() {
        return this.getRoots(true);
    }

    @NotNull
    private List<? extends ServiceModel.ServiceViewItem> getRoots(boolean visible) {
        List roots = this.processGroups(this.doGetRoots(), visible);
        if (roots.stream().anyMatch(ServiceModel.ContributorNode.class::isInstance)) {
            roots = this.myShowContributorRoots ? ContainerUtil.filter(roots, item -> !(item instanceof ServiceModel.ContributorNode) || !this.getChildren((ServiceModel.ServiceViewItem)item, visible).isEmpty()) : roots.stream().flatMap(item -> item instanceof ServiceModel.ContributorNode ? this.getChildren((ServiceModel.ServiceViewItem)item, visible).stream() : Stream.of(item)).collect(Collectors.toList());
        }
        return roots;
    }

    @NotNull
    protected abstract List<? extends ServiceModel.ServiceViewItem> doGetRoots();

    void saveState(ServiceViewState viewState) {
        viewState.groupByServiceGroups = this.myShowGroups;
        viewState.groupByContributor = this.myShowContributorRoots;
    }

    void filtersChanged() {
        this.notifyListeners();
    }

    @NotNull
    ServiceModelFilter.ServiceViewFilter getFilter() {
        return this.myFilter;
    }

    @NotNull
    List<? extends ServiceModel.ServiceViewItem> getChildren(@NotNull ServiceModel.ServiceViewItem parent) {
        return this.getChildren(parent, true);
    }

    @NotNull
    protected List<? extends ServiceModel.ServiceViewItem> getChildren(@NotNull ServiceModel.ServiceViewItem parent, boolean visible) {
        return this.processGroups(this.myModelFilter.filter(parent.getChildren(), this.myFilter), visible);
    }

    @Nullable
    protected ServiceModel.ServiceViewItem findItem(@NotNull ServiceModel.ServiceViewItem item) {
        ServiceModel.ServiceViewItem updatedItem = ServiceViewModel.findItem(item, this.myModel.getRoots());
        if (updatedItem != null) {
            return updatedItem;
        }
        return this.myModel.findItem(item.getValue(), item.getRootContributor().getClass());
    }

    void addModelListener(@NotNull ServiceViewModelListener listener2) {
        this.myListeners.add(listener2);
    }

    void removeModelListener(@NotNull ServiceViewModelListener listener2) {
        this.myListeners.remove(listener2);
    }

    boolean isGroupByServiceGroups() {
        return this.myShowGroups;
    }

    void setGroupByServiceGroups(boolean value2) {
        if (this.myShowGroups != value2) {
            this.myShowGroups = value2;
            this.notifyListeners();
        }
    }

    boolean isGroupByContributor() {
        return this.myShowContributorRoots;
    }

    void setGroupByContributor(boolean value2) {
        if (this.myShowContributorRoots != value2) {
            this.myShowContributorRoots = value2;
            this.notifyListeners();
        }
    }

    protected void notifyListeners(ServiceEventListener.ServiceEvent e) {
        for (ServiceViewModelListener listener2 : this.myListeners) {
            listener2.eventProcessed(e);
        }
    }

    protected void notifyListeners() {
        for (ServiceViewModelListener listener2 : this.myListeners) {
            listener2.structureChanged();
        }
    }

    public void dispose() {
        this.myModel.removeEventListener(this);
    }

    @Override
    @NotNull
    public Invoker getInvoker() {
        return this.myModel.getInvoker();
    }

    public void initRootsIfNeeded() {
    }

    @NotNull
    private List<? extends ServiceModel.ServiceViewItem> processGroups(@NotNull List<? extends ServiceModel.ServiceViewItem> items, boolean visible) {
        if (visible) {
            items = ContainerUtil.filter(items, item -> item.getViewDescriptor().isVisible());
        }
        if (this.myShowGroups) {
            return this.filterEmptyGroups(items, visible);
        }
        return items.stream().flatMap(item -> item instanceof ServiceModel.ServiceGroupNode ? this.getChildren((ServiceModel.ServiceViewItem)item, visible).stream() : Stream.of(item)).collect(Collectors.toList());
    }

    @NotNull
    private List<? extends ServiceModel.ServiceViewItem> filterEmptyGroups(@NotNull List<? extends ServiceModel.ServiceViewItem> items, boolean visible) {
        return ContainerUtil.filter(items, item -> !(item instanceof ServiceModel.ServiceGroupNode) || !this.filterEmptyGroups(this.getChildren((ServiceModel.ServiceViewItem)item, visible), visible).isEmpty());
    }

    static ServiceViewModel createModel(@NotNull List<ServiceModel.ServiceViewItem> items, @Nullable ServiceViewContributor<?> contributor, @NotNull ServiceModel model, @NotNull ServiceModelFilter modelFilter, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
        if (contributor != null && items.size() > 1) {
            ServiceModel.ServiceViewItem contributorRoot = null;
            for (ServiceModel.ServiceViewItem serviceViewItem : model.getRoots()) {
                if (contributor != serviceViewItem.getContributor()) continue;
                contributorRoot = serviceViewItem;
                break;
            }
            if (contributorRoot != null && contributorRoot.getChildren().equals(items)) {
                return new ContributorModel(model, modelFilter, contributor, parentFilter);
            }
        }
        if (items.size() == 1) {
            AtomicReference<ServiceModel.ServiceViewItem> ref;
            ServiceModel.ServiceViewItem item = items.get(0);
            if (item instanceof ServiceModel.ContributorNode) {
                return new ContributorModel(model, modelFilter, item.getContributor(), parentFilter);
            }
            if (item instanceof ServiceModel.ServiceGroupNode) {
                ref = new AtomicReference<ServiceModel.ServiceGroupNode>((ServiceModel.ServiceGroupNode)item);
                return new GroupModel(model, modelFilter, ref, parentFilter);
            }
            if (item.getChildren().isEmpty()) {
                ref = new AtomicReference<ServiceModel.ServiceViewItem>(item);
                return new SingeServiceModel(model, modelFilter, ref, parentFilter);
            }
        }
        return new ServiceListModel(model, modelFilter, items, parentFilter);
    }

    @Nullable
    static ServiceViewModel loadModel(@NotNull ServiceViewState viewState, @NotNull ServiceModel model, @NotNull ServiceModelFilter modelFilter, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter, @NotNull Map<String, ServiceViewContributor<?>> contributors) {
        switch (viewState.viewType) {
            case "contributor": {
                ServiceViewState.ServiceState serviceState = (ServiceViewState.ServiceState)ContainerUtil.getOnlyItem(viewState.roots);
                ServiceViewContributor<?> contributor = serviceState == null ? null : contributors.get(serviceState.contributor);
                return contributor == null ? null : new ContributorModel(model, modelFilter, contributor, parentFilter);
            }
            case "group": {
                ServiceViewContributor<?> contributor;
                ServiceViewState.ServiceState serviceState = (ServiceViewState.ServiceState)ContainerUtil.getOnlyItem(viewState.roots);
                ServiceViewContributor<?> serviceViewContributor = contributor = serviceState == null ? null : contributors.get(serviceState.contributor);
                if (contributor == null) {
                    return null;
                }
                ServiceModel.ServiceViewItem groupItem = model.findItemById(serviceState.path, contributor);
                if (!(groupItem instanceof ServiceModel.ServiceGroupNode)) {
                    return null;
                }
                AtomicReference<ServiceModel.ServiceGroupNode> ref = new AtomicReference<ServiceModel.ServiceGroupNode>((ServiceModel.ServiceGroupNode)groupItem);
                return new GroupModel(model, modelFilter, ref, parentFilter);
            }
            case "service": {
                ServiceViewContributor<?> contributor;
                ServiceViewState.ServiceState serviceState = (ServiceViewState.ServiceState)ContainerUtil.getOnlyItem(viewState.roots);
                ServiceViewContributor<?> serviceViewContributor = contributor = serviceState == null ? null : contributors.get(serviceState.contributor);
                if (contributor == null) {
                    return null;
                }
                ServiceModel.ServiceViewItem serviceItem = model.findItemById(serviceState.path, contributor);
                if (serviceItem == null) {
                    return null;
                }
                if (serviceItem.getChildren().isEmpty()) {
                    AtomicReference<ServiceModel.ServiceViewItem> ref = new AtomicReference<ServiceModel.ServiceViewItem>(serviceItem);
                    return new SingeServiceModel(model, modelFilter, ref, parentFilter);
                }
                new ServiceListModel(model, modelFilter, (List<ServiceModel.ServiceViewItem>)new SmartList((Object)serviceItem), parentFilter);
            }
            case "services": {
                ArrayList<ServiceModel.ServiceViewItem> items = new ArrayList<ServiceModel.ServiceViewItem>();
                for (ServiceViewState.ServiceState serviceState : viewState.roots) {
                    ServiceViewContributor<?> contributor = contributors.get(serviceState.contributor);
                    if (contributor == null) continue;
                    ContainerUtil.addIfNotNull(items, (Object)model.findItemById(serviceState.path, contributor));
                }
                return items.isEmpty() ? null : new ServiceListModel(model, modelFilter, items, parentFilter);
            }
        }
        return null;
    }

    @Nullable
    protected static ServiceModel.ServiceViewItem findItem(ServiceModel.ServiceViewItem viewItem, List<? extends ServiceModel.ServiceViewItem> modelItems) {
        return ServiceViewModel.findItem(ServiceViewModel.getPath(viewItem), modelItems);
    }

    @Nullable
    private static ServiceModel.ServiceViewItem findItem(Deque<ServiceModel.ServiceViewItem> path, List<? extends ServiceModel.ServiceViewItem> modelItems) {
        ServiceModel.ServiceViewItem node = path.removeFirst();
        for (ServiceModel.ServiceViewItem serviceViewItem : modelItems) {
            if (!serviceViewItem.equals(node)) continue;
            if (path.isEmpty()) {
                return serviceViewItem;
            }
            return ServiceViewModel.findItem(path, serviceViewItem.getChildren());
        }
        return null;
    }

    protected static Deque<ServiceModel.ServiceViewItem> getPath(ServiceModel.ServiceViewItem item) {
        LinkedList<ServiceModel.ServiceViewItem> path = new LinkedList<ServiceModel.ServiceViewItem>();
        do {
            path.addFirst(item);
        } while ((item = item.getParent()) != null);
        return path;
    }

    @Nullable
    private static List<String> getIdPath(@Nullable ServiceModel.ServiceViewItem item) {
        ArrayList<String> path = new ArrayList<String>();
        while (item != null) {
            String id2 = item.getViewDescriptor().getId();
            if (id2 == null) {
                return null;
            }
            path.add(id2);
            item = item.getParent();
        }
        Collections.reverse(path);
        return path;
    }

    @Nullable
    private static ServiceViewState.ServiceState getState(@Nullable ServiceModel.ServiceViewItem item) {
        if (item == null) {
            return null;
        }
        List<String> path = ServiceViewModel.getIdPath(item);
        if (path == null) {
            return null;
        }
        ServiceViewState.ServiceState serviceState = new ServiceViewState.ServiceState();
        serviceState.contributor = item.getRootContributor().getClass().getName();
        serviceState.path = path;
        return serviceState;
    }

    static class ServiceListModel
    extends ServiceViewModel {
        private static final String TYPE = "services";
        private final List<ServiceModel.ServiceViewItem> myRoots;

        ServiceListModel(@NotNull ServiceModel model, @NotNull ServiceModelFilter modelFilter, final @NotNull List<ServiceModel.ServiceViewItem> roots, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
            super(model, modelFilter, new ServiceModelFilter.ServiceViewFilter(parentFilter){

                public boolean value(ServiceModel.ServiceViewItem item) {
                    return roots.contains(item);
                }
            });
            this.myRoots = roots;
        }

        @Override
        @NotNull
        protected List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            return this.myModelFilter.filter(this.myRoots, this.getFilter());
        }

        @Override
        public void eventProcessed(ServiceEventListener.ServiceEvent e) {
            boolean update2 = false;
            ArrayList<ServiceModel.ServiceViewItem> toRemove2 = new ArrayList<ServiceModel.ServiceViewItem>();
            for (int i2 = 0; i2 < this.myRoots.size(); ++i2) {
                ServiceModel.ServiceViewItem node = this.myRoots.get(i2);
                if (!e.contributorClass.isInstance(node.getRootContributor())) continue;
                ServiceModel.ServiceViewItem updatedNode = this.findItem(node);
                if (updatedNode != null) {
                    this.myRoots.remove(i2);
                    this.myRoots.add(i2, updatedNode);
                } else {
                    toRemove2.add(node);
                }
                update2 = true;
            }
            this.myRoots.removeAll(toRemove2);
            if (update2) {
                this.notifyListeners(e);
            }
        }

        @Override
        void saveState(ServiceViewState viewState) {
            super.saveState(viewState);
            viewState.viewType = TYPE;
            for (ServiceModel.ServiceViewItem root : this.myRoots) {
                ContainerUtil.addIfNotNull(viewState.roots, (Object)ServiceViewModel.getState(root));
            }
        }

        List<ServiceModel.ServiceViewItem> getItems() {
            return this.myRoots;
        }
    }

    static class SingeServiceModel
    extends ServiceViewModel {
        private static final String TYPE = "service";
        private final AtomicReference<ServiceModel.ServiceViewItem> myServiceRef;

        SingeServiceModel(@NotNull ServiceModel model, @NotNull ServiceModelFilter modelFilter, final @NotNull AtomicReference<ServiceModel.ServiceViewItem> serviceRef, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
            super(model, modelFilter, new ServiceModelFilter.ServiceViewFilter(parentFilter){

                public boolean value(ServiceModel.ServiceViewItem item) {
                    return item.equals(serviceRef.get());
                }
            });
            this.myServiceRef = serviceRef;
        }

        @Override
        @NotNull
        protected List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            ServiceModel.ServiceViewItem service = this.myServiceRef.get();
            return service == null ? Collections.emptyList() : Collections.singletonList(service);
        }

        @Override
        public void eventProcessed(ServiceEventListener.ServiceEvent e) {
            ServiceModel.ServiceViewItem service = this.myServiceRef.get();
            if (service == null || !e.contributorClass.isInstance(service.getRootContributor())) {
                return;
            }
            this.myServiceRef.set(this.findItem(service));
            this.notifyListeners(e);
        }

        @Override
        void saveState(ServiceViewState viewState) {
            super.saveState(viewState);
            viewState.viewType = TYPE;
            ContainerUtil.addIfNotNull(viewState.roots, (Object)ServiceViewModel.getState(this.myServiceRef.get()));
        }

        ServiceModel.ServiceViewItem getService() {
            return this.myServiceRef.get();
        }
    }

    static class GroupModel
    extends ServiceViewModel {
        private static final String TYPE = "group";
        private final AtomicReference<ServiceModel.ServiceGroupNode> myGroupRef;

        GroupModel(@NotNull ServiceModel model, @NotNull ServiceModelFilter modelFilter, final @NotNull AtomicReference<ServiceModel.ServiceGroupNode> groupRef, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
            super(model, modelFilter, new ServiceModelFilter.ServiceViewFilter(parentFilter){

                public boolean value(ServiceModel.ServiceViewItem item) {
                    ServiceModel.ServiceGroupNode group = (ServiceModel.ServiceGroupNode)groupRef.get();
                    ServiceModel.ServiceViewItem parent = item.getParent();
                    return parent != null && group != null && ServiceViewModel.getPath(parent).equals(ServiceViewModel.getPath(group));
                }
            });
            this.myGroupRef = groupRef;
        }

        @Override
        @NotNull
        protected List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            ServiceModel.ServiceGroupNode group = this.myGroupRef.get();
            return group == null ? Collections.emptyList() : this.getChildren(group, false);
        }

        @Override
        public void eventProcessed(ServiceEventListener.ServiceEvent e) {
            ServiceModel.ServiceGroupNode group = this.myGroupRef.get();
            if (group == null || !e.contributorClass.isInstance(group.getRootContributor())) {
                return;
            }
            this.myGroupRef.set((ServiceModel.ServiceGroupNode)GroupModel.findItem(group, this.myModel.getRoots()));
            this.notifyListeners(e);
        }

        @Override
        void saveState(ServiceViewState viewState) {
            super.saveState(viewState);
            viewState.viewType = TYPE;
            ContainerUtil.addIfNotNull(viewState.roots, (Object)ServiceViewModel.getState(this.myGroupRef.get()));
        }

        ServiceModel.ServiceGroupNode getGroup() {
            return this.myGroupRef.get();
        }
    }

    static class ContributorModel
    extends ServiceViewModel {
        private static final String TYPE = "contributor";
        private final ServiceViewContributor<?> myContributor;

        ContributorModel(@NotNull ServiceModel model, @NotNull ServiceModelFilter modelFilter, final @NotNull ServiceViewContributor<?> contributor, @Nullable ServiceModelFilter.ServiceViewFilter parentFilter) {
            super(model, modelFilter, new ServiceModelFilter.ServiceViewFilter(parentFilter){

                public boolean value(ServiceModel.ServiceViewItem item) {
                    return contributor.equals(item.getContributor());
                }
            });
            this.myContributor = contributor;
        }

        @Override
        @NotNull
        protected List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            return this.myModelFilter.filter(ContainerUtil.filter(this.myModel.getRoots(), (Condition)this.getFilter()), this.getFilter());
        }

        @Override
        public void eventProcessed(ServiceEventListener.ServiceEvent e) {
            if (e.contributorClass.isInstance(this.myContributor)) {
                this.notifyListeners(e);
            }
        }

        @Override
        void saveState(ServiceViewState viewState) {
            super.saveState(viewState);
            viewState.viewType = TYPE;
            ServiceViewState.ServiceState serviceState = new ServiceViewState.ServiceState();
            serviceState.contributor = this.myContributor.getClass().getName();
            viewState.roots = new SmartList((Object)serviceState);
        }

        ServiceViewContributor<?> getContributor() {
            return this.myContributor;
        }
    }

    static class AllServicesModel
    extends ServiceViewModel {
        AllServicesModel(@NotNull ServiceModel model, @NotNull ServiceModelFilter modelFilter, final @NotNull Collection<ServiceViewContributor<?>> contributors) {
            super(model, modelFilter, new ServiceModelFilter.ServiceViewFilter(null){

                public boolean value(ServiceModel.ServiceViewItem item) {
                    return contributors.contains(item.getRootContributor());
                }
            });
        }

        @Override
        @NotNull
        protected List<? extends ServiceModel.ServiceViewItem> doGetRoots() {
            return this.myModelFilter.filter(ContainerUtil.filter(this.myModel.getRoots(), (Condition)this.getFilter()), this.getFilter());
        }

        @Override
        public void eventProcessed(ServiceEventListener.ServiceEvent e) {
            this.notifyListeners(e);
        }

        @Override
        public void initRootsIfNeeded() {
            this.myModel.initRoots();
        }
    }

    static interface ServiceViewModelListener {
        default public void eventProcessed(@NotNull ServiceEventListener.ServiceEvent e) {
            this.structureChanged();
        }

        public void structureChanged();
    }
}

