/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceView;
import com.intellij.execution.services.ServiceViewDragHelper;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class ServiceViewCopyProvider
implements CopyProvider {
    private final ServiceView myServiceView;

    ServiceViewCopyProvider(@NotNull ServiceView serviceView) {
        this.myServiceView = serviceView;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        List<ServiceModel.ServiceViewItem> items = this.myServiceView.getSelectedItems();
        if (!items.isEmpty()) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(StringUtil.join(items, item -> ServiceViewDragHelper.getDisplayName(item.getViewDescriptor().getPresentation()), (String)"\n")));
        }
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (this.myServiceView.getSelectedItems().isEmpty()) {
            return false;
        }
        JComponent detailsComponent = this.myServiceView.getUi().getDetailsComponent();
        return detailsComponent == null || !UIUtil.isAncestor((Component)detailsComponent, (Component)((Component)dataContext.getData(PlatformDataKeys.CONTEXT_COMPONENT)));
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        return false;
    }
}

