/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceSingleView;
import com.intellij.execution.services.ServiceTreeView;
import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewContributorDeleteProvider;
import com.intellij.execution.services.ServiceViewCopyProvider;
import com.intellij.execution.services.ServiceViewDeleteProvider;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDragHelper;
import com.intellij.execution.services.ServiceViewManagerImpl;
import com.intellij.execution.services.ServiceViewModel;
import com.intellij.execution.services.ServiceViewOptions;
import com.intellij.execution.services.ServiceViewSingleUi;
import com.intellij.execution.services.ServiceViewState;
import com.intellij.execution.services.ServiceViewTreeUi;
import com.intellij.execution.services.ServiceViewUi;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

abstract class ServiceView
extends JPanel
implements Disposable {
    private final Project myProject;
    private final ServiceViewModel myModel;
    protected final ServiceViewUi myUi;
    private AutoScrollToSourceHandler myAutoScrollToSourceHandler;

    protected ServiceView(LayoutManager layout, @NotNull Project project, @NotNull ServiceViewModel model, @NotNull ServiceViewUi ui) {
        super(layout);
        this.myProject = project;
        this.myModel = model;
        this.myUi = ui;
    }

    public void dispose() {
    }

    Project getProject() {
        return this.myProject;
    }

    ServiceViewModel getModel() {
        return this.myModel;
    }

    ServiceViewUi getUi() {
        return this.myUi;
    }

    void saveState(@NotNull ServiceViewState state) {
        this.myModel.saveState(state);
    }

    @NotNull
    abstract List<ServiceModel.ServiceViewItem> getSelectedItems();

    abstract Promise<Void> select(@NotNull Object var1, @NotNull Class<?> var2);

    abstract Promise<Void> expand(@NotNull Object var1, @NotNull Class<?> var2);

    abstract void onViewSelected();

    abstract void onViewUnselected();

    boolean isGroupByServiceGroups() {
        return this.myModel.isGroupByServiceGroups();
    }

    void setGroupByServiceGroups(boolean value2) {
        this.myModel.setGroupByServiceGroups(value2);
    }

    boolean isGroupByContributor() {
        return this.myModel.isGroupByContributor();
    }

    void setGroupByContributor(boolean value2) {
        this.myModel.setGroupByContributor(value2);
    }

    abstract List<Object> getChildrenSafe(@NotNull List<Object> var1);

    void setAutoScrollToSourceHandler(@NotNull AutoScrollToSourceHandler autoScrollToSourceHandler) {
        this.myAutoScrollToSourceHandler = autoScrollToSourceHandler;
    }

    void onViewSelected(@NotNull ServiceViewDescriptor descriptor2) {
        descriptor2.onNodeSelected();
        if (this.myAutoScrollToSourceHandler != null) {
            this.myAutoScrollToSourceHandler.onMouseClicked((Component)this);
        }
    }

    abstract void jumpToServices();

    static ServiceView createView(@NotNull Project project, @NotNull ServiceViewModel viewModel, @NotNull ServiceViewState viewState) {
        ServiceView.setViewModelState(viewModel, viewState);
        ServiceView serviceView = viewModel instanceof ServiceViewModel.SingeServiceModel ? ServiceView.createSingleView(project, viewModel) : ServiceView.createTreeView(project, viewModel, viewState);
        ServiceView.setDataProvider(serviceView);
        return serviceView;
    }

    private static ServiceView createTreeView(@NotNull Project project, @NotNull ServiceViewModel model, @NotNull ServiceViewState state) {
        return new ServiceTreeView(project, model, new ServiceViewTreeUi(state), state);
    }

    private static ServiceView createSingleView(@NotNull Project project, @NotNull ServiceViewModel model) {
        return new ServiceSingleView(project, model, new ServiceViewSingleUi());
    }

    private static void setDataProvider(final ServiceView serviceView) {
        ServiceViewOptions viewOptions = new ServiceViewOptions(){

            public boolean isGroupByContributor() {
                return serviceView.isGroupByContributor();
            }

            public boolean isGroupByServiceGroups() {
                return serviceView.isGroupByServiceGroups();
            }
        };
        serviceView.putClientProperty("DataProvider", dataId -> {
            DataProvider dataProvider;
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return ServiceViewManagerImpl.getToolWindowContextHelpId();
            }
            if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
                return ContainerUtil.map2Array(serviceView.getSelectedItems(), ServiceModel.ServiceViewItem::getValue);
            }
            if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                List navigatables = ContainerUtil.mapNotNull(serviceView.getSelectedItems(), item -> item.getViewDescriptor().getNavigatable());
                return navigatables.toArray(new Navigatable[0]);
            }
            if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
                DeleteProvider deleteProvider;
                List<ServiceModel.ServiceViewItem> selection = serviceView.getSelectedItems();
                ServiceViewContributor contributor = ServiceViewDragHelper.getTheOnlyRootContributor(selection);
                DataProvider delegate = contributor == null ? null : contributor.getViewDescriptor(serviceView.getProject()).getDataProvider();
                DeleteProvider deleteProvider2 = deleteProvider = delegate == null ? null : (DeleteProvider)PlatformDataKeys.DELETE_ELEMENT_PROVIDER.getData(delegate);
                if (deleteProvider == null) {
                    return new ServiceViewDeleteProvider(serviceView);
                }
                if (deleteProvider instanceof ServiceViewContributorDeleteProvider) {
                    ((ServiceViewContributorDeleteProvider)deleteProvider).setFallbackProvider(new ServiceViewDeleteProvider(serviceView));
                }
                return deleteProvider;
            }
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return new ServiceViewCopyProvider(serviceView);
            }
            if (ServiceViewActionUtils.CONTRIBUTORS_KEY.is(dataId)) {
                return serviceView.getModel().getRoots().stream().map(item -> item.getRootContributor()).collect(Collectors.toSet());
            }
            if (ServiceViewActionUtils.OPTIONS_KEY.is(dataId)) {
                return viewOptions;
            }
            List<ServiceModel.ServiceViewItem> selectedItems = serviceView.getSelectedItems();
            ServiceModel.ServiceViewItem selectedItem = (ServiceModel.ServiceViewItem)ContainerUtil.getOnlyItem(selectedItems);
            ServiceViewDescriptor descriptor2 = selectedItem == null || selectedItem.isRemoved() ? null : selectedItem.getViewDescriptor();
            DataProvider dataProvider2 = dataProvider = descriptor2 == null ? null : descriptor2.getDataProvider();
            if (dataProvider != null) {
                return RecursionManager.doPreventingRecursion((Object)serviceView, (boolean)false, () -> dataProvider.getData(dataId));
            }
            return null;
        });
    }

    private static void setViewModelState(@NotNull ServiceViewModel viewModel, @NotNull ServiceViewState viewState) {
        viewModel.setGroupByServiceGroups(viewState.groupByServiceGroups);
        viewModel.setGroupByContributor(viewState.groupByContributor);
    }
}

