/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.diagnostic.PluginException;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDragHelper;
import com.intellij.execution.services.ServiceViewGroupingContributor;
import com.intellij.execution.services.ServiceViewLazyContributor;
import com.intellij.execution.services.ServiceViewOptions;
import com.intellij.execution.services.ServiceViewProvidingContributor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullizer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promises;

class ServiceModel
implements Disposable,
InvokerSupplier {
    static final ExtensionPointName<ServiceViewContributor<?>> CONTRIBUTOR_EP_NAME = ExtensionPointName.create((String)"com.intellij.serviceViewContributor");
    private static final Logger LOG = Logger.getInstance(ServiceModel.class);
    static final TreeTraversal NOT_LOADED_LAST_BFS = new TreeTraversal("NOT_LOADED_LAST_BFS"){

        @NotNull
        public <T> TreeTraversal.It<T> createIterator(@NotNull Iterable<? extends T> roots, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            return new NotLoadedLastBfsIt<T>(roots, tree);
        }
    };
    private static final NotNullizer ourNotNullizer = new NotNullizer("ServiceViewTreeTraversal.NotNull");
    private final Project myProject;
    private final Invoker myInvoker = Invoker.forBackgroundThreadWithReadAction(this);
    private final List<ServiceViewItem> myRoots = new CopyOnWriteArrayList<ServiceViewItem>();
    private volatile boolean myRootsInitialized;
    private final List<ServiceModelEventListener> myListeners = new CopyOnWriteArrayList<ServiceModelEventListener>();

    ServiceModel(@NotNull Project project) {
        this.myProject = project;
    }

    public void dispose() {
    }

    @Override
    @NotNull
    public Invoker getInvoker() {
        return this.myInvoker;
    }

    void addEventListener(@NotNull ServiceModelEventListener listener2) {
        this.myListeners.add(listener2);
    }

    void removeEventListener(@NotNull ServiceModelEventListener listener2) {
        this.myListeners.remove(listener2);
    }

    @NotNull
    List<? extends ServiceViewItem> getRoots() {
        return this.myRootsInitialized ? this.myRoots : Collections.emptyList();
    }

    CancellablePromise<?> initRoots() {
        return this.getInvoker().invoke(() -> {
            if (!this.myRootsInitialized) {
                this.myRoots.addAll(this.doGetRoots());
                this.myRootsInitialized = true;
            }
        });
    }

    private List<? extends ServiceViewItem> doGetRoots() {
        ArrayList<ContributorNode> result2 = new ArrayList<ContributorNode>();
        for (ServiceViewContributor contributor : CONTRIBUTOR_EP_NAME.getExtensionList()) {
            try {
                ContributorNode root = new ContributorNode(this.myProject, contributor);
                root.loadChildren();
                if (root.getChildren().isEmpty()) continue;
                result2.add(root);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                PluginException.logPluginError((Logger)LOG, (String)("Failed to init service view contributor " + contributor.getClass()), (Throwable)e, contributor.getClass());
            }
        }
        return result2;
    }

    private JBIterable<ServiceViewItem> findItems(Object service, Class<?> contributorClass) {
        Object value2 = service instanceof ServiceViewProvidingContributor ? ((ServiceViewProvidingContributor)service).asService() : service;
        return ((JBTreeTraverser)JBTreeTraverser.from(node -> contributorClass.isInstance(node.getRootContributor()) ? new ArrayList<ServiceViewItem>(node.getChildren()) : null).withRoots(this.myRoots)).traverse(NOT_LOADED_LAST_BFS).filter(node -> node.getValue().equals(value2));
    }

    @Nullable
    ServiceViewItem findItem(Condition<? super ServiceViewItem> condition, Condition<? super ServiceViewItem> visitChildrenCondition) {
        return (ServiceViewItem)((JBTreeTraverser)JBTreeTraverser.from(node -> visitChildrenCondition.value(node) ? new ArrayList<ServiceViewItem>(node.getChildren()) : null).withRoots(this.myRoots)).traverse(NOT_LOADED_LAST_BFS).filter(condition).first();
    }

    @Nullable
    ServiceViewItem findItem(Object service, Class<?> contributorClass) {
        return (ServiceViewItem)this.findItems(service, contributorClass).first();
    }

    @Nullable
    ServiceViewItem findItemById(List<String> ids, ServiceViewContributor<?> contributor) {
        if (ids.isEmpty()) {
            return null;
        }
        List roots = ContainerUtil.filter(this.getRoots(), item -> contributor.equals(item.getContributor()));
        if (roots.isEmpty()) {
            return null;
        }
        return ServiceModel.findItemById(new LinkedList<String>(ids), roots);
    }

    private static ServiceViewItem findItemById(Deque<String> path, List<? extends ServiceViewItem> roots) {
        String id2 = path.removeFirst();
        for (ServiceViewItem serviceViewItem : roots) {
            if (!id2.equals(serviceViewItem.getViewDescriptor().getId())) continue;
            return path.isEmpty() ? serviceViewItem : ServiceModel.findItemById(path, serviceViewItem.getChildren());
        }
        return null;
    }

    @NotNull
    CancellablePromise<?> handle(@NotNull ServiceEventListener.ServiceEvent e) {
        Runnable handler2 = () -> {
            LOG.debug("Handle event: " + e);
            switch (e.type) {
                case SERVICE_ADDED: {
                    this.addService(e);
                    break;
                }
                case SERVICE_REMOVED: {
                    this.removeService(e);
                    break;
                }
                case SERVICE_CHANGED: {
                    this.serviceChanged(e);
                    break;
                }
                case SERVICE_STRUCTURE_CHANGED: {
                    this.serviceStructureChanged(e);
                    break;
                }
                case SERVICE_GROUP_CHANGED: {
                    this.serviceGroupChanged(e);
                    break;
                }
                case GROUP_CHANGED: {
                    this.groupChanged(e);
                    break;
                }
                default: {
                    this.reset(e.contributorClass);
                }
            }
            for (ServiceModelEventListener listener2 : this.myListeners) {
                listener2.eventProcessed(e);
            }
        };
        if (e.type != ServiceEventListener.EventType.SYNC_RESET) {
            return this.getInvoker().invoke(handler2);
        }
        handler2.run();
        return Promises.resolvedCancellablePromise(null);
    }

    private void reset(Class<?> contributorClass) {
        int index = -1;
        if (this.myRoots.isEmpty()) {
            index = 0;
        } else {
            ServiceViewItem contributorNode = null;
            for (int i2 = 0; i2 < this.myRoots.size(); ++i2) {
                ServiceViewItem child2 = this.myRoots.get(i2);
                if (!contributorClass.isInstance(child2.getContributor())) continue;
                contributorNode = child2;
                index = i2;
                break;
            }
            if (contributorNode != null) {
                this.myRoots.remove(contributorNode);
            } else {
                index = this.getContributorNodeIndex(contributorClass);
            }
        }
        ContributorNode newRoot = null;
        for (ServiceViewContributor contributor : CONTRIBUTOR_EP_NAME.getExtensionList()) {
            if (!contributorClass.isInstance(contributor)) continue;
            newRoot = new ContributorNode(this.myProject, contributor);
            newRoot.loadChildren();
            if (!newRoot.getChildren().isEmpty()) break;
            newRoot = null;
            break;
        }
        if (newRoot != null) {
            this.myRoots.add(index, newRoot);
        }
    }

    private int getContributorNodeIndex(Class<?> contributorClass) {
        ServiceViewContributor contributor;
        int index = -1;
        List contributors = CONTRIBUTOR_EP_NAME.getExtensionList();
        List existingContributors = ContainerUtil.map(this.myRoots, ServiceViewItem::getContributor);
        for (int i2 = contributors.size() - 1; i2 >= 0 && !contributorClass.isInstance(contributor = (ServiceViewContributor)contributors.get(i2)) && (index = existingContributors.indexOf(contributor)) != 0; --i2) {
        }
        if (index < 0) {
            index = this.myRoots.size();
        }
        return index;
    }

    private void addService(ServiceEventListener.ServiceEvent e) {
        ServiceViewItem item = this.findItem(e.target, e.contributorClass);
        if (item != null) {
            return;
        }
        if (e.parent != null) {
            ServiceViewContributor<?> parentContributor;
            ServiceViewItem parent = this.findItem(e.parent, e.contributorClass);
            ServiceViewContributor<?> serviceViewContributor = parentContributor = parent instanceof ServiceNode ? ((ServiceNode)parent).getProvidingContributor() : null;
            if (parentContributor == null) {
                return;
            }
            ServiceModel.addService(e.target, parent.getChildren(), this.myProject, parent, parentContributor);
            return;
        }
        ServiceViewItem contributorNode = null;
        for (ServiceViewItem child2 : this.myRoots) {
            if (!e.contributorClass.isInstance(child2.getContributor())) continue;
            contributorNode = child2;
            break;
        }
        if (contributorNode == null) {
            int index = this.getContributorNodeIndex(e.contributorClass);
            for (ServiceViewContributor contributor : CONTRIBUTOR_EP_NAME.getExtensionList()) {
                if (!e.contributorClass.isInstance(contributor)) continue;
                contributorNode = new ContributorNode(this.myProject, contributor);
                this.myRoots.add(index, contributorNode);
                break;
            }
            if (contributorNode == null) {
                return;
            }
        }
        ServiceModel.addService(e.target, contributorNode.getChildren(), this.myProject, contributorNode, contributorNode.getContributor());
    }

    private void removeService(ServiceEventListener.ServiceEvent e) {
        ServiceViewItem item = this.findItem(e.target, e.contributorClass);
        if (item == null) {
            return;
        }
        ServiceViewItem parent = item.getParent();
        while (parent instanceof ServiceGroupNode) {
            item.markRemoved();
            parent.getChildren().remove(item);
            if (!parent.getChildren().isEmpty()) {
                return;
            }
            item = parent;
            parent = parent.getParent();
        }
        if (parent instanceof ContributorNode) {
            item.markRemoved();
            parent.getChildren().remove(item);
            if (!parent.getChildren().isEmpty()) {
                return;
            }
            item = parent;
            parent = parent.getParent();
        }
        item.markRemoved();
        if (parent == null) {
            this.myRoots.remove(item);
        } else {
            parent.getChildren().remove(item);
        }
    }

    private void serviceChanged(ServiceEventListener.ServiceEvent e) {
        ServiceViewItem item = this.findItem(e.target, e.contributorClass);
        if (item instanceof ServiceNode) {
            ServiceModel.updateServiceViewDescriptor((ServiceNode)item, e.target);
        }
    }

    private static void updateServiceViewDescriptor(ServiceNode node, Object target2) {
        ServiceViewContributor<?> providingContributor = node.getProvidingContributor();
        if (providingContributor != null && !providingContributor.equals(target2)) {
            ((ServiceViewItem)node).setViewDescriptor(providingContributor.getViewDescriptor(node.myProject));
            return;
        }
        ServiceViewDescriptor viewDescriptor = node.getContributor().getServiceDescriptor(node.myProject, target2);
        ((ServiceViewItem)node).setViewDescriptor(viewDescriptor);
    }

    private void serviceStructureChanged(ServiceEventListener.ServiceEvent e) {
        ServiceViewItem item = this.findItem(e.target, e.contributorClass);
        if (item instanceof ServiceNode) {
            ServiceNode node = (ServiceNode)item;
            ServiceModel.updateServiceViewDescriptor(node, e.target);
            node.reloadChildren();
        }
    }

    private void serviceGroupChanged(ServiceEventListener.ServiceEvent e) {
        ServiceViewItem item = this.findItem(e.target, e.contributorClass);
        if (!(item instanceof ServiceNode)) {
            return;
        }
        ServiceViewItem parent = item.getParent();
        if (parent == null) {
            return;
        }
        ServiceGroupNode group = null;
        if (parent instanceof ServiceGroupNode) {
            group = (ServiceGroupNode)parent;
            parent = group.getParent();
            while (parent instanceof ServiceGroupNode) {
                parent = parent.getParent();
            }
            if (parent == null) {
                return;
            }
        }
        if (group != null) {
            group.getChildren().remove(item);
        } else {
            parent.getChildren().remove(item);
        }
        ServiceViewContributor<?> value2 = e.target;
        ServiceViewContributor<?> providingContributor = ((ServiceNode)item).getProvidingContributor();
        if (providingContributor != null && !providingContributor.equals(e.target)) {
            value2 = providingContributor;
        }
        ServiceNode serviceNode = ServiceModel.addService(value2, parent.getChildren(), this.myProject, parent, item.getContributor());
        serviceNode.moveChildren((ServiceNode)item);
        while (group != null && group.getChildren().isEmpty()) {
            ServiceViewItem groupParent = group.getParent();
            if (groupParent == null) {
                return;
            }
            groupParent.getChildren().remove(group);
            group = groupParent instanceof ServiceGroupNode ? (ServiceGroupNode)groupParent : null;
        }
    }

    private void groupChanged(ServiceEventListener.ServiceEvent e) {
        JBIterable groups = this.findItems(e.target, e.contributorClass).filter(ServiceGroupNode.class);
        ServiceGroupNode first = (ServiceGroupNode)groups.first();
        if (first == null) {
            return;
        }
        ServiceViewDescriptor viewDescriptor = ((ServiceViewGroupingContributor)first.getContributor()).getGroupDescriptor(e.target);
        for (ServiceViewItem group : groups) {
            group.setViewDescriptor(viewDescriptor);
            ServiceViewItem parent = group.getParent();
            if (parent == null) continue;
            List<ServiceViewItem> children2 = parent.getChildren();
            children2.remove(group);
            ServiceModel.addGroupOrdered(children2, (ServiceGroupNode)group);
        }
    }

    private static <T> List<ServiceViewItem> getContributorChildren(Project project, ServiceViewItem parent, ServiceViewContributor<T> contributor) {
        ArrayList<ServiceViewItem> children2 = new ArrayList<ServiceViewItem>();
        try {
            for (Object service : contributor.getServices(project)) {
                ServiceModel.addService(service, children2, project, parent, contributor);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            PluginException.logPluginError((Logger)LOG, (String)("Failed to retrieve service view contributor children " + contributor.getClass()), (Throwable)e, contributor.getClass());
        }
        return children2;
    }

    private static <T> ServiceNode addService(Object service, List<ServiceViewItem> children2, Project project, ServiceViewItem parent, ServiceViewContributor<T> contributor) {
        ServiceNode serviceNode;
        Object value2;
        Object typedService = service;
        Object object = value2 = service instanceof ServiceViewProvidingContributor ? ((ServiceViewProvidingContributor)service).asService() : service;
        if (contributor instanceof ServiceViewGroupingContributor && (serviceNode = ServiceModel.addGroupNode((ServiceViewGroupingContributor)contributor, typedService, value2, parent, project, children2)) != null) {
            return serviceNode;
        }
        serviceNode = new ServiceNode(value2, parent, contributor, contributor.getServiceDescriptor(project, typedService), project, service instanceof ServiceViewContributor ? (ServiceViewContributor)service : null);
        ServiceModel.addServiceOrdered(children2, serviceNode, contributor);
        return serviceNode;
    }

    private static <T, G> ServiceNode addGroupNode(ServiceViewGroupingContributor<T, G> groupingContributor, T service, Object value2, ServiceViewItem parent, Project project, List<ServiceViewItem> children2) {
        List groups = groupingContributor.getGroups(service);
        if (groups.isEmpty()) {
            return null;
        }
        List<ServiceViewItem> currentChildren = children2;
        ServiceViewItem groupParent = parent;
        for (Object group : groups) {
            boolean found = false;
            for (ServiceViewItem child2 : currentChildren) {
                if (!child2.getValue().equals(group)) continue;
                groupParent = child2;
                currentChildren = groupParent.getChildren();
                found = true;
                break;
            }
            if (found) continue;
            ServiceGroupNode groupNode = new ServiceGroupNode(group, groupParent, (ServiceViewContributor<?>)groupingContributor, groupingContributor.getGroupDescriptor(group));
            ServiceModel.addGroupOrdered(currentChildren, groupNode);
            groupParent = groupNode;
            currentChildren = groupParent.getChildren();
        }
        ServiceNode serviceNode = new ServiceNode(value2, groupParent, (ServiceViewContributor<?>)groupingContributor, groupingContributor.getServiceDescriptor(project, service), project, (ServiceViewContributor<?>)(service instanceof ServiceViewContributor ? (ServiceViewContributor)service : null));
        ServiceModel.addServiceOrdered(currentChildren, serviceNode, groupingContributor);
        return serviceNode;
    }

    private static void addServiceOrdered(List<ServiceViewItem> children2, ServiceNode child2, ServiceViewContributor<?> contributor) {
        if (!children2.isEmpty() && contributor instanceof Comparator) {
            Comparator comparator2 = (Comparator)contributor;
            for (int i2 = 0; i2 < children2.size(); ++i2) {
                ServiceViewItem anchor2 = children2.get(i2);
                if (!(anchor2 instanceof ServiceNode) || comparator2.compare(child2.getService(), ((ServiceNode)anchor2).getService()) >= 0) continue;
                children2.add(i2, child2);
                return;
            }
        }
        children2.add(child2);
    }

    private static void addGroupOrdered(List<ServiceViewItem> children2, ServiceGroupNode child2) {
        if (!children2.isEmpty()) {
            for (int i2 = 0; i2 < children2.size(); ++i2) {
                ServiceViewItem anchor2 = children2.get(i2);
                if (anchor2 instanceof ServiceNode) {
                    children2.add(i2, child2);
                    return;
                }
                if (!(anchor2 instanceof ServiceGroupNode) || ServiceModel.compareGroups(child2, (ServiceGroupNode)anchor2) >= 0) continue;
                children2.add(i2, child2);
                return;
            }
        }
        children2.add(child2);
    }

    private static int compareGroups(ServiceGroupNode group1, ServiceGroupNode group2) {
        ServiceViewDescriptor groupDescriptor1 = group1.getViewDescriptor();
        WeighedItem weighedItem1 = (WeighedItem)ObjectUtils.tryCast((Object)groupDescriptor1, WeighedItem.class);
        ServiceViewDescriptor groupDescriptor2 = group2.getViewDescriptor();
        WeighedItem weighedItem2 = (WeighedItem)ObjectUtils.tryCast((Object)groupDescriptor2, WeighedItem.class);
        if (weighedItem1 != null) {
            if (weighedItem2 == null) {
                return -1;
            }
            int diff = weighedItem1.getWeight() - weighedItem2.getWeight();
            if (diff != 0) {
                return diff;
            }
        } else if (weighedItem2 != null) {
            return 1;
        }
        String name1 = ServiceViewDragHelper.getDisplayName(groupDescriptor1.getPresentation());
        String name2 = ServiceViewDragHelper.getDisplayName(groupDescriptor2.getPresentation());
        return StringUtil.naturalCompare((String)name1, (String)name2);
    }

    private static final class NotLoadedLastBfsIt<T>
    extends TreeTraversal.It<T> {
        Deque<T> myQueue = new ArrayDeque<T>();
        Deque<T> myNotLoadedQueue = new ArrayDeque<T>();
        T myTop;

        NotLoadedLastBfsIt(@NotNull Iterable<? extends T> roots, Function<? super T, ? extends Iterable<? extends T>> tree) {
            super(tree);
            JBIterable.from(roots).map(arg_0 -> ((NotNullizer)ourNotNullizer).notNullize(arg_0)).addAllTo(this.myQueue);
        }

        public T nextImpl() {
            if (this.myTop != null) {
                if (this.myTop instanceof ServiceNode && !((ServiceNode)this.myTop).isChildrenInitialized() && !((ServiceNode)this.myTop).isLoaded()) {
                    this.myNotLoadedQueue.add(this.myTop);
                } else {
                    Iterable iterable = (Iterable)this.tree.fun(this.myTop);
                    if (iterable != null) {
                        JBIterable.from((Iterable)iterable).map(arg_0 -> ((NotNullizer)ourNotNullizer).notNullize(arg_0)).addAllTo(this.myQueue);
                    }
                }
                this.myTop = null;
            }
            while (!this.myNotLoadedQueue.isEmpty() && this.myQueue.isEmpty()) {
                T notLoaded = this.myNotLoadedQueue.remove();
                Iterable iterable = (Iterable)this.tree.fun(notLoaded);
                if (iterable == null) continue;
                JBIterable.from((Iterable)iterable).map(arg_0 -> ((NotNullizer)ourNotNullizer).notNullize(arg_0)).addAllTo(this.myQueue);
            }
            if (this.myQueue.isEmpty()) {
                return (T)this.stop();
            }
            this.myTop = ourNotNullizer.nullize(this.myQueue.remove());
            return this.myTop;
        }
    }

    static interface ServiceModelEventListener {
        public void eventProcessed(ServiceEventListener.ServiceEvent var1);
    }

    static class ServiceGroupNode
    extends ServiceViewItem {
        ServiceGroupNode(@NotNull Object group, @Nullable ServiceViewItem parent, @NotNull ServiceViewContributor<?> contributor, @NotNull ServiceViewDescriptor viewDescriptor) {
            super(group, parent, contributor, viewDescriptor);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceGroupNode node = (ServiceGroupNode)o;
            return this.getValue().equals(node.getValue()) && Comparing.equal((Object)this.getParent(), (Object)node.getParent());
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            ServiceViewItem parent = this.getParent();
            result2 = 31 * result2 + (parent != null ? parent.hashCode() : 0);
            return result2;
        }
    }

    static class ServiceNode
    extends ServiceViewItem {
        private final Project myProject;
        private final ServiceViewContributor<?> myProvidingContributor;
        private volatile boolean myChildrenInitialized;
        private volatile boolean myLoaded;

        ServiceNode(@NotNull Object service, @Nullable ServiceViewItem parent, @NotNull ServiceViewContributor<?> contributor, @NotNull ServiceViewDescriptor viewDescriptor, @NotNull Project project, @Nullable ServiceViewContributor<?> providingContributor) {
            super(service, parent, contributor, viewDescriptor);
            this.myProject = project;
            this.myProvidingContributor = providingContributor;
            this.myChildrenInitialized = providingContributor == null;
            this.myLoaded = !(providingContributor instanceof ServiceViewLazyContributor);
        }

        @Override
        @NotNull
        List<ServiceViewItem> getChildren() {
            List<ServiceViewItem> children2 = super.getChildren();
            if (!this.myChildrenInitialized) {
                if (this.myProvidingContributor != null) {
                    children2.addAll(ServiceModel.getContributorChildren(this.myProject, this, this.myProvidingContributor));
                }
                this.myChildrenInitialized = true;
                this.myLoaded = true;
            }
            return children2;
        }

        boolean isChildrenInitialized() {
            return this.myChildrenInitialized;
        }

        boolean isLoaded() {
            return this.myLoaded;
        }

        private void reloadChildren() {
            super.getChildren().clear();
            if (this.myProvidingContributor != null) {
                this.myChildrenInitialized = false;
                this.myLoaded = true;
            }
        }

        private void moveChildren(ServiceNode node) {
            List<ServiceViewItem> children2 = super.getChildren();
            children2.clear();
            List nodeChildren = ((ServiceViewItem)node).myChildren;
            children2.addAll(nodeChildren);
            nodeChildren.clear();
            for (ServiceViewItem child2 : children2) {
                child2.setParent((ServiceViewItem)this);
            }
            this.myChildrenInitialized = node.myChildrenInitialized;
            this.myLoaded = node.myLoaded;
        }

        @Nullable
        ServiceViewContributor<?> getProvidingContributor() {
            return this.myProvidingContributor;
        }

        @NotNull
        private Object getService() {
            return this.myProvidingContributor != null ? this.myProvidingContributor : this.getValue();
        }
    }

    static class ContributorNode
    extends ServiceViewItem {
        private final Project myProject;

        ContributorNode(@NotNull Project project, @NotNull ServiceViewContributor<?> contributor) {
            super(contributor, null, contributor, contributor.getViewDescriptor(project));
            this.myProject = project;
        }

        private void loadChildren() {
            List<ServiceViewItem> children2 = this.getChildren();
            if (!children2.isEmpty()) {
                children2.clear();
            }
            children2.addAll(ServiceModel.getContributorChildren(this.myProject, this, this.getContributor()));
        }
    }

    static abstract class ServiceViewItem
    implements ColoredItem {
        private final Object myValue;
        private volatile ServiceViewItem myParent;
        private final ServiceViewContributor<?> myContributor;
        private ServiceViewDescriptor myViewDescriptor;
        private final List<ServiceViewItem> myChildren = new CopyOnWriteArrayList<ServiceViewItem>();
        private volatile boolean myPresentationUpdated;
        private volatile boolean myRemoved;
        private PresentationData myPresentation;

        protected ServiceViewItem(@NotNull Object value2, @Nullable ServiceViewItem parent, @NotNull ServiceViewContributor<?> contributor, @NotNull ServiceViewDescriptor viewDescriptor) {
            this.myValue = value2;
            this.myParent = parent;
            this.myContributor = contributor;
            this.myViewDescriptor = viewDescriptor;
        }

        @NotNull
        Object getValue() {
            return this.myValue;
        }

        @NotNull
        ServiceViewContributor<?> getContributor() {
            return this.myContributor;
        }

        @NotNull
        ServiceViewContributor<?> getRootContributor() {
            return this.myParent == null ? this.myContributor : this.myParent.getRootContributor();
        }

        @NotNull
        ServiceViewDescriptor getViewDescriptor() {
            if (!this.myPresentationUpdated) {
                this.myPresentationUpdated = true;
                if (this.myValue instanceof NodeDescriptor) {
                    ((NodeDescriptor)this.myValue).update();
                }
            }
            return this.myViewDescriptor;
        }

        private void setViewDescriptor(@NotNull ServiceViewDescriptor viewDescriptor) {
            AppUIUtil.invokeOnEdt(() -> {
                this.myViewDescriptor = viewDescriptor;
                this.myPresentationUpdated = false;
            });
        }

        @Nullable
        ServiceViewItem getParent() {
            return this.myParent;
        }

        private void setParent(@Nullable ServiceViewItem parent) {
            this.myParent = parent;
        }

        @NotNull
        List<ServiceViewItem> getChildren() {
            return this.myChildren;
        }

        @Nullable
        public Color getColor() {
            ServiceViewDescriptor descriptor2 = this.getViewDescriptor();
            return descriptor2 instanceof ColoredItem ? ((ColoredItem)descriptor2).getColor() : null;
        }

        private void markRemoved() {
            this.myRemoved = true;
        }

        boolean isRemoved() {
            return this.myRemoved || this.myParent != null && this.myParent.isRemoved();
        }

        ItemPresentation getItemPresentation(@Nullable ServiceViewOptions viewOptions) {
            if (this.isRemoved()) {
                return this.myPresentation;
            }
            ItemPresentation presentation2 = viewOptions == null ? this.getViewDescriptor().getPresentation() : this.getViewDescriptor().getCustomPresentation(viewOptions);
            this.myPresentation = presentation2 instanceof PresentationData ? (PresentationData)presentation2 : new PresentationData(presentation2.getPresentableText(), presentation2.getLocationString(), presentation2.getIcon(false), null);
            return this.myPresentation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceViewItem node = (ServiceViewItem)o;
            return this.myValue.equals(node.myValue);
        }

        public int hashCode() {
            return this.myValue.hashCode();
        }

        public String toString() {
            return this.myValue.toString();
        }
    }
}

