/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Queue;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TokenBuffer {
    static final TokenInfo CR_TOKEN = new TokenInfo(ConsoleViewContentType.SYSTEM_OUTPUT, "\r", null);
    private final int maxCapacity;
    private final Queue<TokenInfo> tokens = new Queue(10);
    private int size;
    private int startIndex;

    TokenBuffer(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    void print(@NotNull String text, @NotNull ConsoleViewContentType contentType, @Nullable HyperlinkInfo info) {
        int start2 = 0;
        while (start2 < text.length()) {
            TokenInfo tokenInfo;
            int crIndex;
            if (this.hasTrailingCR()) {
                this.combineTrailingCRWith(text);
            }
            if ((crIndex = text.indexOf(13, start2)) == -1 || crIndex == text.length() - 1) {
                tokenInfo = new TokenInfo(contentType, text.substring(start2), info);
                this.tokens.addLast((Object)tokenInfo);
                this.size += tokenInfo.length();
                break;
            }
            if (start2 != crIndex) {
                tokenInfo = new TokenInfo(contentType, text.substring(start2, crIndex), info);
                this.tokens.addLast((Object)tokenInfo);
                this.size += tokenInfo.length();
            }
            this.removeLastLine();
            start2 = crIndex + 1;
        }
        this.trim();
    }

    private boolean hasTrailingCR() {
        return !this.tokens.isEmpty() && this.tokens.peekLast() != CR_TOKEN && StringUtil.endsWithChar((CharSequence)((TokenInfo)this.tokens.peekLast()).getText(), (char)'\r');
    }

    private void combineTrailingCRWith(@NotNull String currentText) {
        if (StringUtil.startsWith((CharSequence)currentText, (CharSequence)"\n")) {
            TokenInfo last = (TokenInfo)this.tokens.removeLast();
            String lastTextWithNoCR = last.getText().substring(0, last.length() - 1);
            if (!lastTextWithNoCR.isEmpty()) {
                TokenInfo newLast = new TokenInfo(last.contentType, lastTextWithNoCR, last.getHyperlinkInfo());
                this.tokens.addLast((Object)newLast);
                --this.size;
            }
            return;
        }
        this.removeLastLine();
    }

    private void removeLastLine() {
        while (!this.tokens.isEmpty() && this.tokens.peekLast() != CR_TOKEN) {
            TokenInfo last = (TokenInfo)this.tokens.removeLast();
            String text = last.getText();
            int lfIndex = text.lastIndexOf(10);
            if (lfIndex != -1) {
                TokenInfo newToken = new TokenInfo(last.contentType, text.substring(0, lfIndex + 1), last.getHyperlinkInfo());
                this.tokens.addLast((Object)newToken);
                this.size -= text.length() - newToken.length();
                return;
            }
            this.size -= text.length();
        }
        if (this.tokens.isEmpty()) {
            this.tokens.addLast((Object)CR_TOKEN);
            ++this.size;
        }
    }

    private void trim() {
        while (this.size - this.startIndex > this.maxCapacity) {
            TokenInfo info = (TokenInfo)this.tokens.peekFirst();
            int length = info.length() - this.startIndex;
            if (length > this.size - this.maxCapacity) {
                this.startIndex += this.size - this.maxCapacity;
                break;
            }
            this.startIndex = 0;
            this.tokens.pullFirst();
            this.size -= info.length();
        }
    }

    int length() {
        return this.size - this.startIndex;
    }

    void clear() {
        this.tokens.clear();
        this.startIndex = 0;
        this.size = 0;
    }

    @NotNull
    CharSequence getText() {
        if (this.hasTrailingCR()) {
            this.removeLastLine();
        }
        return TokenBuffer.getRawText(this.getInfos());
    }

    @NotNull
    static CharSequence getRawText(@NotNull List<? extends TokenInfo> tokens) {
        int size = 0;
        for (TokenInfo tokenInfo : tokens) {
            size += tokenInfo.getText().length();
        }
        StringBuilder result2 = new StringBuilder(size);
        for (TokenInfo tokenInfo : tokens) {
            result2.append(tokenInfo.getText());
        }
        return result2.toString();
    }

    @NotNull
    List<TokenInfo> drain() {
        if (this.hasTrailingCR()) {
            this.removeLastLine();
        }
        try {
            List<TokenInfo> list2 = this.getInfos();
            return list2;
        }
        finally {
            this.clear();
        }
    }

    @NotNull
    private List<TokenInfo> getInfos() {
        List list2 = this.tokens.toList();
        if (this.startIndex != 0) {
            TokenInfo first = (TokenInfo)list2.get(0);
            TokenInfo sliced = new TokenInfo(first.contentType, first.getText().substring(this.startIndex), first.getHyperlinkInfo());
            return ContainerUtil.concat(Collections.singletonList(sliced), list2.subList(1, list2.size()));
        }
        return list2;
    }

    int getCycleBufferSize() {
        return this.maxCapacity;
    }

    static class TokenInfo {
        @NotNull
        final ConsoleViewContentType contentType;
        private final String text;
        private final HyperlinkInfo myHyperlinkInfo;

        TokenInfo(@NotNull ConsoleViewContentType contentType, @NotNull String text, @Nullable HyperlinkInfo hyperlinkInfo) {
            this.contentType = contentType;
            this.myHyperlinkInfo = hyperlinkInfo;
            this.text = text;
        }

        int length() {
            return this.text.length();
        }

        public String toString() {
            return this.contentType + "[" + this.length() + "]";
        }

        HyperlinkInfo getHyperlinkInfo() {
            return this.myHyperlinkInfo;
        }

        @NotNull
        String getText() {
            return this.text;
        }
    }
}

