/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.Executor;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.actions.RunDashboardActionUtils;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.content.Content;
import org.jetbrains.annotations.NotNull;

public class ClearContentAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        RunDashboardRunConfigurationNode node = project == null ? null : RunDashboardActionUtils.getTarget(e);
        boolean enabled = node != null && node.getContent() != null;
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled || !ActionPlaces.isPopupPlace((String)e.getPlace()));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        RunDashboardRunConfigurationNode node = RunDashboardActionUtils.getTarget(e);
        if (node == null) {
            return;
        }
        Content content2 = node.getContent();
        if (content2 == null) {
            return;
        }
        RunContentDescriptor descriptor2 = node.getDescriptor();
        if (descriptor2 == null) {
            return;
        }
        Executor executor = RunContentManagerImpl.getExecutorByContent(content2);
        if (executor == null) {
            return;
        }
        RunContentManager.getInstance((Project)project).removeRunContent(executor, descriptor2);
    }
}

