/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.StopAction;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardGroup;
import com.intellij.execution.dashboard.RunDashboardGroupingRule;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.execution.dashboard.RunDashboardNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.RunDashboardServiceViewDeleteProvider;
import com.intellij.execution.dashboard.tree.FolderDashboardGroupingRule;
import com.intellij.execution.dashboard.tree.GroupingNode;
import com.intellij.execution.dashboard.tree.RunConfigurationNode;
import com.intellij.execution.dashboard.tree.RunDashboardGroupImpl;
import com.intellij.execution.dashboard.tree.RunDashboardStatusFilter;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDnDDescriptor;
import com.intellij.execution.services.ServiceViewGroupingContributor;
import com.intellij.execution.services.ServiceViewLocatableDescriptor;
import com.intellij.execution.services.ServiceViewProvidingContributor;
import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunDashboardServiceViewContributor
implements ServiceViewGroupingContributor<RunConfigurationContributor, GroupingNode> {
    @NonNls
    private static final String RUN_DASHBOARD_CONTENT_TOOLBAR = "RunDashboardContentToolbar";
    private static final ServiceViewDescriptor CONTRIBUTOR_DESCRIPTOR = new SimpleServiceViewDescriptor("Run Dashboard", AllIcons.Actions.Execute){

        public ActionGroup getToolbarActions() {
            return RunDashboardServiceViewContributor.getToolbarActions(null);
        }

        public ActionGroup getPopupActions() {
            return RunDashboardServiceViewContributor.getPopupActions();
        }

        public DataProvider getDataProvider() {
            return id2 -> PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(id2) ? new RunDashboardServiceViewDeleteProvider() : null;
        }
    };

    @NotNull
    public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
        return CONTRIBUTOR_DESCRIPTOR;
    }

    @NotNull
    public List<RunConfigurationContributor> getServices(@NotNull Project project) {
        RunDashboardManagerImpl runDashboardManager = (RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project);
        return ContainerUtil.map(runDashboardManager.getRunConfigurations(), value2 -> new RunConfigurationContributor(new RunConfigurationNode(project, (RunDashboardManager.RunDashboardService)value2, RunDashboardManagerImpl.getCustomizers(value2.getSettings(), value2.getDescriptor()))));
    }

    @NotNull
    public ServiceViewDescriptor getServiceDescriptor(@NotNull Project project, @NotNull RunConfigurationContributor contributor) {
        return contributor.getViewDescriptor(project);
    }

    @NotNull
    public List<GroupingNode> getGroups(@NotNull RunConfigurationContributor contributor) {
        ArrayList<GroupingNode> result2 = new ArrayList<GroupingNode>();
        GroupingNode parentGroupNode = null;
        for (RunDashboardGroupingRule groupingRule : (RunDashboardGroupingRule[])RunDashboardManagerImpl.GROUPING_RULE_EP_NAME.getExtensions()) {
            RunDashboardGroup group = groupingRule.getGroup((AbstractTreeNode)contributor.asService());
            if (group == null) continue;
            GroupingNode node = new GroupingNode(contributor.asService().getProject(), parentGroupNode == null ? null : parentGroupNode.getGroup(), group);
            node.setParent(parentGroupNode);
            result2.add(node);
            parentGroupNode = node;
        }
        return result2;
    }

    @NotNull
    public ServiceViewDescriptor getGroupDescriptor(@NotNull GroupingNode node) {
        RunDashboardGroup group = node.getGroup();
        if (group instanceof FolderDashboardGroupingRule.FolderDashboardGroup) {
            return new RunDashboardFolderGroupViewDescriptor(node);
        }
        return new RunDashboardGroupViewDescriptor(node);
    }

    @NotNull
    private static JComponent createEmptyContent() {
        JBPanelWithEmptyText panel2 = new JBPanelWithEmptyText().withEmptyText(ExecutionBundle.message((String)"run.dashboard.not.started.configuration.message", (Object[])new Object[0]));
        panel2.setFocusable(true);
        return panel2;
    }

    private static ActionGroup getToolbarActions(@Nullable RunContentDescriptor descriptor2) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(ActionManager.getInstance().getAction(RUN_DASHBOARD_CONTENT_TOOLBAR));
        List leftToolbarActions = null;
        RunnerLayoutUiImpl ui = RunDashboardManagerImpl.getRunnerLayoutUi(descriptor2);
        if (ui != null) {
            leftToolbarActions = ui.getActions();
        } else {
            ActionToolbar toolbar = RunDashboardManagerImpl.findActionToolbar(descriptor2);
            if (toolbar != null) {
                leftToolbarActions = toolbar.getActions();
            }
        }
        if (leftToolbarActions != null) {
            for (AnAction action2 : leftToolbarActions) {
                if (action2 instanceof StopAction || action2 instanceof FakeRerunAction) continue;
                actionGroup.add(action2);
            }
        }
        return actionGroup;
    }

    private static ActionGroup getPopupActions() {
        DefaultActionGroup actions = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        actions.add(actionManager.getAction(RUN_DASHBOARD_CONTENT_TOOLBAR));
        actions.addSeparator();
        actions.add(actionManager.getAction("RunDashboardPopup"));
        return actions;
    }

    @Nullable
    private static RunDashboardRunConfigurationNode getRunConfigurationNode(@NotNull DnDEvent event, @NotNull Project project) {
        Object object = event.getAttachedObject();
        if (!(object instanceof DataProvider)) {
            return null;
        }
        Object data2 = ((DataProvider)object).getData(PlatformDataKeys.SELECTED_ITEMS.getName());
        if (!(data2 instanceof Object[])) {
            return null;
        }
        Object[] items = (Object[])data2;
        if (items.length != 1) {
            return null;
        }
        RunDashboardRunConfigurationNode node = (RunDashboardRunConfigurationNode)ObjectUtils.tryCast((Object)items[0], RunDashboardRunConfigurationNode.class);
        if (node != null && !node.getConfigurationSettings().getConfiguration().getProject().equals(project)) {
            return null;
        }
        return node;
    }

    static class RunConfigurationContributor
    implements ServiceViewProvidingContributor<AbstractTreeNode<?>, RunConfigurationNode> {
        private final RunConfigurationNode myNode;

        RunConfigurationContributor(@NotNull RunConfigurationNode node) {
            this.myNode = node;
        }

        @NotNull
        public RunConfigurationNode asService() {
            return this.myNode;
        }

        @NotNull
        public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
            return new RunConfigurationServiceViewDescriptor(this.myNode);
        }

        @NotNull
        public List<AbstractTreeNode<?>> getServices(@NotNull Project project) {
            return new ArrayList(this.myNode.getChildren());
        }

        @NotNull
        public ServiceViewDescriptor getServiceDescriptor(@NotNull Project project, final @NotNull AbstractTreeNode service) {
            return new ServiceViewDescriptor(){

                public ActionGroup getToolbarActions() {
                    return RunDashboardServiceViewContributor.getToolbarActions(null);
                }

                public ActionGroup getPopupActions() {
                    return RunDashboardServiceViewContributor.getPopupActions();
                }

                @NotNull
                public ItemPresentation getPresentation() {
                    return service.getPresentation();
                }

                @Nullable
                public String getId() {
                    List fragments;
                    ItemPresentation presentation2 = this.getPresentation();
                    String text = presentation2.getPresentableText();
                    if (!StringUtil.isEmpty((String)text)) {
                        return text;
                    }
                    if (presentation2 instanceof PresentationData && !(fragments = ((PresentationData)presentation2).getColoredText()).isEmpty()) {
                        StringBuilder result2 = new StringBuilder();
                        for (PresentableNodeDescriptor.ColoredFragment fragment : fragments) {
                            result2.append(fragment.getText());
                        }
                        return result2.toString();
                    }
                    return null;
                }

                @Nullable
                public Runnable getRemover() {
                    return service instanceof RunDashboardNode ? ((RunDashboardNode)service).getRemover() : null;
                }
            };
        }
    }

    private static class RunDashboardFolderGroupViewDescriptor
    extends RunDashboardGroupViewDescriptor
    implements ServiceViewDnDDescriptor {
        RunDashboardFolderGroupViewDescriptor(GroupingNode node) {
            super(node);
        }

        @Override
        @Nullable
        public Runnable getRemover() {
            return () -> {
                String groupName = this.myGroup.getName();
                Project project = ((FolderDashboardGroupingRule.FolderDashboardGroup)this.myGroup).getProject();
                List services = RunDashboardManager.getInstance((Project)project).getRunConfigurations();
                RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
                runManager.fireBeginUpdate();
                try {
                    for (RunDashboardManager.RunDashboardService service : services) {
                        RunnerAndConfigurationSettings settings = service.getSettings();
                        if (!groupName.equals(settings.getFolderName())) continue;
                        settings.setFolderName(null);
                    }
                }
                finally {
                    runManager.fireEndUpdate();
                }
            };
        }

        public boolean canDrop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            return position == ServiceViewDnDDescriptor.Position.INTO && RunDashboardServiceViewContributor.getRunConfigurationNode(event, ((FolderDashboardGroupingRule.FolderDashboardGroup)this.myGroup).getProject()) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            Project project = ((FolderDashboardGroupingRule.FolderDashboardGroup)this.myGroup).getProject();
            RunDashboardRunConfigurationNode node = RunDashboardServiceViewContributor.getRunConfigurationNode(event, project);
            if (node == null) {
                return;
            }
            RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
            runManager.fireBeginUpdate();
            try {
                node.getConfigurationSettings().setFolderName(this.myGroup.getName());
            }
            finally {
                runManager.fireEndUpdate();
            }
        }
    }

    private static class RunDashboardGroupViewDescriptor
    implements ServiceViewDescriptor,
    WeighedItem {
        protected final RunDashboardGroup myGroup;
        private final GroupingNode myNode;
        private final PresentationData myPresentationData;

        protected RunDashboardGroupViewDescriptor(GroupingNode node) {
            this.myNode = node;
            this.myGroup = node.getGroup();
            this.myPresentationData = new PresentationData();
            this.myPresentationData.setPresentableText(this.myGroup.getName());
            this.myPresentationData.setIcon(this.myGroup.getIcon());
        }

        @Nullable
        public String getId() {
            return RunDashboardGroupViewDescriptor.getId(this.myNode);
        }

        public ActionGroup getToolbarActions() {
            return RunDashboardServiceViewContributor.getToolbarActions(null);
        }

        public ActionGroup getPopupActions() {
            return RunDashboardServiceViewContributor.getPopupActions();
        }

        @NotNull
        public ItemPresentation getPresentation() {
            return this.myPresentationData;
        }

        public int getWeight() {
            Object value2 = ((RunDashboardGroupImpl)this.myGroup).getValue();
            if (value2 instanceof WeighedItem) {
                return ((WeighedItem)value2).getWeight();
            }
            return 0;
        }

        @Nullable
        public Runnable getRemover() {
            ConfigurationType type = (ConfigurationType)ObjectUtils.tryCast(((RunDashboardGroupImpl)this.myGroup).getValue(), ConfigurationType.class);
            if (type != null) {
                return () -> {
                    RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)this.myNode.getProject());
                    HashSet types = new HashSet(runDashboardManager.getTypes());
                    types.remove(type.getId());
                    runDashboardManager.setTypes(types);
                };
            }
            return null;
        }

        private static String getId(GroupingNode node) {
            AbstractTreeNode parent = node.getParent();
            if (parent instanceof GroupingNode) {
                return RunDashboardGroupViewDescriptor.getId((GroupingNode)parent) + "/" + RunDashboardGroupViewDescriptor.getId(node.getGroup());
            }
            return RunDashboardGroupViewDescriptor.getId(node.getGroup());
        }

        private static String getId(RunDashboardGroup group) {
            Object value2;
            if (group instanceof RunDashboardGroupImpl && (value2 = ((RunDashboardGroupImpl)group).getValue()) instanceof ConfigurationType) {
                return ((ConfigurationType)value2).getId();
            }
            return group.getName();
        }
    }

    private static class RunConfigurationServiceViewDescriptor
    implements ServiceViewDescriptor,
    ServiceViewLocatableDescriptor,
    ServiceViewDnDDescriptor {
        private final RunConfigurationNode myNode;

        RunConfigurationServiceViewDescriptor(RunConfigurationNode node) {
            this.myNode = node;
        }

        @Nullable
        public String getId() {
            RunConfiguration configuration = this.myNode.getConfigurationSettings().getConfiguration();
            return configuration.getType().getId() + "/" + configuration.getName();
        }

        public JComponent getContentComponent() {
            Content content2 = this.myNode.getContent();
            if (content2 == null) {
                return RunDashboardServiceViewContributor.createEmptyContent();
            }
            ContentManager contentManager2 = content2.getManager();
            return contentManager2 == null ? null : contentManager2.getComponent();
        }

        @NotNull
        public ItemPresentation getContentPresentation() {
            Content content2 = this.myNode.getContent();
            if (content2 != null) {
                return new PresentationData(content2.getDisplayName(), null, content2.getIcon(), null);
            }
            RunConfiguration configuration = this.myNode.getConfigurationSettings().getConfiguration();
            return new PresentationData(configuration.getName(), null, configuration.getIcon(), null);
        }

        public ActionGroup getToolbarActions() {
            return RunDashboardServiceViewContributor.getToolbarActions(this.myNode.getDescriptor());
        }

        public ActionGroup getPopupActions() {
            return RunDashboardServiceViewContributor.getPopupActions();
        }

        @NotNull
        public ItemPresentation getPresentation() {
            return this.myNode.getPresentation();
        }

        public DataProvider getDataProvider() {
            Content content2 = this.myNode.getContent();
            if (content2 == null) {
                return null;
            }
            DataContext context = DataManager.getInstance().getDataContext((Component)content2.getComponent());
            return arg_0 -> ((DataContext)context).getData(arg_0);
        }

        public void onNodeSelected() {
            Content content2 = this.myNode.getContent();
            if (content2 == null) {
                return;
            }
            ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject())).setSelectedContent(content2);
        }

        public void onNodeUnselected() {
            Content content2 = this.myNode.getContent();
            if (content2 == null) {
                return;
            }
            ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject())).removeFromSelection(content2);
        }

        @Nullable
        public Navigatable getNavigatable() {
            for (RunDashboardCustomizer customizer : this.myNode.getCustomizers()) {
                final PsiElement psiElement = customizer.getPsiElement((RunDashboardRunConfigurationNode)this.myNode);
                if (psiElement == null) continue;
                return new Navigatable(){

                    public void navigate(boolean requestFocus) {
                        PsiNavigateUtil.navigate((PsiElement)psiElement, (boolean)requestFocus);
                    }

                    public boolean canNavigate() {
                        return true;
                    }

                    public boolean canNavigateToSource() {
                        return true;
                    }
                };
            }
            return null;
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            for (RunDashboardCustomizer customizer : this.myNode.getCustomizers()) {
                PsiElement psiElement = customizer.getPsiElement((RunDashboardRunConfigurationNode)this.myNode);
                if (psiElement == null) continue;
                return PsiUtilCore.getVirtualFile((PsiElement)psiElement);
            }
            return null;
        }

        @Nullable
        public Object getPresentationTag(Object fragment) {
            Map links = (Map)this.myNode.getUserData(RunDashboardCustomizer.NODE_LINKS);
            return links == null ? null : links.get(fragment);
        }

        @Nullable
        public Runnable getRemover() {
            RunnerAndConfigurationSettings settings = this.myNode.getConfigurationSettings();
            RunManager runManager = RunManager.getInstance((Project)settings.getConfiguration().getProject());
            return runManager.hasSettings(settings) ? () -> runManager.removeConfiguration(settings) : null;
        }

        public boolean canDrop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            if (position != ServiceViewDnDDescriptor.Position.INTO) {
                return RunDashboardServiceViewContributor.getRunConfigurationNode(event, this.myNode.getConfigurationSettings().getConfiguration().getProject()) != null;
            }
            for (RunDashboardCustomizer customizer : this.myNode.getCustomizers()) {
                if (!customizer.canDrop((RunDashboardRunConfigurationNode)this.myNode, event)) continue;
                return true;
            }
            return false;
        }

        public void drop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            if (position != ServiceViewDnDDescriptor.Position.INTO) {
                Project project = this.myNode.getConfigurationSettings().getConfiguration().getProject();
                RunDashboardRunConfigurationNode node = RunDashboardServiceViewContributor.getRunConfigurationNode(event, project);
                if (node != null) {
                    this.reorderConfigurations(project, node, position);
                }
                return;
            }
            for (RunDashboardCustomizer customizer : this.myNode.getCustomizers()) {
                if (!customizer.canDrop((RunDashboardRunConfigurationNode)this.myNode, event)) continue;
                customizer.drop((RunDashboardRunConfigurationNode)this.myNode, event);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reorderConfigurations(Project project, RunDashboardRunConfigurationNode node, ServiceViewDnDDescriptor.Position position) {
            RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
            runManager.fireBeginUpdate();
            try {
                node.getConfigurationSettings().setFolderName(this.myNode.getConfigurationSettings().getFolderName());
                TObjectIntHashMap indices = new TObjectIntHashMap();
                int i2 = 0;
                for (RunnerAndConfigurationSettings each : runManager.getAllSettings()) {
                    if (each.equals(node.getConfigurationSettings())) continue;
                    if (each.equals(this.myNode.getConfigurationSettings())) {
                        if (position == ServiceViewDnDDescriptor.Position.ABOVE) {
                            indices.put((Object)node.getConfigurationSettings(), i2++);
                            indices.put((Object)this.myNode.getConfigurationSettings(), i2++);
                            continue;
                        }
                        if (position != ServiceViewDnDDescriptor.Position.BELOW) continue;
                        indices.put((Object)this.myNode.getConfigurationSettings(), i2++);
                        indices.put((Object)node.getConfigurationSettings(), i2++);
                        continue;
                    }
                    indices.put((Object)each, i2++);
                }
                runManager.setOrder(Comparator.comparingInt(arg_0 -> ((TObjectIntHashMap)indices).get(arg_0)));
            }
            finally {
                runManager.fireEndUpdate();
            }
        }

        public boolean isVisible() {
            RunDashboardStatusFilter statusFilter = ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject())).getStatusFilter();
            return statusFilter.isVisible(this.myNode);
        }
    }
}

