/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.util.Condition;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class ProcessBackedConsoleExecuteActionHandler
extends BaseConsoleExecuteActionHandler
implements Condition<LanguageConsoleView> {
    private volatile ProcessHandler myProcessHandler;

    public ProcessBackedConsoleExecuteActionHandler(ProcessHandler processHandler2, boolean preserveMarkup) {
        super(preserveMarkup);
        this.myProcessHandler = processHandler2;
    }

    public void setProcessHandler(@NotNull ProcessHandler processHandler2) {
        this.myProcessHandler = processHandler2;
    }

    @Override
    protected void execute(@NotNull String text, @NotNull LanguageConsoleView console) {
        this.processLine(text);
    }

    public void processLine(@NotNull String line) {
        this.sendText(line + "\n");
    }

    public void sendText(String line) {
        Charset charset = this.myProcessHandler instanceof BaseOSProcessHandler ? ((BaseOSProcessHandler)this.myProcessHandler).getCharset() : null;
        OutputStream outputStream = this.myProcessHandler.getProcessInput();
        assert (outputStream != null) : "output stream is null";
        try {
            byte[] bytes = charset != null ? line.getBytes(charset) : line.getBytes(StandardCharsets.UTF_8);
            outputStream.write(bytes);
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final boolean isProcessTerminated() {
        ProcessHandler handler2 = this.myProcessHandler;
        return handler2 == null || handler2.isProcessTerminated();
    }

    public boolean value(LanguageConsoleView console) {
        return !this.isProcessTerminated();
    }
}

